/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.util.NumberSet;

public class HashNumberSet
implements NumberSet {
    private static final int INITIALSHIFT = 3;
    private int hsize = 1 << this.nshift;
    private int nshift = 3;
    private int[] table = new int[this.hsize];
    private int nelem;

    private final int hash(int x) {
        return (x >> this.nshift ^ x) & this.hsize - 1;
    }

    public HashNumberSet(int max) {
        for (int i = 0; i < this.hsize; ++i) {
            this.table[i] = -1;
        }
        this.nelem = 0;
    }

    private void grow() {
        int i;
        int[] oldtable = this.table;
        int oldsize = this.hsize;
        ++this.nshift;
        this.hsize <<= 1;
        this.table = new int[this.hsize];
        for (i = 0; i < this.hsize; ++i) {
            this.table[i] = -1;
        }
        for (i = 0; i < oldsize; ++i) {
            int x = oldtable[i];
            if (x < 0) continue;
            int j = this.hash(x);
            while (this.table[j] >= 0) {
                j = j + 1 & this.hsize - 1;
            }
            this.table[j] = x;
        }
    }

    public int size() {
        return this.nelem;
    }

    public int tableSize() {
        return this.hsize;
    }

    public void clear() {
        for (int i = 0; i < this.hsize; ++i) {
            this.table[i] = -1;
        }
        this.nelem = 0;
    }

    public void add(int x) {
        if (x < 0) {
            return;
        }
        int i = this.hash(x);
        int n = 0;
        while (this.table[i] >= 0) {
            if (this.table[i] == x) {
                return;
            }
            i = i + 1 & this.hsize - 1;
            if (++n < this.hsize) continue;
            this.grow();
            this.add(x);
            return;
        }
        this.table[i] = x;
        ++this.nelem;
        if (n > this.nshift) {
            this.grow();
        }
    }

    public void addAll(NumberSet x) {
        x.addAllTo(this);
    }

    public void addAllTo(NumberSet x) {
        for (int i = 0; i < this.hsize; ++i) {
            if (this.table[i] < 0) continue;
            x.add(this.table[i]);
        }
    }

    public void remove(int x) {
        if (x < 0) {
            return;
        }
        int i = this.hash(x);
        for (int n = this.hsize; this.table[i] != -1 && n != 0; --n) {
            if (this.table[i] == x) {
                this.table[i] = -2;
                --this.nelem;
                return;
            }
            i = i + 1 & this.hsize - 1;
        }
    }

    public void removeAll(NumberSet x) {
        x.removeAllFrom(this);
    }

    public void removeAllFrom(NumberSet x) {
        for (int i = 0; i < this.hsize; ++i) {
            if (this.table[i] < 0) continue;
            x.remove(this.table[i]);
        }
    }

    public boolean contains(int x) {
        int i = this.hash(x);
        for (int n = this.hsize; this.table[i] != -1 && n != 0; --n) {
            if (this.table[i] == x) {
                return true;
            }
            i = i + 1 & this.hsize - 1;
        }
        return false;
    }

    public NumberSet.Iterator iterator() {
        return new Iterator(this);
    }

    public void toArray(int[] a) {
        int j = 0;
        for (int i = 0; i < this.hsize; ++i) {
            if (this.table[i] < 0) continue;
            a[j++] = this.table[i];
        }
    }

    public void copy(NumberSet x) {
        this.clear();
        this.addAll(x);
    }

    public boolean equals(Object x) {
        if (!(x instanceof HashNumberSet)) {
            return false;
        }
        HashNumberSet h = (HashNumberSet)x;
        if (h.nelem != this.nelem) {
            return false;
        }
        for (int i = 0; i < this.hsize; ++i) {
            if (this.table[i] < 0 || h.contains(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this;
    }

    public static class Iterator
    implements NumberSet.Iterator {
        HashNumberSet set;
        int ptr;

        public Iterator(HashNumberSet x) {
            this.set = x;
            this.ptr = 0;
        }

        public boolean hasNext() {
            while (this.ptr < this.set.hsize) {
                if (this.set.table[this.ptr] >= 0) {
                    return true;
                }
                ++this.ptr;
            }
            return false;
        }

        public int next() {
            while (this.ptr < this.set.hsize) {
                if (this.set.table[this.ptr] >= 0) {
                    return this.set.table[this.ptr++];
                }
                ++this.ptr;
            }
            return -1;
        }
    }
}

