/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.util.Misc;
import coins.backend.util.NumberSet;

public class BitMapSet
implements NumberSet {
    private int[] bitmap;
    static final int WORDSIZE = 32;

    public int size() {
        int n = 0;
        for (int i = 0; i < this.bitmap.length; ++i) {
            n += Misc.count1s(this.bitmap[i]);
        }
        return n;
    }

    public BitMapSet() {
        this.bitmap = new int[1];
    }

    public BitMapSet(int size) {
        this.bitmap = new int[(size + 31) / 32];
    }

    public void clear() {
        for (int i = 0; i < this.bitmap.length; ++i) {
            this.bitmap[i] = 0;
        }
    }

    private int[] grow(int[] map, int size) {
        int[] newmap = new int[size];
        for (int i = 0; i < map.length; ++i) {
            newmap[i] = map[i];
        }
        return newmap;
    }

    public void add(int x) {
        if (x < 0) {
            return;
        }
        int m = x / 32;
        if (m >= this.bitmap.length) {
            this.bitmap = this.grow(this.bitmap, m + 1);
        }
        int mask = 1 << x % 32;
        int n = m;
        this.bitmap[n] = this.bitmap[n] | mask;
    }

    public void remove(int x) {
        if (x < 0) {
            return;
        }
        int m = x / 32;
        if (m < this.bitmap.length) {
            int n = m;
            this.bitmap[n] = this.bitmap[n] & ~(1 << x % 32);
        }
    }

    public boolean exist(int x) {
        return this.contains(x);
    }

    public boolean contains(int x) {
        if (x < 0) {
            return false;
        }
        int m = x / 32;
        if (m < this.bitmap.length) {
            return (this.bitmap[m] & 1 << x % 32) != 0;
        }
        return false;
    }

    public void copy(NumberSet x) {
        if (x instanceof BitMapSet) {
            int i;
            BitMapSet y = (BitMapSet)x;
            if (this.bitmap.length < y.bitmap.length) {
                this.bitmap = new int[y.bitmap.length];
            }
            for (i = 0; i < y.bitmap.length; ++i) {
                this.bitmap[i] = y.bitmap[i];
            }
            while (i < this.bitmap.length) {
                this.bitmap[i] = 0;
                ++i;
            }
        } else {
            this.clear();
            NumberSet.Iterator it = x.iterator();
            while (it.hasNext()) {
                this.add(it.next());
            }
        }
    }

    public void addAll(NumberSet x) {
        x.addAllTo(this);
    }

    public void addAllTo(NumberSet x) {
        if (x instanceof BitMapSet) {
            ((BitMapSet)x).join(this);
        } else {
            int base = 0;
            for (int i = 0; i < this.bitmap.length; ++i) {
                for (int w = this.bitmap[i]; w != 0; w &= w - 1) {
                    x.add(base + Misc.binlog(w));
                }
                base += 32;
            }
        }
    }

    public void join(BitMapSet x) {
        if (x.bitmap.length > this.bitmap.length) {
            this.bitmap = this.grow(this.bitmap, x.bitmap.length);
        }
        for (int i = 0; i < this.bitmap.length; ++i) {
            int n = i;
            this.bitmap[n] = this.bitmap[n] | x.bitmap[i];
        }
    }

    public void meet(BitMapSet x) {
        int i;
        for (i = 0; i < this.bitmap.length && i < x.bitmap.length; ++i) {
            int n = i;
            this.bitmap[n] = this.bitmap[n] & x.bitmap[i];
        }
        while (i < this.bitmap.length) {
            this.bitmap[i] = 0;
            ++i;
        }
    }

    public void removeAll(NumberSet x) {
        x.removeAllFrom(this);
    }

    public void removeAllFrom(NumberSet x) {
        if (x instanceof BitMapSet) {
            ((BitMapSet)x).subtract(this);
        } else {
            int base = 0;
            for (int i = 0; i < this.bitmap.length; ++i) {
                for (int w = this.bitmap[i]; w != 0; w &= w - 1) {
                    x.remove(base + Misc.binlog(w));
                }
                base += 32;
            }
        }
    }

    public void subtract(BitMapSet x) {
        for (int i = 0; i < this.bitmap.length; ++i) {
            int n = i;
            this.bitmap[n] = this.bitmap[n] & ~x.bitmap[i];
        }
    }

    public int nextElement(int from) {
        int m = from / 32;
        if (m >= this.bitmap.length) {
            return -1;
        }
        int mask = this.bitmap[m] & ~((1 << from % 32) - 1);
        while (mask == 0) {
            if (++m >= this.bitmap.length) {
                return -1;
            }
            mask = this.bitmap[m];
        }
        return m * 32 + Misc.binlog(mask);
    }

    public NumberSet.Iterator iterator() {
        return new Iterator(this);
    }

    public void toArray(int[] a) {
        int j = 0;
        int base = 0;
        for (int i = 0; i < this.bitmap.length; ++i) {
            for (int w = this.bitmap[i]; w != 0; w &= w - 1) {
                a[j++] = base + Misc.binlog(w);
            }
            base += 32;
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof BitMapSet)) {
            return false;
        }
        int[] v = ((BitMapSet)x).bitmap;
        int n = this.bitmap.length;
        if (v.length < n) {
            n = v.length;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bitmap[i] == v[i]) continue;
            return false;
        }
        while (n < this.bitmap.length) {
            if (this.bitmap[n] != 0) {
                return false;
            }
            ++n;
        }
        while (n < v.length) {
            if (v[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object clone() {
        BitMapSet copy = new BitMapSet(this.bitmap.length * 32);
        for (int i = 0; i < this.bitmap.length; ++i) {
            copy.bitmap[i] = this.bitmap[i];
        }
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        String pref = "";
        int i = 0;
        while ((i = this.nextElement(i)) >= 0) {
            buf.append(pref + i);
            pref = " ";
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public static void main(String[] argv) {
        BitMapSet s = new BitMapSet();
        s.add(1);
        s.add(100);
        s.add(5);
        s.add(33);
        s.add(7);
        System.out.println("s = " + s);
        s.remove(5);
        System.out.println("s = " + s);
        BitMapSet t = new BitMapSet();
        t.add(5);
        t.add(100);
        System.out.println("t = " + t);
        BitMapSet a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.join(t);
        System.out.println("a + t = " + a);
        a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.meet(t);
        System.out.println("a & t = " + a);
        a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.subtract(t);
        System.out.println("a - t = " + a);
        a = (BitMapSet)s.clone();
        a.add(500);
        System.out.println("a = " + a);
        System.out.println("s = " + s);
        System.out.println("a==s? = " + a.equals(s));
        System.out.println("s==a? = " + s.equals(a));
        a.remove(500);
        System.out.println("a = " + a);
        System.out.println("a==s? = " + a.equals(s));
        System.out.println("s==a? = " + s.equals(a));
    }

    public static class Iterator
    implements NumberSet.Iterator {
        BitMapSet set;
        int nextNum;

        public Iterator(BitMapSet x) {
            this.set = x;
            this.nextNum = 0;
        }

        public boolean hasNext() {
            return this.set.nextElement(this.nextNum) >= 0;
        }

        public int next() {
            int val = this.set.nextElement(this.nextNum);
            this.nextNum = val + 1;
            return val;
        }
    }
}

