/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.CantHappenException;
import coins.backend.util.BiLink;
import java.util.Comparator;
import java.util.Iterator;

public class BiList
extends BiLink
implements Cloneable {
    public BiList() {
        this.next = this;
        this.prev = this;
    }

    public Object elem() {
        throw new UnsupportedOperationException();
    }

    public BiLink unlink() {
        throw new UnsupportedOperationException();
    }

    public BiLink next() {
        throw new UnsupportedOperationException("attempt to next past end");
    }

    public BiLink prev() {
        throw new UnsupportedOperationException("attempt to prev past end");
    }

    public BiLink first() {
        return this.next;
    }

    public BiLink last() {
        return this.prev;
    }

    public boolean atEnd() {
        return true;
    }

    public boolean isEmpty() {
        return this.next == this;
    }

    public BiLink add(Object obj) {
        return this.addBefore(obj);
    }

    public BiLink addAll(BiList list) {
        return this.addAllBefore(list);
    }

    public BiLink append(BiLink link) {
        return this.insertBefore(link);
    }

    public BiLink addFirst(Object obj) {
        return this.addAfter(obj);
    }

    public BiLink addAllFirst(BiList list) {
        return this.addAllAfter(list);
    }

    public BiLink prepend(BiLink link) {
        return this.insertAfter(link);
    }

    public Object takeLast() {
        if (this.prev == this) {
            throw new CantHappenException("takeLast from empty list");
        }
        Object obj = this.prev.elem;
        this.prev.unlink();
        return obj;
    }

    public Object takeFirst() {
        if (this.next == this) {
            throw new CantHappenException("takeFirst from empty list");
        }
        Object obj = this.next.elem;
        this.next.unlink();
        return obj;
    }

    public boolean contains(Object obj) {
        BiLink p = this.next;
        while (p != this) {
            if (p.elem == obj) {
                return true;
            }
            p = p.next;
        }
        return false;
    }

    public BiLink locate(Object obj) {
        BiLink p = this.next;
        while (p != this) {
            if (p.elem == obj) {
                return p;
            }
            p = p.next;
        }
        return null;
    }

    public BiLink locateEqual(Object obj) {
        BiLink p = this.next;
        while (p != this) {
            if (p.elem.equals(obj)) {
                return p;
            }
            p = p.next;
        }
        return null;
    }

    public int whereIs(Object obj) {
        int n = 0;
        BiLink p = this.next;
        while (p != this) {
            if (p.elem == obj) {
                return n;
            }
            ++n;
            p = p.next;
        }
        return -1;
    }

    public BiLink remove(Object obj) {
        BiLink p = this.locate(obj);
        if (p != null) {
            p.unlink();
        }
        return p;
    }

    public BiLink removeEqual(Object obj) {
        BiLink p = this.locateEqual(obj);
        if (p != null) {
            p.unlink();
        }
        return p;
    }

    public BiList addNew(Object obj) {
        if (!this.contains(obj)) {
            this.add(obj);
        }
        return this;
    }

    public void clear() {
        this.next = this.prev = this;
    }

    public BiList concatenate(BiList aList) {
        this.prev.next = aList.next;
        aList.next.prev = this.prev;
        this.prev = aList.prev;
        this.prev.next = this;
        aList.prev = null;
        aList.next = null;
        return this;
    }

    public BiList split(BiLink middle) {
        BiList secondHalf = new BiList();
        if (middle != this) {
            secondHalf.next = middle;
            secondHalf.prev = this.prev;
            this.prev.next = secondHalf;
            this.prev = middle.prev;
            middle.prev = secondHalf;
            this.prev.next = this;
        }
        return secondHalf;
    }

    public BiList copy() {
        BiList newList = new BiList();
        BiLink p = this.next;
        while (p != this) {
            newList.add(p.elem);
            p = p.next;
        }
        return newList;
    }

    public int length() {
        int n = 0;
        BiLink p = this.next;
        while (p != this) {
            if (p.atEnd()) {
                throw new CantHappenException("abnormal list: tail and head do not match");
            }
            ++n;
            p = p.next;
        }
        return n;
    }

    public void sort() {
        BiLink p = this.first();
        while (!p.atEnd()) {
            Comparable min = (Comparable)p.elem();
            BiLink q = p.next();
            while (!q.atEnd()) {
                BiLink next = q.next();
                Comparable y = (Comparable)q.elem();
                if (y.compareTo(min) < 0) {
                    q.unlink();
                    p.insertBefore(q);
                    p = q;
                    min = y;
                }
                q = next;
            }
            p = p.next();
        }
    }

    public void sort(Comparator cmp) {
        BiLink p = this.first();
        while (!p.atEnd()) {
            Object min = p.elem();
            BiLink q = p.next();
            while (!q.atEnd()) {
                BiLink next = q.next();
                Object y = q.elem();
                if (cmp.compare(y, min) < 0) {
                    q.unlink();
                    p.insertBefore(q);
                    p = q;
                    min = y;
                }
                q = next;
            }
            p = p.next();
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof BiList)) {
            return false;
        }
        if (this == (BiList)x) {
            return true;
        }
        BiLink p = this.first();
        BiLink q = ((BiList)x).first();
        while (p != this && q != (BiList)x) {
            if (!p.elem.equals(q.elem)) {
                return false;
            }
            p = p.next;
            q = q.next;
        }
        return p == this && q == (BiList)x;
    }

    public Object[] toArray() {
        int n = this.length();
        Object[] vec = new Object[n];
        int i = 0;
        BiLink p = this.next;
        while (p != this) {
            vec[i++] = p.elem;
            p = p.next;
        }
        return vec;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        boolean first = true;
        BiLink p = this.next;
        while (p != this) {
            if (!first) {
                buf.append(" ");
            }
            buf.append(p.elem.toString());
            first = false;
            p = p.next;
        }
        buf.append(")");
        return buf.toString();
    }

    public Object clone() {
        BiList obj = new BiList();
        obj.addAll(this);
        return obj;
    }

    public Iterator iterator() {
        return new BiListIterator(this);
    }

    public void sanityTest() {
        int n = 0;
        BiLink p = this.next;
        while (p != this) {
            if (p.next == null || p.prev == null) {
                throw new Error("BiList sanity: null pointer detected at link#" + n);
            }
            if (p.next.prev != p) {
                throw new Error("BiList sanity: next.prev != this at link#" + n);
            }
            ++n;
            p = p.next;
        }
    }

    private static void iteratorTest(Iterator it) {
        System.out.println("//<<<<<<<<");
        int n = 1;
        while (it.hasNext()) {
            Object elem = it.next();
            System.out.println(n + ": " + elem);
            ++n;
        }
        System.out.println(">>>>>>>>//");
    }

    public static void main(String[] args) {
        BiList alist = new BiList();
        BiList emptylist = new BiList();
        System.out.println(alist);
        alist.add(new Integer(123));
        System.out.println(alist);
        alist.add(new Integer(456));
        System.out.println(alist);
        alist.add(new Integer(789));
        System.out.println(alist);
        BiList.iteratorTest(alist.iterator());
        BiList.iteratorTest(emptylist.iterator());
        BiList blist = new BiList();
        blist.add("aho");
        blist.add("baka");
        BiList.iteratorTest(blist.iterator());
        alist = alist.concatenate(blist);
        BiList.iteratorTest(alist.iterator());
        BiList half = alist.split(alist.locate("baka"));
        BiList.iteratorTest(alist.iterator());
        BiList.iteratorTest(half.iterator());
        BiList slist = new BiList();
        slist.add("tokyo");
        slist.add("newyork");
        slist.add("london");
        slist.add("paris");
        slist.add("rome");
        slist.add("berlin");
        slist.add("moscow");
        slist.add("beijing");
        slist.add("geneve");
        System.out.println("Before sort:" + slist);
        slist.sort();
        System.out.println("After sort:" + slist);
    }

    class BiListIterator
    implements Iterator {
        BiLink current;

        BiListIterator(BiList list) {
            this.current = list.next;
        }

        public boolean hasNext() {
            return !this.current.atEnd();
        }

        public Object next() {
            Object content = this.current.elem;
            this.current = this.current.next;
            return content;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

