/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sim;

import coins.backend.Root;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;

public class TypicalPattern {
    public boolean localAnalyze(String machine, LirNode node, Root root) {
        return false;
    }

    public final boolean analyze(LirNode node, String machine, Root root) {
        boolean res = this.localAnalyze(machine, node, root);
        if (res) {
            return true;
        }
        LirNode knode = node.kid(0);
        switch (knode.opCode) {
            case 4: 
            case 5: {
                return true;
            }
            case 6: {
                String rname = ((LirSymRef)knode).symbol.name;
                return this.frameregister(rname, machine);
            }
            case 10: 
            case 11: {
                if (knode.opCode == 10) {
                    String opcode = "ADD";
                } else {
                    String opcode = "SUB";
                }
                LirNode rnode = knode.kid(0);
                if (rnode.opCode == 6) {
                    String rname = ((LirSymRef)rnode).symbol.name;
                    if (this.frameregister(rname, machine)) {
                        LirNode onode = knode.kid(1);
                        if (onode.opCode == 2) {
                            String offset = new Long(((LirIconst)onode).value).toString();
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isFrameRegister(String rname, String machine) {
        return false;
    }

    public final boolean frameregister(String rname, String machine) {
        String fp;
        if (this.isFrameRegister(rname, machine)) {
            return true;
        }
        if (machine.equals("x86")) {
            fp = "%ebp";
        } else if (machine.equals("arm")) {
            fp = "%fp";
        } else {
            return false;
        }
        String newname = rname.substring(0, fp.length());
        return newname.equals(fp);
    }
}

