/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.regalo;

import coins.backend.CantHappenException;
import coins.backend.CollectVarInTree;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalAnalyzer;
import coins.backend.LocalTransformer;
import coins.backend.MachineParams;
import coins.backend.Root;
import coins.backend.ana.EnumRegVars;
import coins.backend.ana.InterferenceGraph;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.BitMapSet;
import coins.backend.util.ImList;
import coins.backend.util.NumberSet;
import coins.backend.util.UnionFind;
import coins.backend.util.VectorSet;

public class RegisterAllocation {
    public static final Trigger trig = new Trigger();
    private Function func;
    private LirFactory newLir;
    private MachineParams machine;
    private Root root;
    private LoopAnalysis loopInfo;
    private EnumRegVars rn;
    private LiveVariableAnalysis liveInfo;
    private InterferenceGraph idg;
    private UnionFind ufo;
    private int[] name;
    private Symbol[] regvars;
    private int nRegvars;
    private int nPhyRegs;
    private int[] regset;
    private int[] navail;
    private int[] assignedReg;
    private int[] degree;
    private int[] spillCost;
    private boolean[] dontspill;
    private int[] status;
    static final int VAR_WORKING = 1;
    static final int VAR_ONSTACK = 2;
    static final int VAR_COALESCED = 3;
    static final int VAR_SPILLED = 4;
    static final int VAR_ASSIGNED = 5;
    private int[] toBeAssigned;
    private int stackp;
    private BiList spilledVars;
    private BiList assignedVars;
    private BiList working;
    private BiList copyPairs;
    private static int INFINITY = 9999999;
    private static final boolean newReplaceMethod = true;
    private static final int REF_USE = 1;
    private static final int REF_DEF = 2;

    private boolean doIt(Function f) {
        this.func = f;
        this.newLir = this.func.newLir;
        this.machine = this.func.module.targetMachine.machineParams;
        this.root = this.func.root;
        this.loopInfo = (LoopAnalysis)this.func.require(LoopAnalysis.analyzer);
        this.rn = (EnumRegVars)this.func.require(EnumRegVars.analyzer);
        this.liveInfo = (LiveVariableAnalysis)this.func.require(LiveVariableSlotwise.analyzer);
        this.idg = (InterferenceGraph)this.func.require(InterferenceGraph.analyzerCopyNotInterfere);
        if (this.root.traceOK("RegisterAllocation", 2)) {
            this.root.debOut.println();
            this.root.debOut.println("After live var. analysis/interference graph:");
            this.func.printIt(this.root.debOut, new LocalAnalyzer[]{LiveVariableSlotwise.analyzer, InterferenceGraph.analyzerCopyNotInterfere});
        }
        this.prepare();
        this.toBeAssigned = new int[this.nRegvars];
        this.stackp = 0;
        while (this.coalesce() || this.simplify() || this.chooseSpill()) {
        }
        if (!this.working.isEmpty()) {
            if (this.root.traceOK("RegisterAllocation", 2)) {
                this.root.debOut.println("worklist not empty, left:");
                BiLink p = this.working.first();
                while (!p.atEnd()) {
                    int v = this.rn.index((Symbol)p.elem());
                    this.root.debOut.println(this.rn.toString(v) + ": " + " degree=" + this.degree[v] + " avail=" + this.navail[v] + " distf=" + this.idg.disturbedFactor(v) + " spillcost=" + this.spillCost[v]);
                    p = p.next();
                }
            }
            throw new CantHappenException("working list not empty");
        }
        this.spilledVars = new BiList();
        this.assignedVars = new BiList();
        this.assignRegisters();
        if (this.spilledVars.isEmpty()) {
            this.replaceRegisters();
            if (this.root.traceOK("RegisterAllocation", 1)) {
                this.root.debOut.println();
                this.root.debOut.println("After RegisterAllocation (success):");
                this.func.printIt(this.root.debOut);
            }
            return true;
        }
        this.rewrite();
        if (this.root.traceOK("RegisterAllocation", 1)) {
            this.root.debOut.println();
            this.root.debOut.println("After RegisterAllocation (fail):");
            this.func.printIt(this.root.debOut);
        }
        return false;
    }

    private void prepare() {
        int i;
        this.nRegvars = this.rn.nRegvars();
        this.nPhyRegs = this.rn.nPhyRegs();
        this.name = new int[this.nRegvars];
        this.ufo = new UnionFind(this.nRegvars);
        this.status = new int[this.nRegvars];
        this.working = new BiList();
        for (i = 1; i < this.nRegvars; ++i) {
            if (i < this.nPhyRegs) {
                this.status[i] = 1;
            } else {
                this.working.add(this.rn.toSymbol(i));
                this.status[i] = 1;
            }
            this.name[i] = i;
        }
        this.degree = new int[this.nRegvars];
        this.regset = new int[this.nRegvars];
        this.navail = new int[this.nRegvars];
        this.assignedReg = new int[this.nRegvars];
        this.dontspill = new boolean[this.nRegvars];
        for (i = 1; i < this.nPhyRegs; ++i) {
            this.assignedReg[i] = i;
            this.regset[i] = i;
            this.navail[i] = 1;
        }
        BiLink p = this.working.first();
        while (!p.atEnd()) {
            int v = this.rn.index((Symbol)p.elem());
            this.assignedReg[v] = 0;
            this.regset[v] = this.getRegSet(this.rn.toSymbol(v));
            this.navail[v] = this.machine.nAvail(this.regset[v]);
            this.dontspill[v] = this.isDontspill(this.rn.toSymbol(v));
            p = p.next();
        }
        for (int i2 = 1; i2 < this.nRegvars; ++i2) {
            this.degree[i2] = 0;
            NumberSet.Iterator p2 = this.idg.interfereSet(i2).iterator();
            while (p2.hasNext()) {
                int t = p2.next();
                int n = this.machine.igWeight(this.regset[i2], this.regset[t]);
                if (n == 0 || this.machine.covered(t, this.idg.interfereSet(i2))) {
                    this.idg.unsetInterfere(i2, t);
                    continue;
                }
                int n2 = i2;
                this.degree[n2] = this.degree[n2] + n;
            }
        }
        this.copyPairs = new BiList();
        this.spillCost = new int[this.rn.nRegvars()];
        VectorSet work = new VectorSet(this.nRegvars);
        CollectVarInTree cv = new CollectVarInTree(this.func);
        BiLink p3 = this.func.flowGraph().basicBlkList.first();
        while (!p3.atEnd()) {
            BasicBlk blk = (BasicBlk)p3.elem();
            int loopFactor = 1 << this.loopInfo.nestLevel[blk.id] * 3;
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                if (ins.opCode == 48) {
                    int dst = this.rn.index(ins.kid(0));
                    int src = this.rn.index(ins.kid(1));
                    if (dst != 0 && src != 0) {
                        this.addCopyPair(dst, src);
                    }
                } else if (ins.opCode == 56) {
                    int n = ins.nKids();
                    for (int i3 = 0; i3 < n; ++i3) {
                        if (ins.kid((int)i3).opCode != 48) continue;
                        int dst = this.rn.index(ins.kid(i3).kid(0));
                        int src = this.rn.index(ins.kid(i3).kid(1));
                        if (dst == 0 || src == 0) continue;
                        this.addCopyPair(dst, src);
                    }
                }
                if (ins.opCode != 59) {
                    cv.getUseVars(ins, work);
                    NumberSet.Iterator it = work.iterator();
                    while (it.hasNext()) {
                        int n = it.next();
                        this.spillCost[n] = this.spillCost[n] + loopFactor;
                    }
                    cv.getDefVars(ins, work);
                    it = work.iterator();
                    while (it.hasNext()) {
                        int n = it.next();
                        this.spillCost[n] = this.spillCost[n] + loopFactor;
                    }
                }
                q = q.next();
            }
            p3 = p3.next();
        }
        if (this.root.traceOK("RegisterAllocation", 2)) {
            this.root.debOut.print("copy pairs: ");
            p3 = this.copyPairs.first();
            while (!p3.atEnd()) {
                CopyPair pair = (CopyPair)p3.elem();
                this.root.debOut.println("  " + this.rn.toString(pair.x) + "=" + this.rn.toString(pair.y) + (this.idg.interfere(pair.x, pair.y) ? "* " : " "));
                p3 = p3.next();
            }
            for (int i4 = this.nPhyRegs; i4 < this.nRegvars; ++i4) {
                this.root.debOut.println("var " + this.rn.toString(i4) + ": spillcost=" + this.spillCost[i4] + " degree=" + this.degree[i4] + " disturb=" + this.idg.disturbedFactor(i4) + " regset=[" + this.rn.toString(this.machine.regSetMap(this.regset[i4])) + "]");
            }
        }
    }

    private void addCopyPair(int x, int y) {
        this.copyPairs.add(new CopyPair(x, y));
        BiLink p = this.working.locate(this.rn.toSymbol(x));
        if (p != null) {
            p.unlink();
            this.working.append(p);
        }
        if ((p = this.working.locate(this.rn.toSymbol(y))) != null) {
            p.unlink();
            this.working.append(p);
        }
    }

    private boolean isPhysical(Symbol x) {
        return this.rn.index(x) < this.nPhyRegs;
    }

    private boolean isPhysical(int x) {
        return x < this.nPhyRegs;
    }

    private boolean interfere(int x, int y) {
        if (this.idg.interfere(x, y)) {
            return true;
        }
        if (this.isPhysical(x)) {
            short[] v = this.machine.overlapRegs(x);
            for (int i = 0; i < v.length; ++i) {
                if (!this.idg.interfere(v[i], y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean coalesce() {
        BiLink p = this.copyPairs.first();
        while (!p.atEnd()) {
            CopyPair pair = (CopyPair)p.elem();
            int x = this.nameOf(pair.x);
            int y = this.nameOf(pair.y);
            if (this.isPhysical(y)) {
                int w = x;
                x = y;
                y = w;
            }
            if (x == y) {
                if (this.root.traceOK("RegisterAllocation", 2)) {
                    this.root.debOut.println("coalesce:pair(" + this.rn.toString(pair.x) + "=" + this.rn.toString(pair.y) + ") already coalesced");
                }
                p.unlink();
            } else if (this.interfere(x, y) || this.machine.andSet(this.regset[x], this.regset[y]) == 0) {
                if (this.root.traceOK("RegisterAllocation", 2)) {
                    this.root.debOut.println("coalesce:pair(" + this.rn.toString(pair.x) + "=" + this.rn.toString(pair.y) + ") interfering");
                }
                p.unlink();
            } else if (this.conservative(x, y)) {
                int t;
                NumberSet.Iterator q;
                if (this.root.traceOK("RegisterAllocation", 2)) {
                    this.root.debOut.print("coalesce:pair(" + this.rn.toString(pair.x) + "=" + this.rn.toString(pair.y) + ") coalesced to " + this.rn.toString(x) + " degree: " + this.degree[x]);
                }
                p.unlink();
                this.name[this.ufo.union((int)x, (int)y)] = x;
                int regsetxy = this.machine.andSet(this.regset[x], this.regset[y]);
                if (regsetxy != this.regset[x]) {
                    q = this.idg.interfereSet(x).iterator();
                    while (q.hasNext()) {
                        t = q.next();
                        int dx = this.machine.igWeight(regsetxy, this.regset[t]);
                        if (dx == 0) {
                            this.idg.unsetInterfere(x, t);
                        }
                        if (this.status[t] == 1) {
                            int n = x;
                            this.degree[n] = this.degree[n] + (dx - this.machine.igWeight(this.regset[x], this.regset[t]));
                        }
                        int n = t;
                        this.degree[n] = this.degree[n] + (this.machine.igWeight(this.regset[t], regsetxy) - this.machine.igWeight(this.regset[t], this.regset[x]));
                    }
                }
                q = this.idg.interfereSet(y).iterator();
                while (q.hasNext()) {
                    t = q.next();
                    if (this.machine.igWeight(regsetxy, this.regset[t]) == 0 || !this.idg.setInterfere(x, t)) continue;
                    if (this.status[t] == 1) {
                        int n = x;
                        this.degree[n] = this.degree[n] + this.machine.igWeight(regsetxy, this.regset[t]);
                    }
                    int n = t;
                    this.degree[n] = this.degree[n] + this.machine.igWeight(this.regset[t], regsetxy);
                }
                this.regset[x] = regsetxy;
                this.navail[x] = this.machine.nAvail(regsetxy);
                int n = x;
                this.spillCost[n] = this.spillCost[n] + this.spillCost[y];
                this.idg.disturbSet(x).addAll(this.idg.disturbSet(y));
                this.removeNode(y);
                this.status[y] = 3;
                if (this.root.traceOK("RegisterAllocation", 2)) {
                    this.root.debOut.println(" to " + this.degree[x]);
                }
                return true;
            }
            p = p.next();
        }
        return false;
    }

    boolean conservative(int x, int y) {
        int t;
        int regsetxy = this.machine.andSet(this.regset[x], this.regset[y]);
        boolean georgeCond = this.isPhysical(x);
        int k = 0;
        NumberSet.Iterator p = this.idg.interfereSet(x).iterator();
        while (p.hasNext()) {
            t = p.next();
            if (this.machine.igWeight(this.regset[t], regsetxy) == 0) continue;
            if (this.idg.interfere(t, y)) {
                if (this.degree[t] - 1 < this.navail[t]) continue;
                k += this.machine.igWeight(regsetxy, this.regset[t]);
                continue;
            }
            if (this.degree[t] < this.navail[t]) continue;
            k += this.machine.igWeight(regsetxy, this.regset[t]);
        }
        p = this.idg.interfereSet(y).iterator();
        while (p.hasNext()) {
            t = p.next();
            if (this.machine.igWeight(regsetxy, this.regset[t]) == 0 || this.idg.interfere(t, x) || this.degree[t] < this.navail[t]) continue;
            k += this.machine.igWeight(regsetxy, this.regset[t]);
            georgeCond = false;
        }
        return k < this.machine.nAvail(regsetxy) || georgeCond;
    }

    private boolean simplify() {
        BiLink p = this.working.first();
        while (!p.atEnd()) {
            int v = this.rn.index((Symbol)p.elem());
            if (this.degree[v] < this.navail[v]) {
                if (this.root.traceOK("RegisterAllocation", 2)) {
                    this.root.debOut.println("simplify: " + this.rn.toString(v) + " on stack");
                }
                this.toBeAssigned[this.stackp++] = v;
                this.removeNode(v);
                this.status[v] = 2;
                return true;
            }
            p = p.next();
        }
        return false;
    }

    private boolean chooseSpill() {
        int chosen = -1;
        int chosenFactor = 0;
        BiLink p = this.working.first();
        while (!p.atEnd()) {
            int v = this.rn.index((Symbol)p.elem());
            int factor = this.idg.disturbedFactor(v) - this.idg.disturbingFactor(v);
            if (this.isPhysical(v)) {
                throw new CantHappenException("physical register on working list");
            }
            if (!this.dontspill[v]) {
                if (chosen < 0) {
                    chosen = v;
                    chosenFactor = factor;
                } else {
                    int d = factor - chosenFactor;
                    if (d > 0 || d == 0 && (this.navail[v] > this.navail[chosen] || this.navail[v] == this.navail[chosen] && this.spillCost[v] < this.spillCost[chosen])) {
                        chosen = v;
                        chosenFactor = factor;
                    }
                }
            }
            p = p.next();
        }
        if (chosen < 0) {
            return false;
        }
        if (this.root.traceOK("RegisterAllocation", 2)) {
            this.root.debOut.println("chooseSpill: " + this.rn.toString(chosen) + " on stack, " + " degree=" + this.degree[chosen] + " avail=" + this.navail[chosen] + " disturbf=" + chosenFactor + " spillcost=" + this.spillCost[chosen]);
        }
        this.toBeAssigned[this.stackp++] = chosen;
        this.removeNode(chosen);
        this.status[chosen] = 2;
        return true;
    }

    private void removeNode(int v) {
        this.working.remove(this.rn.toSymbol(v));
        Object p = this.idg.interfereSet(v).iterator();
        while (p.hasNext()) {
            int w;
            int n = w = p.next();
            this.degree[n] = this.degree[n] - this.machine.igWeight(this.regset[w], this.regset[v]);
        }
        p = this.copyPairs.first();
        while (!((BiLink)p).atEnd()) {
            CopyPair pair = (CopyPair)((BiLink)p).elem();
            if (this.nameOf(pair.x) == v || this.nameOf(pair.y) == v) {
                ((BiLink)p).unlink();
            }
            p = ((BiLink)p).next();
        }
    }

    private void assignRegisters() {
        while (this.stackp > 0) {
            int v = this.toBeAssigned[--this.stackp];
            BitMapSet avail = (BitMapSet)this.machine.regSetMap(this.regset[v]).clone();
            NumberSet.Iterator p = this.idg.interfereSet(v).iterator();
            while (p.hasNext()) {
                int w = p.next();
                if (this.assignedReg[w] <= 0) continue;
                this.machine.removeRegister(avail, this.assignedReg[w]);
            }
            this.assignedReg[v] = avail.nextElement(1);
            if (this.assignedReg[v] < 0) {
                this.spilledVars.add(this.rn.toSymbol(v));
                this.status[v] = 4;
                if (!this.root.traceOK("RegisterAllocation", 2)) continue;
                this.root.debOut.println("assign: " + this.rn.toString(v) + " spilled.");
                continue;
            }
            this.assignedVars.add(this.rn.toSymbol(v));
            this.status[v] = 5;
            if (!this.root.traceOK("RegisterAllocation", 2)) continue;
            this.root.debOut.println("assign: " + this.rn.toString(v) + " assigned to: " + this.machine.registerToString(this.assignedReg[v]));
        }
    }

    private void replaceRegisters() {
        BiLink p = this.func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BiLink q = ((BasicBlk)p.elem()).instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                this.replaceInst(ins);
                if (ins.opCode == 48 && (ins.kid((int)0).opCode == 6 || ins.kid((int)0).opCode == 7) && ins.kid(0).equals(ins.kid(1))) {
                    q.unlink();
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void replaceInst(LirNode tree) {
        int n = tree.nKids();
        for (int i = 0; i < n; ++i) {
            if (tree.kid((int)i).opCode == 6) {
                int v;
                if (this.isPhysical(((LirSymRef)tree.kid((int)i)).symbol) || this.assignedReg[v = this.nameOf(this.rn.index(tree.kid(i)))] <= 0) continue;
                tree.setKid(i, this.machine.registerLir(this.assignedReg[v]));
                continue;
            }
            this.replaceInst(tree.kid(i));
        }
    }

    private void rewrite() {
        BiLink s = this.spilledVars.first();
        while (!s.atEnd()) {
            Symbol v = (Symbol)s.elem();
            Symbol frv = this.func.addSymbol("save_" + v.name, 1, v.type, v.boundary, 0, v.opt());
            boolean tmpn = true;
            BiLink p = this.func.flowGraph().basicBlkList.first();
            while (!p.atEnd()) {
                BiLink q = ((BasicBlk)p.elem()).instrList().first();
                while (!q.atEnd()) {
                    LirNode ins = (LirNode)q.elem();
                    if (this.replaceRegToFrame(ins, v, frv)) {
                        q.setElem(this.newLir.replaceOptions(ins, this.removeInstT(ins.opt)));
                    }
                    q = q.next();
                }
                p = p.next();
            }
            s = s.next();
        }
    }

    private boolean replaceRegToFrame(LirNode tree, Symbol old, Symbol neu) {
        int oldi = this.rn.index(old);
        int n = tree.nKids();
        boolean changed = false;
        for (int i = 0; i < n; ++i) {
            if (tree.kid((int)i).opCode == 6) {
                if (this.nameOf(this.rn.index(tree.kid(i))) != oldi) continue;
                tree.setKid(i, this.newLir.node(47, old.type, this.newLir.symRef(neu)));
                changed = true;
                continue;
            }
            changed |= this.replaceRegToFrame(tree.kid(i), old, neu);
        }
        return changed;
    }

    private ImList removeInstT(ImList options) {
        if (options == null || options.atEnd() || options.next().atEnd()) {
            return options;
        }
        if (options.elem() == "&inst" && options.elem2nd() == "t") {
            return options.next2nd();
        }
        Object car = options.elem();
        ImList next = options.next();
        ImList newNext = this.removeInstT(next);
        if (newNext == next) {
            return options;
        }
        return new ImList(car, newNext);
    }

    private int hasReference(LirNode tree, Symbol v) {
        int vi = this.rn.index(v);
        int reftype = 0;
        switch (tree.opCode) {
            case 56: {
                int n = tree.nKids();
                for (int i = 0; i < n; ++i) {
                    reftype |= this.hasReference(tree.kid(i), v);
                }
                break;
            }
            case 48: {
                if (tree.kid((int)0).opCode == 47) {
                    reftype |= this.hasReference(tree.kid(0), v);
                } else if (tree.kid((int)0).opCode == 6 && this.nameOf(this.rn.index(tree.kid(0))) == vi) {
                    reftype |= 2;
                }
                reftype |= this.hasReference(tree.kid(1), v);
                break;
            }
            case 58: {
                break;
            }
            case 53: {
                int n = tree.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    if (!tree.kid(2).kid(i).isRegisterOperand() || tree.kid((int)2).kid((int)i).opCode != 6 || this.nameOf(this.rn.index(tree.kid(2).kid(i))) != vi) continue;
                    reftype |= 2;
                }
                reftype |= this.hasReference(tree.kid(0), v);
                reftype |= this.hasReference(tree.kid(1), v);
                break;
            }
            case 54: {
                int n = tree.nKids();
                for (int i = 1; i < n; ++i) {
                    if (!tree.kid(i).isRegisterOperand() || tree.kid((int)i).opCode != 6 || this.nameOf(this.rn.index(tree.kid(i))) != vi) continue;
                    reftype |= 2;
                }
                break;
            }
            case 6: {
                if (this.nameOf(this.rn.index(tree)) != vi) break;
                reftype |= 1;
                break;
            }
            default: {
                int n = tree.nKids();
                for (int i = 0; i < n; ++i) {
                    reftype |= this.hasReference(tree.kid(i), v);
                }
            }
        }
        return reftype;
    }

    private void replaceVar(LirNode tree, Symbol old, Symbol neu) {
        int oldi = this.rn.index(old);
        int n = tree.nKids();
        for (int i = 0; i < n; ++i) {
            if (tree.kid((int)i).opCode == 6) {
                if (this.nameOf(this.rn.index(tree.kid(i))) != oldi) continue;
                tree.setKid(i, this.newLir.symRef(neu));
                continue;
            }
            this.replaceVar(tree.kid(i), old, neu);
        }
    }

    private String regsetName(Symbol regvar) {
        ImList p = regvar.opt();
        while (!p.atEnd()) {
            if (p.elem() == "&regset") {
                return (String)p.elem2nd();
            }
            p = p.next();
        }
        return "*reg*";
    }

    private int getRegSet(Symbol regvar) {
        return this.machine.getRegSet(this.regsetName(regvar));
    }

    private boolean isDontspill(Symbol regvar) {
        ImList p = regvar.opt();
        while (!p.atEnd()) {
            if (p.elem() == "&dontspill") {
                return true;
            }
            p = p.next();
        }
        return false;
    }

    int nameOf(int x) {
        if (x < 0) {
            return x;
        }
        if (x >= this.nRegvars) {
            this.root.debOut.println("Array index out of bounds: " + this.rn.toString(x));
            return x;
        }
        return this.name[this.ufo.find(x)];
    }

    boolean isAlreadySplit(Symbol sym) {
        int pos = sym.name.indexOf(37);
        return pos >= 0 && sym.name.indexOf(37, pos + 1) >= 0;
    }

    static class CopyPair {
        public final int x;
        public final int y;

        public CopyPair(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            return new RegisterAllocation().doIt(func);
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "RegisterAllocation";
        }

        public String subject() {
            return "Register Allocation";
        }
    }
}

