/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Root;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;

public class LoopInversion {
    public static final Trigger trig = new Trigger();
    private Root root;
    private FlowGraph g;
    private LoopAnalysis loop;
    private int[] order;
    private BiLink[] link;

    public void doIt(Function f) {
        this.root = f.root;
        this.g = f.flowGraph();
        this.loop = (LoopAnalysis)f.require(LoopAnalysis.analyzer);
        this.order = new int[this.g.idBound()];
        this.link = new BiLink[this.g.idBound()];
        int i = 1;
        BiLink p = this.g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.link[blk.id] = p;
            this.order[blk.id] = i++;
            p = p.next();
        }
        p = this.loop.kids[0].first();
        while (!p.atEnd()) {
            BasicBlk head = (BasicBlk)p.elem();
            this.invertLoop(head);
            p = p.next();
        }
        this.g.touch();
    }

    private void invertLoop(BasicBlk head) {
        BiLink p = this.loop.kids[head.id].first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (this.loop.isLoop[blk.id]) {
                this.invertLoop(blk);
            }
            p = p.next();
        }
        BasicBlk tail = null;
        BasicBlk exit = null;
        BiLink p2 = head.predList().first();
        while (!p2.atEnd()) {
            BasicBlk blk = (BasicBlk)p2.elem();
            if (this.loop.loopHeader[blk.id] == head && ((LirNode)blk.instrList().last().elem()).opCode == 49 && this.order[blk.id] > this.order[head.id]) {
                BasicBlk next = (BasicBlk)this.link[blk.id].next().elem();
                if (this.loop.loopHeader[next.id] != head) {
                    BiLink q = next.predList().first();
                    while (!q.atEnd()) {
                        BasicBlk x = (BasicBlk)q.elem();
                        Object[] succ = x.succList().toArray();
                        if (!(x != head && this.loop.loopHeader[x.id] != head || ((LirNode)x.instrList().last().elem()).opCode != 50 || this.loop.loopHeader[((BasicBlk)succ[0]).id] != head && this.loop.loopHeader[((BasicBlk)succ[1]).id] != head)) {
                            exit = x;
                            tail = blk;
                            break;
                        }
                        q = q.next();
                    }
                    if (tail != null) break;
                }
            }
            p2 = p2.next();
        }
        if (tail == null) {
            return;
        }
        BiList upper = this.g.basicBlkList.split(this.link[head.id]);
        BiList lower = upper.split(this.link[exit.id].next());
        BiList after = lower.split(this.link[tail.id].next());
        BiLink top = lower.first();
        this.g.basicBlkList.concatenate(lower);
        this.g.basicBlkList.concatenate(upper);
        this.g.basicBlkList.concatenate(after);
        int n = this.order[head.id];
        BiLink p3 = top;
        while (true) {
            if (p3.atEnd()) {
                throw new CantHappenException("loop inversion");
            }
            BasicBlk blk = (BasicBlk)p3.elem();
            this.order[blk.id] = n++;
            if (blk == exit) break;
            p3 = p3.next();
        }
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new LoopInversion().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "LoopInversion";
        }

        public String subject() {
            return "Loop Inversion Optimization";
        }
    }
}

