/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.lir.LirVisitor;
import coins.backend.sym.SymAuto;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import java.util.Iterator;

public class IntroVirReg {
    public static final Trigger trig = new Trigger();
    private Symbol[] shadow;

    private boolean isRegisterType(int type) {
        return Type.tag(type) != 1;
    }

    public void doIt(Function f) {
        Symbol var;
        LirNode stmt;
        BiLink q;
        BasicBlk blk;
        this.shadow = new Symbol[f.localSymtab.idBound()];
        final boolean[] isAddrTaken = new boolean[f.localSymtab.idBound()];
        LirVisitor v = new LirVisitor(){
            LirNode lastOp = null;

            public void visit(LirFconst node) {
            }

            public void visit(LirIconst node) {
            }

            public void visit(LirLabelRef node) {
            }

            public void visit(LirSymRef node) {
                if (node.opCode == 5) {
                    SymAuto sym = (SymAuto)node.symbol;
                    if (this.lastOp.opCode != 47 || this.lastOp.type != sym.type || this.lastOp.opt.locate("&V") != null) {
                        isAddrTaken[sym.id] = true;
                    }
                }
            }

            public void visit(LirUnaOp node) {
                if (node.opCode == 8) {
                    return;
                }
                this.lastOp = node;
                node.kid(0).accept(this);
            }

            public void visit(LirBinOp node) {
                this.lastOp = node;
                node.kid(0).accept(this);
                this.lastOp = node;
                node.kid(1).accept(this);
            }

            public void visit(LirNaryOp node) {
                int n = node.nKids();
                for (int i = 0; i < n; ++i) {
                    this.lastOp = node;
                    node.kid(i).accept(this);
                }
            }
        };
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                stmt = (LirNode)q.elem();
                stmt.accept(v);
                q = q.next();
            }
            p = p.next();
        }
        Iterator it = f.localSymtab.iterator();
        while (it.hasNext()) {
            Symbol reg;
            var = (Symbol)it.next();
            if (var.storage != 1 || isAddrTaken[var.id] || !this.isRegisterType(var.type)) continue;
            String name = (var.name + "%").intern();
            this.shadow[var.id] = reg = f.addSymbol(name, 2, var.type, var.boundary, 0, null);
        }
        p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                stmt = (LirNode)q.elem();
                this.replaceAll(stmt, f);
                q = q.next();
            }
            p = p.next();
        }
        it = f.localSymtab.iterator();
        while (it.hasNext()) {
            var = (Symbol)it.next();
            if (var.id >= this.shadow.length || this.shadow[var.id] == null) continue;
            f.localSymtab.remove(var);
        }
        f.touch();
    }

    private LirNode replaceAll(LirNode node, Function f) {
        if (node.opCode == 8) {
            return node;
        }
        if (node.opCode == 47) {
            LirNode mem = node.kid(0);
            if (mem.opCode == 5) {
                Symbol var = ((LirSymRef)mem).symbol;
                Symbol reg = this.shadow[var.id];
                if (reg != null) {
                    return f.newLir.symRef(reg);
                }
            }
        }
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            LirNode oldsrc = node.kid(i);
            LirNode newsrc = this.replaceAll(oldsrc, f);
            if (newsrc == oldsrc) continue;
            node.setKid(i, newsrc);
        }
        return node;
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new IntroVirReg().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "IntroVirReg";
        }

        public String subject() {
            return "Virtual Register Replacement";
        }
    }
}

