/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.CantHappenException;
import coins.backend.Op;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirVisitor;
import coins.backend.sym.Symbol;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;

public class LirSymRef
extends LirNode {
    public final Symbol symbol;

    public LirSymRef(int id, int op, int t, Symbol sym, ImList opt) {
        super(id, op, t, opt);
        this.symbol = sym;
    }

    public LirNode makeCopy(LirFactory fac) {
        return this;
    }

    public LirNode replaceOptions(LirFactory fac, ImList newOpt) {
        return fac.symRef(this.opCode, this.type, this.symbol, newOpt);
    }

    public boolean isPhysicalRegister() {
        return this.opCode == 6 && this.symbol.name.charAt(0) == '%';
    }

    public Object toSexp() {
        return ImList.list(Op.toName(this.opCode), Type.toString(this.type), new QuotedString(this.symbol.name)).append(this.opt.makeCopy());
    }

    public String toString() {
        return "(" + Op.toName(this.opCode) + " " + Type.toString(this.type) + " " + this.symbol + "" + (this.opt.atEnd() ? "" : " " + this.opt.toStringWOParen()) + ")";
    }

    public boolean equals(Object x) {
        return x instanceof LirSymRef && super.equals(x) && this.symbol == ((LirSymRef)x).symbol;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public void accept(LirVisitor v) {
        v.visit(this);
    }

    public String toStringExp() {
        if (this.opCode == 4) {
            return this.symbol.name;
        }
        throw new CantHappenException("not an address expression: " + this);
    }
}

