/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.Op;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirVisitor;
import coins.backend.sym.Label;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;

public class LirLabelRef
extends LirNode {
    public final Label label;
    public final int variant;

    public LirLabelRef(int id, int op, int type, Label lab, ImList opt) {
        super(id, op, type, opt);
        this.label = lab;
        this.variant = 0;
    }

    public LirLabelRef(int id, int op, int type, Label lab, int variant, ImList opt) {
        super(id, op, type, opt);
        this.label = lab;
        this.variant = variant;
    }

    public LirNode makeCopy(LirFactory fac) {
        return this;
    }

    public LirNode replaceOptions(LirFactory fac, ImList newOpt) {
        return fac.labelRef(this.opCode, this.type, this.label, newOpt);
    }

    public Object toSexp() {
        ImList list = this.type == 0 ? ImList.list(Op.toName(this.opCode), new QuotedString(this.label.toString())) : ImList.list(Op.toName(this.opCode), Type.toString(this.type), new QuotedString(this.label.toString()));
        return list.append(this.opt.makeCopy());
    }

    public String toString() {
        return "(" + Op.toName(this.opCode) + (this.type == 0 ? "" : " " + Type.toString(this.type)) + " \"" + this.label + "\"" + (this.variant != 0 ? " $" + this.variant : "") + "" + (this.opt.atEnd() ? "" : " " + this.opt.toStringWOParen()) + ")";
    }

    public boolean equals(Object x) {
        return x instanceof LirLabelRef && super.equals(x) && this.label == ((LirLabelRef)x).label && this.variant == ((LirLabelRef)x).variant;
    }

    public int hashCode() {
        return this.label.hashCode() ^ this.variant << 16;
    }

    public void accept(LirVisitor v) {
        v.visit(this);
    }
}

