/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.Type;
import coins.backend.gen.CodeGenerator;
import coins.backend.gen.Rule;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.Misc;

public class CodeGenerator_sample
extends CodeGenerator {
    State[] stateVec;
    private RewrState[] rewrStates;
    private static final Rule[] rulev = new Rule[23];

    void initRewriteLabeling() {
        this.rewrStates = new RewrState[0];
    }

    private void setRewrStates(int index, RewrState v) {
        if (index >= this.rewrStates.length) {
            RewrState[] w = new RewrState[Misc.clp2(index + 1)];
            for (int i = 0; i < this.rewrStates.length; ++i) {
                w[i] = this.rewrStates[i];
            }
            this.rewrStates = w;
        }
        this.rewrStates[index] = v;
    }

    private RewrState getRewrStates(int index) {
        if (index < this.rewrStates.length) {
            return this.rewrStates[index];
        }
        return null;
    }

    LirNode rewriteTree(LirNode tree, String phase, BiList pre, BiList post) {
        RewrState s = this.getRewrStates(tree.id);
        if (s != null && !s.rewritten) {
            return tree;
        }
        while (true) {
            int n = this.nActualOperands(tree);
            RewrState[] kidst = new RewrState[n];
            for (int i = 0; i < n; ++i) {
                LirNode r = this.rewriteTree(tree.kid(i), phase, pre, post);
                if (r != tree.kid(i)) {
                    tree.setKid(i, r);
                }
                kidst[i] = this.getRewrStates(tree.kid((int)i).id);
            }
            s = new RewrState();
            this.setRewrStates(tree.id, s);
            if (this.disableRewrite.contains(tree.id)) {
                return tree;
            }
            LirNode newTree = s.labelAndRewrite(tree, kidst, phase, pre, post);
            if (newTree == null) {
                return tree;
            }
            tree = newTree;
        }
    }

    private static void rrinit0() {
        CodeGenerator_sample.rulev[9] = new Rule(9, true, false, 7, "9: regconst -> reg", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_sample.rulev[15] = new Rule(15, true, false, 9, "15: addr -> reg", null, null, null, 0L, false, false, new int[]{1}, new String[]{null, "*reg-I32*"});
        CodeGenerator_sample.rulev[2] = new Rule(2, true, false, 1, "2: reg -> xreg", null, null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I32*", null});
        CodeGenerator_sample.rulev[4] = new Rule(4, true, false, 2, "4: freg -> xfreg", null, null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-F64*", null});
        CodeGenerator_sample.rulev[10] = new Rule(10, true, false, 7, "10: regconst -> const", null, null, null, 0L, false, false, new int[]{5}, new String[]{null, null});
        CodeGenerator_sample.rulev[18] = new Rule(18, true, false, 1, "18: reg -> const", ImList.list(ImList.list("mov", "$1", "$0")), null, null, 0L, false, false, new int[]{5}, new String[]{"*reg-I32*", null});
        CodeGenerator_sample.rulev[16] = new Rule(16, true, false, 1, "16: reg -> mem", ImList.list(ImList.list("mov", "$1", "$0")), null, null, 0L, false, false, new int[]{8}, new String[]{"*reg-I32*", null});
        CodeGenerator_sample.rulev[17] = new Rule(17, true, false, 2, "17: freg -> memf", ImList.list(ImList.list("movf", "$1", "$0")), null, null, 0L, false, false, new int[]{10}, new String[]{"*reg-F64*", null});
        CodeGenerator_sample.rulev[5] = new Rule(5, false, false, 5, "5: const -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_sample.rulev[14] = new Rule(14, false, false, 9, "14: addr -> (STATIC I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_sample.rulev[1] = new Rule(1, false, false, 3, "1: xreg -> (REG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_sample.rulev[3] = new Rule(3, false, false, 4, "3: xfreg -> (REG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_sample.rulev[21] = new Rule(21, false, false, 11, "21: label -> (LABEL _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_sample.rulev[8] = new Rule(8, false, false, 1, "8: reg -> (ADD I32 reg regconst)", ImList.list(ImList.list("add", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{1, 7}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_sample.rulev[11] = new Rule(11, false, false, 2, "11: freg -> (ADD F64 freg freg)", ImList.list(ImList.list("addf", "$2", "$1", "$0")), null, null, 0L, false, false, new int[]{2, 2}, new String[]{"*reg-F64*", "*reg-F64*", "*reg-F64*"});
        CodeGenerator_sample.rulev[12] = new Rule(12, false, false, 8, "12: mem -> (MEM I32 addr)", null, ImList.list(ImList.list("mem", "$1")), null, 0L, false, false, new int[]{9}, new String[]{null, null});
        CodeGenerator_sample.rulev[13] = new Rule(13, false, false, 10, "13: memf -> (MEM F64 addr)", null, ImList.list(ImList.list("mem", "$1")), null, 0L, false, false, new int[]{9}, new String[]{null, null});
        CodeGenerator_sample.rulev[6] = new Rule(6, false, false, 6, "6: void -> (SET I32 xreg reg)", ImList.list(ImList.list("mov", "$2", "$1")), null, null, 0L, false, false, new int[]{3, 1}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_sample.rulev[19] = new Rule(19, false, false, 6, "19: void -> (SET I32 mem reg)", ImList.list(ImList.list("mov", "$2", "$1")), null, null, 0L, false, false, new int[]{8, 1}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_sample.rulev[7] = new Rule(7, false, false, 6, "7: void -> (SET F64 xfreg freg)", ImList.list(ImList.list("movf", "$2", "$1")), null, null, 0L, false, false, new int[]{4, 2}, new String[]{null, null, "*reg-F64*"});
        CodeGenerator_sample.rulev[20] = new Rule(20, false, false, 6, "20: void -> (SET F64 memf freg)", ImList.list(ImList.list("mov", "$2", "$1")), null, null, 0L, false, false, new int[]{10, 2}, new String[]{null, null, "*reg-F64*"});
        CodeGenerator_sample.rulev[22] = new Rule(22, false, false, 6, "22: void -> (JUMP _ label)", ImList.list(ImList.list("jump", "$1")), null, null, 0L, false, false, new int[]{11}, new String[]{null, null});
    }

    String defaultRegsetForType(int type) {
        switch (type) {
            case 514: {
                return "*reg-I32*";
            }
            case 1028: {
                return "*reg-F64*";
            }
        }
        return null;
    }

    void initLabeling(LirFactory lir) {
        this.stateVec = new State[lir.idBound()];
    }

    String showLabel(LirNode t) {
        return this.stateVec[t.id].toString();
    }

    void labelTree(LirNode t) {
        if (this.stateVec[t.id] == null) {
            State st;
            int n = this.nActualOperands(t);
            State[] kid = new State[n];
            for (int i = 0; i < n; ++i) {
                LirNode s = t.kid(i);
                this.labelTree(s);
                kid[i] = this.stateVec[s.id];
            }
            this.stateVec[t.id] = st = new State();
            st.label(t, kid);
        }
    }

    Rule getRule(LirNode t, int goal) {
        return rulev[this.stateVec[t.id].rule[goal]];
    }

    int getCost1(LirNode t, int goal) {
        return this.stateVec[t.id].cost1[goal];
    }

    int getCost2(LirNode t, int goal) {
        return this.stateVec[t.id].cost2[goal];
    }

    int startNT() {
        return 6;
    }

    Object expandBuildMacro(ImList form) {
        String name = (String)form.elem();
        return null;
    }

    Object quiltLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.quiltLirDefault(node);
    }

    String emitList(ImList form, boolean topLevel) {
        String name = (String)form.elem();
        if (name == "mem") {
            return this.jmac1(this.emitObject(form.elem(1)));
        }
        return this.emitListDefault(form, topLevel);
    }

    String emitLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.emitLirDefault(node);
    }

    String jmac1(String x) {
        return "[" + x + "]";
    }

    static {
        CodeGenerator_sample.rrinit0();
    }

    class State {
        static final int NNONTERM = 12;
        static final int NRULES = 23;
        static final int START_NT = 6;
        static final int NT__ = 0;
        static final int NT_reg = 1;
        static final int NT_freg = 2;
        static final int NT_xreg = 3;
        static final int NT_xfreg = 4;
        static final int NT_const = 5;
        static final int NT_void = 6;
        static final int NT_regconst = 7;
        static final int NT_mem = 8;
        static final int NT_addr = 9;
        static final int NT_memf = 10;
        static final int NT_label = 11;
        final int[] rule = new int[12];
        final int[] cost1 = new int[12];
        final int[] cost2 = new int[12];

        State() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "reg";
                }
                case 2: {
                    return "freg";
                }
                case 3: {
                    return "xreg";
                }
                case 4: {
                    return "xfreg";
                }
                case 5: {
                    return "const";
                }
                case 6: {
                    return "void";
                }
                case 7: {
                    return "regconst";
                }
                case 8: {
                    return "mem";
                }
                case 9: {
                    return "addr";
                }
                case 10: {
                    return "memf";
                }
                case 11: {
                    return "label";
                }
            }
            return null;
        }

        void record(int nt, int cost1, int cost2, int rule) {
            if (this.rule[nt] == 0 || (CodeGenerator_sample.this.optSpeed ? cost1 < this.cost1[nt] || cost1 == this.cost1[nt] && cost2 < this.cost2[nt] : cost2 < this.cost2[nt] || cost2 == this.cost2[nt] && cost1 < this.cost1[nt])) {
                this.rule[nt] = rule;
                this.cost1[nt] = cost1;
                this.cost2[nt] = cost2;
                switch (nt) {
                    case 1: {
                        this.record(7, 0 + cost1, 0 + cost2, 9);
                        this.record(9, 0 + cost1, 0 + cost2, 15);
                        break;
                    }
                    case 3: {
                        this.record(1, 0 + cost1, 0 + cost2, 2);
                        break;
                    }
                    case 4: {
                        this.record(2, 0 + cost1, 0 + cost2, 4);
                        break;
                    }
                    case 5: {
                        this.record(7, 0 + cost1, 0 + cost2, 10);
                        this.record(1, 1 + cost1, 1 + cost2, 18);
                        break;
                    }
                    case 8: {
                        this.record(1, 1 + cost1, 1 + cost2, 16);
                        break;
                    }
                    case 10: {
                        this.record(2, 1 + cost1, 1 + cost2, 17);
                    }
                }
            }
        }

        void label(LirNode t, State[] kids) {
            switch (t.opCode) {
                case 2: {
                    this.record(5, 0, 0, 5);
                    break;
                }
                case 4: {
                    if (t.type != 514) break;
                    this.record(9, 0, 0, 14);
                    break;
                }
                case 6: {
                    if (t.type == 514) {
                        this.record(3, 0, 0, 1);
                    }
                    if (t.type != 1028) break;
                    this.record(4, 0, 0, 3);
                    break;
                }
                case 8: {
                    this.record(11, 0, 0, 21);
                    break;
                }
                case 10: {
                    if (t.type == 514 && kids[0].rule[1] != 0 && kids[1].rule[7] != 0) {
                        this.record(1, 1 + kids[0].cost1[1] + kids[1].cost1[7], 1 + kids[0].cost2[1] + kids[1].cost2[7], 8);
                    }
                    if (t.type != 1028 || kids[0].rule[2] == 0 || kids[1].rule[2] == 0) break;
                    this.record(2, 1 + kids[0].cost1[2] + kids[1].cost1[2], 1 + kids[0].cost2[2] + kids[1].cost2[2], 11);
                    break;
                }
                case 47: {
                    if (t.type == 514 && kids[0].rule[9] != 0) {
                        this.record(8, 0 + kids[0].cost1[9], 0 + kids[0].cost2[9], 12);
                    }
                    if (t.type != 1028 || kids[0].rule[9] == 0) break;
                    this.record(10, 0 + kids[0].cost1[9], 0 + kids[0].cost2[9], 13);
                    break;
                }
                case 48: {
                    if (t.type == 514) {
                        if (kids[0].rule[3] != 0 && kids[1].rule[1] != 0) {
                            this.record(6, 1 + kids[0].cost1[3] + kids[1].cost1[1], 1 + kids[0].cost2[3] + kids[1].cost2[1], 6);
                        }
                        if (kids[0].rule[8] != 0 && kids[1].rule[1] != 0) {
                            this.record(6, 1 + kids[0].cost1[8] + kids[1].cost1[1], 1 + kids[0].cost2[8] + kids[1].cost2[1], 19);
                        }
                    }
                    if (t.type != 1028) break;
                    if (kids[0].rule[4] != 0 && kids[1].rule[2] != 0) {
                        this.record(6, 1 + kids[0].cost1[4] + kids[1].cost1[2], 1 + kids[0].cost2[4] + kids[1].cost2[2], 7);
                    }
                    if (kids[0].rule[10] == 0 || kids[1].rule[2] == 0) break;
                    this.record(6, 1 + kids[0].cost1[10] + kids[1].cost1[2], 1 + kids[0].cost2[10] + kids[1].cost2[2], 20);
                    break;
                }
                case 49: {
                    if (kids[0].rule[11] == 0) break;
                    this.record(6, 1 + kids[0].cost1[11], 1 + kids[0].cost2[11], 22);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 12; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i) + ":" + this.rule[i] + "[" + this.cost1[i] + "." + this.cost2[i] + "]");
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class RewrState {
        static final int NNONTERM = 4;
        static final int NRULES = 7;
        static final int START_NT = 1;
        static final int NT__ = 0;
        static final int NT__rewr = 1;
        static final int NT_const = 2;
        static final int NT__1 = 3;
        final int[] rule = new int[4];
        boolean rewritten;

        RewrState() {
        }

        String nontermName(int nt) {
            switch (nt) {
                case 0: {
                    return "_";
                }
                case 1: {
                    return "_rewr";
                }
                case 2: {
                    return "const";
                }
                case 3: {
                    return "_1";
                }
            }
            return null;
        }

        void record(int nt, int rule) {
            if (this.rule[nt] == 0) {
                this.rule[nt] = rule;
            }
        }

        LirNode labelAndRewrite(LirNode t, RewrState[] kids, String phase, BiList pre, BiList post) {
            switch (t.opCode) {
                case 2: {
                    this.record(2, 2);
                    break;
                }
                case 3: {
                    if (t.type != 1028 || phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_sample.this.lir.node(47, 1028, CodeGenerator_sample.this.lir.node(4, 514, CodeGenerator_sample.this.module.constToData(t)));
                }
                case 10: {
                    if (t.type != 514) break;
                    if (kids[1].rule[2] != 0) {
                        this.record(3, 3);
                    }
                    if (kids[0].rule[3] == 0 || kids[1].rule[2] == 0) break;
                    this.rewritten = true;
                    return CodeGenerator_sample.this.lir.node(10, 514, t.kid(0).kid(0), CodeGenerator_sample.this.lir.node(10, 514, t.kid(0).kid(1), t.kid(1)));
                }
                case 48: {
                    if (phase != "late" || Type.tag(t.type) != 1) break;
                    this.rewritten = true;
                    return CodeGenerator_sample.this.rewriteAggregateCopy(t, pre);
                }
                case 51: {
                    if (phase != "late") break;
                    this.rewritten = true;
                    return CodeGenerator_sample.this.rewriteJumpn(t, pre);
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("State(");
            boolean comma = false;
            for (int i = 0; i < 4; ++i) {
                if (this.rule[i] == 0) continue;
                if (comma) {
                    buf.append(",");
                }
                buf.append(this.nontermName(i));
                comma = true;
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

