/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.MachineParams;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.SyntaxError;
import coins.backend.TargetMachine;
import coins.backend.Transformer;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.gen.NoMatchException;
import coins.backend.gen.Rule;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirString;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.lir.LirVisitor;
import coins.backend.sym.Label;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.BitMapSet;
import coins.backend.util.ImList;
import coins.backend.util.NumberSet;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public abstract class CodeGenerator {
    static final int I128 = Type.type(2, 128L);
    static final int I64 = Type.type(2, 64L);
    static final int I32 = Type.type(2, 32L);
    static final int I16 = Type.type(2, 16L);
    static final int I8 = Type.type(2, 8L);
    static final int F128 = Type.type(4, 128L);
    static final int F64 = Type.type(4, 64L);
    static final int F32 = Type.type(4, 32L);
    Root root;
    Module module;
    PrintWriter debOut;
    MachineParams machineParams;
    int addrType;
    int typeParamWord = I32;
    String machineName;
    String convention;
    Map funcAttrTbl = new HashMap();
    boolean optSpeed = true;
    private int nextLabelNumber = 1;
    Function func;
    LirFactory lir;
    PrintWriter asmWriter = null;
    private String currentSegment = null;
    NumberSet disableRewrite;
    final LocalTransformer localEarlyRewritingTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            CodeGenerator.this.prerewrite(func, "early");
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "LocalEarlyRewriting";
        }

        public String subject() {
            return "Early-time Rewriting (local)";
        }
    };
    final LocalTransformer localLateRewritingTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            CodeGenerator.this.prerewrite(func, "late");
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "LocalLateRewriting";
        }

        public String subject() {
            return "Late-time Rewriting (local)";
        }
    };
    final LocalTransformer ProcessFramesTrig = new LocalTransformer(){

        public boolean doIt(Function f, ImList args) {
            CodeGenerator.this.func = f;
            CodeGenerator.this.lir = f.newLir;
            CodeGenerator.this.processFrames();
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ProcessFrames";
        }

        public String subject() {
            return "Set up frame offsets in symbol table";
        }
    };
    static final int INLINECOPYUNIT = 8;
    private int tmpCount = 1;
    private static final double FLT2_32 = 4.294967296E9;
    private static final double FLT2_64 = 1.8446744073709552E19;
    private static final double FLT2_31 = 2.147483648E9;
    private static final double FLT2_63 = 9.223372036854776E18;
    LexpToString lexpConv = new LexpToString();

    public void initialize(Root root, Module module, TargetMachine target, String machine, String convention) {
        if (this.root != null) {
            throw new CantHappenException("initialize again");
        }
        this.root = root;
        this.module = module;
        this.machineName = machine.intern();
        this.convention = convention.intern();
        this.machineParams = target.machineParams;
        this.addrType = this.machineParams.typeAddress();
        this.debOut = root.debOut;
        if (root.isOptionSet("optspace")) {
            this.optSpeed = false;
        }
        this.initializeMachineDep();
    }

    public void setAsmStream(OutputStream stream) {
        this.asmWriter = new PrintWriter(this.insertPostProcessor(stream));
    }

    OutputStream insertPostProcessor(OutputStream stream) {
        return stream;
    }

    void notifyEndToPostProcessor() {
    }

    void initializeMachineDep() {
    }

    private static void setRegsetOf(Symbol sym, String regset) {
        if (regset == null) {
            throw new CantHappenException("regset set to null");
        }
        sym.setOpt(ImList.list("&regset", regset));
    }

    private static String getRegsetOf(Symbol sym) {
        ImList p = sym.opt();
        while (!p.atEnd()) {
            if (p.elem() == "&regset") {
                return (String)p.elem2nd();
            }
            p = p.next();
        }
        return null;
    }

    private static void setRegsetOf(LirNode node, String regset) {
        CodeGenerator.setRegsetOf(((LirSymRef)node).symbol, regset);
    }

    private static void setDontspill(Symbol sym) {
        sym.setOpt(ImList.list("&dontspill"));
    }

    private static void setDontspill(LirNode node) {
        CodeGenerator.setDontspill(((LirSymRef)node).symbol);
    }

    private static String getRegsetOf(LirNode node) {
        return CodeGenerator.getRegsetOf(((LirSymRef)node).symbol);
    }

    FunctionAttr getFunctionAttr(Function func) {
        FunctionAttr attr = (FunctionAttr)this.funcAttrTbl.get(func);
        if (attr == null) {
            attr = this.newFunctionAttr(func);
            this.funcAttrTbl.put(func, attr);
        }
        return attr;
    }

    LirNode noRescan(LirNode node) {
        this.disableRewrite.add(node.id);
        return node;
    }

    public void prerewrite(Function f, String phase) {
        this.func = f;
        this.lir = f.newLir;
        this.disableRewrite = new BitMapSet();
        this.initRewriteLabeling();
        BiList pre = new BiList();
        BiList post = new BiList();
        BiList list = this.func.lirList();
        BiLink q = list.first();
        while (!q.atEnd()) {
            LirNode newIns;
            LirNode ins = (LirNode)q.elem();
            if (this.root.traceOK("TMD", 2)) {
                this.debOut.println("rewriting: " + ins);
            }
            if ((newIns = this.rewriteTree(ins, phase, pre, post)) != ins) {
                q.setElem(newIns);
            }
            if (!post.isEmpty()) {
                q.addAllAfter(post);
                post.clear();
            }
            if (!pre.isEmpty()) {
                BiLink prev = q.prev();
                q.addAllBefore(pre);
                pre.clear();
                q = prev;
            }
            q = q.next();
        }
    }

    abstract void initRewriteLabeling();

    abstract LirNode rewriteTree(LirNode var1, String var2, BiList var3, BiList var4);

    public Transformer[] earlyRewritingSequence() {
        return new Transformer[]{this.localEarlyRewritingTrig};
    }

    public Transformer[] lateRewritingSequence() {
        return new Transformer[]{this.localLateRewritingTrig, this.ProcessFramesTrig};
    }

    private BiList markNode(BiList list, int op, NumberSet done) {
        BiLink p = list.first();
        while (!p.atEnd()) {
            LirNode ins = (LirNode)p.elem();
            if (ins.opCode == op) {
                done.add(ins.id);
            }
            p = p.next();
        }
        return list;
    }

    int frameSize(Function f) {
        int loc = 0;
        BiLink p = f.localSymtab.symbols().first();
        while (!p.atEnd()) {
            int off;
            SymAuto var = (SymAuto)p.elem();
            if (var.storage == 1 && (off = var.offset()) != 0 && off < loc) {
                loc = off;
            }
            p = p.next();
        }
        return -loc;
    }

    private int processFrames() {
        int loc = -this.frameSize(this.func);
        BiLink p = this.func.localSymtab.symbols().first();
        while (!p.atEnd()) {
            SymAuto var = (SymAuto)p.elem();
            switch (var.storage) {
                case 1: {
                    int off = var.offset();
                    if (off != 0) break;
                    loc -= Type.bytes(var.type);
                    var.setOffset(loc &= -(var.boundary != 0 ? var.boundary : this.alignForType(var.type)));
                    break;
                }
                case 2: {
                    if (CodeGenerator.getRegsetOf(var) != null) break;
                    String regset = this.defaultRegsetForType(var.type);
                    if (regset != null) {
                        CodeGenerator.setRegsetOf(var, regset);
                        break;
                    }
                    this.func.localSymtab.addSymbol(var.name.replace('%', '#'), 1, var.type, var.boundary, 0, null);
                }
            }
            p = p.next();
        }
        p = this.func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                this.rewriteFramesInTree((LirNode)q.elem());
                q = q.next();
            }
            p = p.next();
        }
        return loc & -this.alignForType(F64);
    }

    private LirNode rewriteFramesInTree(LirNode tree) {
        if (tree.opCode == 6 && !tree.isPhysicalRegister() && CodeGenerator.getRegsetOf(tree) == null) {
            tree = this.dropRegToFrame(tree);
        }
        int n = tree.nKids();
        for (int i = 0; i < n; ++i) {
            LirNode orig = tree.kid(i);
            LirNode repl = this.rewriteFramesInTree(orig);
            if (repl == orig) continue;
            tree.setKid(i, repl);
        }
        if (tree.opCode == 5) {
            return this.rewriteFrame(tree);
        }
        return this.lir.foldConstant(tree);
    }

    LirNode dropRegToFrame(LirNode node) {
        Symbol frame = this.mapRegToFrame(((LirSymRef)node).symbol);
        if (frame == null) {
            throw new CantHappenException("No FRAME for REG: " + ((LirSymRef)node).symbol);
        }
        return this.lir.node(47, node.type, this.lir.symRef(frame));
    }

    Symbol mapRegToFrame(Symbol reg) {
        return this.func.localSymtab.get(reg.name.replace('%', '#'));
    }

    SymAuto reserveFrame(String name, int type) {
        SymAuto sym = (SymAuto)this.func.localSymtab.get(name);
        if (sym == null) {
            sym = (SymAuto)this.func.addSymbol(name, 1, type, this.alignForType(type), 0, null);
            int loc = -this.frameSize(this.func) - Type.bytes(type) & -this.alignForType(type);
            sym.setOffset(loc);
        }
        return sym;
    }

    private int getAlignment(LirNode memExp) {
        ImList p = memExp.opt;
        while (!p.atEnd()) {
            if (p.elem() == "&align") {
                return Integer.parseInt((String)p.elem2nd());
            }
            p = p.next();
        }
        return 1;
    }

    LirNode rewriteAggregateCopy(LirNode node, BiList pre) {
        int elemType;
        if (node.kid((int)0).opCode != 47 || node.kid((int)1).opCode != 47 || node.kid((int)1).type != node.type) {
            throw new CantHappenException("Malformed aggregate copy");
        }
        if (node.kid((int)0).type != node.type) {
            this.debOut.println("Warning: copying objects whose sizes are different");
        }
        int align = this.getAlignment(node.kid(0));
        int align2 = this.getAlignment(node.kid(1));
        if (align2 < align) {
            align = align2;
        }
        switch (align) {
            case 1: {
                elemType = Type.type(2, 8L);
                break;
            }
            case 2: {
                elemType = Type.type(2, 16L);
                break;
            }
            default: {
                elemType = Type.type(2, 32L);
                align = 4;
            }
        }
        int bytes = Type.bytes(node.type);
        if (bytes != 0) {
            LirNode dst = node.kid(0).kid(0);
            LirNode src = node.kid(1).kid(0);
            LirNode srcPtr = this.func.newTemp(this.addrType);
            LirNode dstPtr = this.func.newTemp(this.addrType);
            pre.add(this.lir.node(48, this.addrType, srcPtr, src));
            pre.add(this.lir.node(48, this.addrType, dstPtr, dst));
            if (bytes / align <= 8) {
                for (int j = 0; j < bytes; j += align) {
                    pre.add(this.lir.node(48, elemType, this.lir.node(47, elemType, j == 0 ? dstPtr : this.lir.node(10, this.addrType, dstPtr, this.lir.iconst(this.addrType, j))), this.lir.node(47, elemType, j == 0 ? srcPtr : this.lir.node(10, this.addrType, srcPtr, this.lir.iconst(this.addrType, j)))));
                }
            } else {
                Label loopTop = this.func.newLabel();
                Label loopExit = this.func.newLabel();
                LirNode counter = this.func.newTemp(this.addrType);
                pre.add(this.lir.node(48, this.addrType, counter, this.lir.iconst(this.addrType, bytes)));
                pre.add(this.lir.node(52, this.addrType, this.lir.labelRef(loopTop)));
                pre.add(this.lir.node(48, elemType, this.lir.node(47, elemType, dstPtr), this.lir.node(47, elemType, srcPtr)));
                pre.add(this.lir.node(48, this.addrType, srcPtr, this.lir.node(10, this.addrType, srcPtr, this.lir.iconst(this.addrType, align))));
                pre.add(this.lir.node(48, this.addrType, dstPtr, this.lir.node(10, this.addrType, dstPtr, this.lir.iconst(this.addrType, align))));
                pre.add(this.lir.node(48, this.addrType, counter, this.lir.node(11, this.addrType, counter, this.lir.iconst(this.addrType, align))));
                pre.add(this.lir.node(50, 0, this.lir.node(36, this.addrType, counter, this.lir.iconst(this.addrType, 0L)), this.lir.labelRef(loopTop), this.lir.labelRef(loopExit)));
                pre.add(this.lir.node(52, this.addrType, this.lir.labelRef(loopExit)));
            }
        }
        node = (LirNode)pre.last().elem();
        pre.last().unlink();
        return node;
    }

    int paramToBeSaved() {
        FunctionAttr at = this.getFunctionAttr(this.func);
        int wordsize = Type.bytes(this.typeParamWord);
        int regLimit = this.clcvnRegLimit();
        LirNode node = null;
        BiLink p = this.func.firstInstrList().first();
        while (!p.atEnd()) {
            node = (LirNode)p.elem();
            if (node.opCode == 54) break;
            p = p.next();
        }
        int n = node.nKids();
        int paramLoc = 0;
        int paramLoc0 = 0;
        if (this.func.origEpilogue.nKids() > 1 && Type.tag(this.func.origEpilogue.kid((int)1).type) == 1 && this.clcvnStructReturnAsFirst()) {
            paramLoc0 = paramLoc = wordsize;
        }
        for (int i = 1; i < n; ++i) {
            LirNode x = node.kid(i);
            int b = Type.bytes(x.type) + wordsize - 1 & -wordsize;
            paramLoc0 = paramLoc;
            if ((paramLoc += b) <= regLimit) continue;
            return paramLoc0;
        }
        return regLimit;
    }

    int paramOffset(LirNode arg) {
        int regLimit = this.clcvnRegLimit();
        int wordsize = Type.bytes(this.typeParamWord);
        LirNode node = null;
        BiLink p = this.func.firstInstrList().first();
        while (!p.atEnd()) {
            node = (LirNode)p.elem();
            if (node.opCode == 54) break;
            p = p.next();
        }
        int paramLoc = 0;
        if (this.func.origEpilogue.nKids() > 1 && Type.tag(this.func.origEpilogue.kid((int)1).type) == 1 && this.clcvnStructReturnAsFirst()) {
            paramLoc = wordsize;
        }
        int n = node.nKids();
        for (int i = 1; i < n; ++i) {
            LirNode x = node.kid(i);
            if (this.equalArg(arg, x)) {
                return paramLoc;
            }
            paramLoc += Type.bytes(x.type) + wordsize - 1 & -wordsize;
        }
        return 0;
    }

    boolean equalArg(LirNode x, LirNode y) {
        if (x.opCode == 47) {
            x = x.kid(0);
        }
        if (y.opCode == 47) {
            y = y.kid(0);
        }
        return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
    }

    LirNode rewritePrologue(LirNode node, BiList post) {
        int regLimit = this.clcvnRegLimit();
        int wordsize = Type.bytes(this.typeParamWord);
        BiList sync = new BiList();
        FunctionAttr at = this.getFunctionAttr(this.func);
        BiList alist = new BiList();
        int paramLoc = 0;
        int n = at.stackParamOffset = at.isVarArg ? 0 : this.paramToBeSaved();
        if (this.func.origEpilogue.nKids() > 1 && Type.tag(this.func.origEpilogue.kid((int)1).type) == 1 && this.clcvnStructReturnAsFirst()) {
            at.retPtr = this.func.newTemp(this.addrType);
            LirNode src = this.clcvnParamWord(at.retPtr.type, paramLoc, false);
            if (src.isRegisterOperand()) {
                alist.add(src);
            }
            post.add(this.lir.node(48, at.retPtr.type, at.retPtr, src));
            paramLoc += wordsize;
        }
        for (int loc = at.stackParamOffset; loc < regLimit; loc += wordsize) {
            sync.add(this.lir.node(48, this.typeParamWord, this.clcvnParamMem(this.typeParamWord, loc, false), this.clcvnParamReg(this.typeParamWord, loc, false)));
        }
        int n2 = node.nKids();
        block5: for (int i = 1; i < n2; ++i) {
            LirNode arg = node.kid(i);
            switch (Type.tag(arg.type)) {
                case 2: {
                    int m;
                    if (Type.bytes(arg.type) > wordsize) {
                        m = (Type.bytes(arg.type) + wordsize - 1) / wordsize;
                        for (int j = 0; j < m; ++j) {
                            LirNode src = this.clcvnParamWord(this.typeParamWord, paramLoc, false);
                            if (src.isRegisterOperand()) {
                                alist.add(src);
                            }
                            post.add(this.clcvnSetPartialWord(arg, j, src));
                            paramLoc += wordsize;
                        }
                        continue block5;
                    }
                    LirNode src = this.clcvnParamWord(arg.type, paramLoc, false);
                    if (src.isRegisterOperand()) {
                        alist.add(src);
                    }
                    post.add(this.lir.node(48, arg.type, arg, src));
                    paramLoc += wordsize;
                    continue block5;
                }
                case 1: 
                case 4: {
                    int m = (Type.bytes(arg.type) + wordsize - 1) / wordsize;
                    if (arg.opCode == 47) {
                        if (paramLoc < at.stackParamOffset) {
                            int loc = 0;
                            for (int j = 0; j < m; ++j) {
                                LirNode src = this.clcvnParamReg(this.typeParamWord, paramLoc + loc, false);
                                alist.add(src);
                                post.add(this.lir.node(48, this.typeParamWord, this.lir.node(47, this.typeParamWord, this.lir.node(10, this.addrType, arg.kid(0), this.lir.iconst(this.addrType, loc))), src));
                                loc += wordsize;
                            }
                        } else {
                            if (arg.kid((int)0).opCode != 5) {
                                throw new CantHappenException("Malformed aggregate parameter");
                            }
                            SymAuto var = (SymAuto)((LirSymRef)arg.kid((int)0)).symbol;
                            var.setOffset(this.clcvnParamOffset(paramLoc));
                        }
                    } else if (paramLoc < at.stackParamOffset) {
                        SymAuto sym = this.reserveFrame(".TMP_" + this.tmpCount++, arg.type);
                        int loc = 0;
                        for (int j = 0; j < m; ++j) {
                            LirNode src = this.clcvnParamReg(this.typeParamWord, paramLoc + loc, false);
                            alist.add(src);
                            post.add(this.lir.node(48, this.typeParamWord, this.lir.node(47, this.typeParamWord, this.lir.node(10, this.addrType, this.lir.symRef(sym), this.lir.iconst(this.addrType, loc))), src));
                            loc += wordsize;
                        }
                        post.add(this.lir.node(48, arg.type, arg, this.lir.node(47, arg.type, this.lir.symRef(sym))));
                    } else {
                        post.add(this.lir.node(48, arg.type, arg, this.clcvnParamMem(arg.type, paramLoc, false)));
                    }
                    paramLoc += m * wordsize;
                }
            }
        }
        post.addAllFirst(sync);
        LirNode[] regArgs = new LirNode[alist.length()];
        BiLink p = alist.first();
        for (int i = 0; i < regArgs.length; ++i) {
            regArgs[i] = (LirNode)p.elem();
            p = p.next();
        }
        return this.lir.node(54, 0, regArgs);
    }

    LirNode rewriteEpilogue(LirNode node, BiList pre) {
        if (node.nKids() < 2) {
            return node;
        }
        LirNode ret = node.kid(1);
        LirNode reg = this.clcvnReturnValue(ret.type);
        FunctionAttr at = this.getFunctionAttr(this.func);
        if (Type.tag(ret.type) == 1) {
            if (this.clcvnStructReturnAsFirst()) {
                if (at.retPtr == null) {
                    throw new CantHappenException("missing pointer to value returned");
                }
                pre.add(this.lir.node(48, ret.type, this.lir.node(47, ret.type, at.retPtr), ret));
            } else {
                pre.add(this.lir.node(48, ret.type, this.lir.node(47, ret.type, this.clcvnStructReturnPtr(false)), ret));
            }
            return node;
        }
        pre.add(this.lir.node(48, ret.type, reg, ret));
        return this.lir.node(55, 0, node.kid(0), reg);
    }

    boolean isComplex(LirNode node) {
        switch (node.opCode) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    LirNode phyReg(String name) {
        return this.lir.symRef(this.module.globalSymtab.get(name));
    }

    LirNode rewriteCall(LirNode node, BiList pre, BiList post) {
        BiList qlist;
        BiList list = new BiList();
        LirNode callee = node.kid(0);
        LirNode ret = null;
        if (node.kid(2).nKids() > 0) {
            ret = node.kid(2).kid(0);
        }
        int n = node.kid(1).nKids();
        LirNode[] args = new LirNode[n];
        for (int i = 0; i < n; ++i) {
            args[i] = node.kid(1).kid(i);
        }
        if (this.isComplex(callee)) {
            LirNode copy = this.func.newTemp(callee.type);
            list.add(this.lir.node(48, callee.type, copy, callee));
            node.setKid(0, copy);
        }
        if (ret != null && Type.tag(ret.type) == 1) {
            if (ret.opCode != 47) {
                throw new CantHappenException();
            }
            if (this.clcvnStructReturnAsFirst()) {
                LirNode[] newArgs = new LirNode[1 + args.length];
                newArgs[0] = ret.kid(0);
                for (int i = 0; i < args.length; ++i) {
                    newArgs[i + 1] = args[i];
                }
                args = newArgs;
            } else {
                list.add(this.lir.node(48, ret.kid((int)0).type, this.clcvnStructReturnPtr(true), ret.kid(0)));
            }
        }
        int wordsize = Type.bytes(this.typeParamWord);
        int regLimit = this.clcvnRegLimit();
        int paramLoc = 0;
        BiList plist = new BiList();
        BiLink ip = plist;
        BiList iq = qlist = new BiList();
        BiList alist = new BiList();
        block8: for (int i = 0; i < args.length; ++i) {
            LirNode arg = args[i];
            ip = plist.first();
            iq = qlist;
            switch (Type.tag(arg.type)) {
                case 2: {
                    if (this.isComplex(arg)) {
                        LirNode tmp = this.func.newTemp(arg.type);
                        ip.addBefore(this.lir.node(48, arg.type, tmp, arg));
                        arg = tmp;
                    }
                    if (Type.bytes(arg.type) > wordsize) {
                        int m = (Type.bytes(arg.type) + wordsize - 1) / wordsize;
                        for (int j = 0; j < m; ++j) {
                            LirNode dst = this.clcvnParamWord(this.typeParamWord, paramLoc, true);
                            BiLink p = ip;
                            if (dst.isRegisterOperand()) {
                                alist.add(dst);
                                p = iq;
                            }
                            p.addBefore(this.lir.node(48, dst.type, dst, this.clcvnPartialWord(arg, j)));
                            paramLoc += wordsize;
                        }
                        continue block8;
                    }
                    LirNode dst = this.clcvnParamWord(arg.type, paramLoc, true);
                    BiLink p = ip;
                    if (dst.isRegisterOperand()) {
                        alist.add(dst);
                        p = iq;
                    }
                    p.addBefore(this.lir.node(48, dst.type, dst, arg));
                    paramLoc += wordsize;
                    continue block8;
                }
                case 1: 
                case 4: {
                    if (arg.opCode == 47) {
                        int ptr;
                        LirNode lval = arg.kid(0);
                        if (this.isComplex(lval)) {
                            LirNode tmp = this.func.newTemp(this.addrType);
                            ip.addBefore(this.lir.node(48, this.addrType, tmp, lval));
                            lval = tmp;
                        }
                        int size = Type.bytes(arg.type);
                        for (ptr = 0; ptr < size && paramLoc < regLimit; ptr += wordsize, paramLoc += wordsize) {
                            LirNode tmp = this.func.newTemp(this.typeParamWord);
                            LirNode dst = this.clcvnParamReg(this.typeParamWord, paramLoc, true);
                            alist.add(dst);
                            ip.addBefore(this.lir.node(48, tmp.type, tmp, this.lir.node(47, tmp.type, this.lir.node(10, this.addrType, lval, this.lir.iconst(this.addrType, ptr)))));
                            iq.addBefore(this.lir.node(48, dst.type, dst, tmp));
                        }
                        if (ptr >= size) continue block8;
                        int agtype = Type.type(1, (size - ptr) * 8);
                        ip.addBefore(this.lir.node(48, agtype, this.clcvnParamMem(agtype, paramLoc, true), this.lir.node(47, agtype, this.lir.node(10, this.addrType, lval, this.lir.iconst(this.addrType, ptr)))));
                        paramLoc += size - ptr + wordsize - 1 & -wordsize;
                        continue block8;
                    }
                    if (Type.tag(arg.type) == 4) {
                        if (paramLoc >= regLimit) {
                            ip.addBefore(this.lir.node(48, arg.type, this.clcvnParamMem(arg.type, paramLoc, true), arg));
                        } else {
                            if (this.isComplex(arg)) {
                                LirNode tmp = this.func.newTemp(arg.type);
                                ip.addBefore(this.lir.node(48, arg.type, tmp, arg));
                                arg = tmp;
                            }
                            this.clcvnPassFloatRegMem(paramLoc, arg, ip, iq, alist);
                        }
                        paramLoc += Type.bytes(arg.type) + wordsize - 1 & -wordsize;
                        continue block8;
                    }
                    throw new CantHappenException();
                }
                default: {
                    throw new CantHappenException();
                }
            }
        }
        pre.concatenate(list);
        pre.concatenate(plist);
        pre.concatenate(qlist);
        FunctionAttr at = this.getFunctionAttr(this.func);
        if (paramLoc > at.requiredStack) {
            at.requiredStack = paramLoc;
        }
        LirNode retReg = null;
        if (ret != null && Type.tag(ret.type) != 1) {
            retReg = this.clcvnReturnValue(ret.type);
        }
        LirNode[] regArgs = new LirNode[alist.length()];
        BiLink p = alist.first();
        for (int i = 0; i < regArgs.length; ++i) {
            regArgs[i] = (LirNode)p.elem();
            p = p.next();
        }
        try {
            LirNode retNode = this.lir.node(61, 0, new LirNode[0]);
            if (retReg != null) {
                retNode = this.lir.node(61, 0, retReg);
            }
            node = this.lir.node(56, 0, this.noRescan(this.lir.node(53, 0, node.kid(0), this.lir.node(61, 0, regArgs), retNode)), this.lir.decodeLir(new ImList("CLOBBER", this.clcvnClobbers()), this.func, this.module));
        }
        catch (SyntaxError e) {
            throw new CantHappenException();
        }
        if (retReg != null) {
            LirNode tmp = this.func.newTemp(ret.type);
            post.add(this.lir.node(48, ret.type, tmp, retReg));
            post.add(this.lir.node(48, ret.type, ret, tmp));
        }
        return node;
    }

    int clcvnRegLimit() {
        return 0;
    }

    LirNode clcvnParamWord(int type, int location, boolean caller) {
        return this.clcvnParamMem(type, location, caller);
    }

    LirNode clcvnParamReg(int type, int location, boolean caller) {
        return null;
    }

    LirNode clcvnParamMem(int type, int location, boolean caller) {
        return null;
    }

    void clcvnPassFloatRegMem(int location, LirNode arg, BiLink memp, BiLink regp, BiList alist) {
        memp.addBefore(this.lir.node(48, arg.type, this.clcvnParamMem(arg.type, location, true), arg));
        for (int ptr = location; ptr < this.clcvnRegLimit(); ptr += Type.bytes(this.typeParamWord)) {
            LirNode dst = this.clcvnParamWord(this.typeParamWord, ptr, true);
            alist.add(dst);
            regp.addBefore(this.lir.node(48, dst.type, dst, this.clcvnParamMem(dst.type, ptr, true)));
        }
    }

    int clcvnParamOffset(int location) {
        return 0;
    }

    LirNode clcvnReturnValue(int type) {
        return null;
    }

    LirNode clcvnSetPartialWord(LirNode lhs, int part, LirNode rhs) {
        return null;
    }

    LirNode clcvnPartialWord(LirNode exp, int part) {
        return null;
    }

    ImList clcvnClobbers() {
        return ImList.Empty;
    }

    boolean clcvnStructReturnAsFirst() {
        return true;
    }

    LirNode clcvnStructReturnPtr(boolean caller) {
        return null;
    }

    LirNode rewriteJumpn(LirNode node, BiList pre) {
        LirNode exp = node.kid(0);
        LirNode caselist = node.kid(1);
        LirNode defaultlabel = node.kid(2);
        LirNode reg = exp;
        if (exp.opCode != 6) {
            reg = this.func.newTemp(exp.type);
            pre.add(this.lir.node(48, reg.type, reg, exp));
        }
        int n = caselist.nKids();
        for (int i = 0; i < n; ++i) {
            LirNode v = caselist.kid(i).kid(0);
            LirNode tlabel = caselist.kid(i).kid(1);
            LirNode flabel = this.lir.labelRef(this.func.newLabel());
            pre.add(this.lir.node(50, 0, this.lir.node(35, this.machineParams.typeBool(), reg, v), tlabel, flabel));
            pre.add(this.lir.node(52, 0, flabel));
        }
        return this.lir.node(49, 0, defaultlabel);
    }

    LirNode rewriteAsm(LirNode node, BiList pre, BiList post) {
        String type;
        int i;
        LirNode inList = node.kid(1);
        LirNode outList = node.kid(2);
        LirNode inoutList = node.kid(3);
        ImList argtype = null;
        ImList clobber = null;
        ImList p = node.opt.scanOpt();
        while (!p.atEnd()) {
            if (p.elem() == "&argtype") {
                argtype = (ImList)p.elem2nd();
            } else if (p.elem() == "&clobber") {
                clobber = (ImList)p.elem2nd();
            } else {
                throw new CantHappenException("asm: unknown option: " + p);
            }
            p = p.next().scanOpt();
        }
        if (argtype == null && clobber == null) {
            return node;
        }
        p = argtype;
        for (i = 0; i < inList.nKids(); ++i) {
            if (p.atEnd()) {
                throw new CantHappenException("asm: argtype deficit");
            }
            type = (String)p.elem();
            if (type.charAt(0) == '%') {
                inList.setKid(i, this.loadReg(inList.kid(i), type, pre));
            }
            p = p.next();
        }
        for (i = 0; i < outList.nKids(); ++i) {
            if (p.atEnd()) {
                throw new CantHappenException("asm: argtype deficit");
            }
            type = (String)p.elem();
            if (type.charAt(0) == 'w') {
                type = type.substring(1);
            }
            if (type.charAt(0) == '%') {
                outList.setKid(i, this.restoreReg(outList.kid(i), type, post));
            }
            p = p.next();
        }
        for (i = 0; i < inoutList.nKids(); ++i) {
            if (p.atEnd()) {
                throw new CantHappenException("asm: argtype deficit");
            }
            type = (String)p.elem();
            if (type.charAt(0) == 'm') {
                type = type.substring(1);
            }
            if (type.charAt(0) == '%') {
                inoutList.setKid(i, this.loadRestoreReg(inoutList.kid(i), type, pre, post));
            }
            p = p.next();
        }
        if (!p.atEnd()) {
            throw new CantHappenException("asm: argtype surplus");
        }
        return this.lir.operator(56, 0, this.lir.node(67, 0, new LirNode[]{node.kid(0), inList, outList, inoutList}), this.lir.node(58, 0, this.parseClobber(clobber)), ImList.list("&use-after-def", "&clobber-after-def"));
    }

    private LirNode[] parseClobber(ImList clobbers) {
        if (clobbers == null) {
            return new LirNode[0];
        }
        LirNode[] vec = new LirNode[clobbers.length()];
        int i = 0;
        ImList p = clobbers;
        while (!p.atEnd()) {
            Symbol reg = this.func.getSymbol((String)p.elem());
            vec[i++] = reg != null ? this.lir.symRef(reg) : this.lir.node(62, 0);
            p = p.next();
        }
        return vec;
    }

    private LirNode asPhysicalRegister(String name) {
        Symbol sym = this.func.getSymbol(name);
        if (sym == null) {
            return null;
        }
        return this.lir.symRef(sym);
    }

    private LirNode loadReg(LirNode src, String regset, BiList pre) {
        LirNode reg = this.asPhysicalRegister(regset);
        if (reg != null) {
            pre.add(this.lir.node(48, reg.type, reg, src));
        } else {
            reg = this.func.newTemp(src.type);
            pre.add(this.lir.node(48, reg.type, reg, src));
            CodeGenerator.setRegsetOf(reg, ("*reg-" + regset.substring(1) + "*").intern());
            CodeGenerator.setDontspill(reg);
        }
        return reg;
    }

    private LirNode restoreReg(LirNode dst, String regset, BiList post) {
        LirNode reg = this.asPhysicalRegister(regset);
        if (reg != null) {
            post.add(this.lir.node(48, dst.type, dst, reg));
        } else {
            reg = this.func.newTemp(dst.type);
            post.add(this.lir.node(48, dst.type, dst, reg));
            CodeGenerator.setRegsetOf(reg, ("*reg-" + regset.substring(1) + "*").intern());
            CodeGenerator.setDontspill(reg);
        }
        return reg;
    }

    private LirNode loadRestoreReg(LirNode src, String regset, BiList pre, BiList post) {
        LirNode reg = this.asPhysicalRegister(regset);
        if (reg != null) {
            pre.add(this.lir.node(48, reg.type, reg, src));
            post.add(this.lir.node(48, src.type, src, reg));
        } else {
            reg = this.func.newTemp(src.type);
            pre.add(this.lir.node(48, reg.type, reg, src));
            post.add(this.lir.node(48, src.type, src, reg));
            CodeGenerator.setRegsetOf(reg, ("*reg-" + regset.substring(1) + "*").intern());
            CodeGenerator.setDontspill(reg);
        }
        return reg;
    }

    int nActualOperands(LirNode node) {
        int n = node.nKids();
        if (node.opCode == 56) {
            for (int i = 0; i < n; ++i) {
                switch (node.kid((int)i).opCode) {
                    case 57: 
                    case 58: {
                        return i;
                    }
                }
            }
        }
        return n;
    }

    public void instructionSelection(Function f) {
        this.func = f;
        this.lir = f.newLir;
        if (this.root.traceOK("TMD", 1)) {
            this.debOut.println();
            this.debOut.println("Instruction Selection:");
        }
        this.processFrames();
        this.initLabeling(this.lir);
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList newInstr = new BiList();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                switch (ins.opCode) {
                    case 54: 
                    case 55: 
                    case 65: 
                    case 66: {
                        newInstr.add(ins);
                        break;
                    }
                    case 56: {
                        if (ins.kid((int)0).opCode == 67) {
                            newInstr.add(ins);
                            break;
                        }
                    }
                    default: {
                        if (this.root.traceOK("TMD", 1)) {
                            this.debOut.println();
                            this.debOut.println("Matching: " + ins);
                        }
                        try {
                            LirNode origIns = ins;
                            if (ins.opCode == 56 && this.nActualOperands(ins) <= 1) {
                                ins = ins.kid(0);
                            }
                            this.labelTree(ins);
                            if (this.root.traceOK("TMD", 2)) {
                                this.printLabel(ins, "");
                            }
                            Match tree = this.reduce(ins, this.startNT()).skipNonOpRules();
                            tree = tree.removeSet(true);
                            tree.decompLir(newInstr);
                            if (origIns == ins) break;
                            LirNode lastop = (LirNode)newInstr.last().elem();
                            if (lastop.opCode == 56) break;
                            LirNode node = this.lir.makeShallowCopy(origIns);
                            node.setKid(0, lastop);
                            newInstr.last().setElem(node);
                            break;
                        }
                        catch (NoMatchException e) {
                            this.debOut.println();
                            this.debOut.println("No Match for " + ins);
                            this.debOut.println("State:");
                            this.printLabel(ins, "");
                            e.printStackTrace();
                            throw new Error("compilation aborted.");
                        }
                    }
                }
                q = q.next();
            }
            blk.setInstrList(newInstr);
            p = p.next();
        }
        this.func.touch();
        this.func = null;
    }

    public void genHeader(Module mod) {
        this.emitIdent(this.asmWriter, "Coins Compiler version: coins-1.4.2.2 + BackEnd-0.8.1");
        this.emitComment(this.asmWriter, "JavaCG for target:" + this.machineName + " convention:" + this.convention);
        this.emitBeginningOfModule(mod, this.asmWriter);
    }

    public LocalTransformer convToAsm() {
        return new LocalTransformer(){

            public boolean doIt(Function func, ImList args) {
                CodeGenerator.this.convToAsm(func);
                return true;
            }

            public boolean doIt(Data data, ImList args) {
                CodeGenerator.this.convToAsm(data);
                return true;
            }

            public String name() {
                return "ConvToAsm";
            }

            public String subject() {
                return "Converting to Assembly Language";
            }
        };
    }

    private void convToAsm(Function f) {
        this.func = f;
        this.lir = f.newLir;
        BiList list = this.buildCode(f);
        if (this.root.traceOK("TMD", 1)) {
            this.debOut.println();
            this.debOut.println("After buildCode (S-expression assembly code generaion):");
            this.debOut.println("Function \"" + f.symbol.name + "\":");
            BiLink p = list.first();
            while (!p.atEnd()) {
                this.debOut.println("  " + p.elem());
                p = p.next();
            }
            this.debOut.println("End Function");
            this.debOut.println();
        }
        this.peepHoleOpt(list);
        this.asmWriter.println();
        if (this.root.sourceDebugInfo) {
            this.asmWriter.println(this.emitTop(ImList.list("line", "" + this.func.sourceLineNo)));
        }
        this.emitSegment(this.asmWriter, f.symbol.segment);
        this.emitAlign(this.asmWriter, f.symbol.boundary);
        this.emitLinkage(this.asmWriter, f.symbol);
        this.emitCodeLabel(this.asmWriter, this.makeAsmSymbol(f.symbol.name));
        this.emitCode(list, this.asmWriter);
        this.asmWriter.println();
        this.func = null;
    }

    public void emitNamedConst(String name, LirNode value) {
        this.emitSegment(this.asmWriter, this.segmentForConst());
        this.emitAlign(this.asmWriter, this.alignForType(value.type));
        this.emitDataLabel(this.asmWriter, name);
        this.emitData(this.asmWriter, value.type, value);
    }

    BiList buildCode(Function f) {
        FlowGraph flowGraph = f.flowGraph();
        if (this.root.traceOK("TMD", 1)) {
            this.debOut.println();
            this.debOut.println("Final Code Emission:");
        }
        this.initLabeling(this.lir);
        BiList asmList = new BiList();
        boolean firstblk = true;
        BiLink p = flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (!firstblk) {
                asmList.add(ImList.list("deflabel", blk.label()));
            }
            firstblk = false;
            BiLink delayOpLink = null;
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                switch (ins.opCode) {
                    case 54: {
                        asmList.add(ImList.list("prologue", this.func));
                        break;
                    }
                    case 55: {
                        String rettype = "normal";
                        if (f.origEpilogue.nKids() >= 2 && Type.tag(f.origEpilogue.kid((int)1).type) == 1) {
                            rettype = "aggregate";
                        }
                        asmList.add(ImList.list("epilogue", this.func, rettype));
                        break;
                    }
                    case 66: {
                        break;
                    }
                    case 65: {
                        asmList.add(ImList.list("line", ins.kid(0)));
                        break;
                    }
                    case 56: {
                        if (ins.kid((int)0).opCode == 67) {
                            asmList.add(this.buildAsm(ins.kid(0)));
                            break;
                        }
                    }
                    default: {
                        if (this.root.traceOK("TMD", 1)) {
                            this.debOut.println();
                            this.debOut.println("Matching: " + ins);
                        }
                        try {
                            ImList codeList;
                            boolean delayOp;
                            boolean bl = delayOp = ins.opt.locate("&delay") != null;
                            if (ins.opCode == 56 && this.nActualOperands(ins) <= 1) {
                                ins = ins.kid(0);
                            }
                            this.labelTree(ins);
                            Match tree = this.reduce(ins, this.startNT()).skipNonOpRules();
                            tree = tree.removeSet(false);
                            if (this.root.traceOK("TMD", 1)) {
                                tree.printIt(this.debOut);
                            }
                            ImList s = codeList = tree.quiltCode();
                            while (!s.atEnd()) {
                                if (this.root.traceOK("TMD", 3)) {
                                    this.debOut.println(s.elem().toString());
                                }
                                if (s.elem() instanceof ImList && ((ImList)s.elem()).elem() == "delayslot" && delayOpLink != null) {
                                    Object op = delayOpLink.elem();
                                    delayOpLink.unlink();
                                    asmList.add(op);
                                    delayOpLink = null;
                                } else {
                                    asmList.add(s.elem());
                                }
                                s = s.next();
                            }
                            if (!delayOp) break;
                            delayOpLink = asmList.last();
                            break;
                        }
                        catch (NoMatchException e) {
                            this.debOut.println();
                            this.debOut.println("No Match for " + ins);
                            this.debOut.println("State:");
                            this.printLabel(ins, "");
                            throw new Error("compilation aborted.");
                        }
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
        return asmList;
    }

    private ImList buildAsm(LirNode ins) {
        return ImList.list("genasm", ((LirString)ins.kid((int)0)).string, this.listify(ins.kid(1)).append(this.listify(ins.kid(2)).append(this.listify(ins.kid(3)))));
    }

    private ImList listify(LirNode ins) {
        ImList list = ImList.Empty;
        int n = ins.nKids();
        while (--n >= 0) {
            list = new ImList(this.quiltAsmOperand(ins.kid(n)), list);
        }
        return list;
    }

    private Object quiltAsmOperand(LirNode node) {
        switch (node.opCode) {
            case 10: {
                if (node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 2) {
                    return new Long(((LirIconst)node.kid(1)).signedValue());
                }
            }
            case 11: {
                if (node.kid((int)0).opCode != 6 || node.kid((int)1).opCode != 2) break;
                return new Long(-((LirIconst)node.kid(1)).signedValue());
            }
        }
        return this.quiltLir(node);
    }

    public void prepareCodeInfo(Function f) {
        this.func = f;
        this.lir = f.newLir;
        this.initLabeling(this.lir);
    }

    public ImList codeInfo(LirNode ins) {
        try {
            if (ins.opCode == 56 && this.nActualOperands(ins) <= 1) {
                ins = ins.kid(0);
            }
            this.labelTree(ins);
            Match tree = this.reduce(ins, this.startNT()).skipNonOpRules();
            tree = tree.removeSet(false);
            ImList codeList = tree.quiltCode();
            return ImList.list(new Boolean(tree.rule.hasDelaySlot), new Integer(tree.cost1), new Integer(codeList.length()));
        }
        catch (NoMatchException e) {
            this.debOut.println();
            this.debOut.println("No Match for " + ins);
            this.debOut.println("State:");
            this.printLabel(ins, "");
            throw new Error("compilation aborted.");
        }
    }

    Object quiltLirDefault(LirNode node) {
        switch (node.opCode) {
            case 7: {
                node = node.kid(0);
            }
            case 6: {
                return ((LirSymRef)node).symbol.name;
            }
            case 4: {
                return this.makeAsmSymbol(((LirSymRef)node).symbol.name);
            }
            case 2: {
                return new Long(((LirIconst)node).signedValue());
            }
            case 3: {
                return new Double(((LirFconst)node).value);
            }
            case 8: {
                return ((LirLabelRef)node).label.name();
            }
        }
        return node.toString();
    }

    void peepHoleOpt(BiList list) {
    }

    void emitCode(BiList asmList, PrintWriter file) {
        BiLink p = asmList.first();
        while (!p.atEnd()) {
            String line = this.emitObjectX(p.elem(), true);
            if (line.indexOf(10) < 0) {
                file.println(line);
            } else {
                int len = line.length();
                int i = 0;
                while (i < len) {
                    int j = line.indexOf(10, i);
                    if (j < 0) {
                        j = len;
                    }
                    file.println(line.substring(i, j));
                    i = j + 1;
                }
            }
            p = p.next();
        }
    }

    String emitTop(Object x) {
        return this.emitObjectX(x, true);
    }

    String emitObject(Object x) {
        return this.emitObjectX(x, false);
    }

    String emitObjectX(Object x, boolean top) {
        if (x instanceof ImList) {
            return this.emitList((ImList)x, top);
        }
        if (x instanceof LirNode) {
            return this.emitLir((LirNode)x);
        }
        return x.toString();
    }

    String emitListDefault(ImList form, boolean topLevel) {
        if (form.atEnd()) {
            return "";
        }
        if (form.elem() == "deflabel") {
            if (form.elem2nd() instanceof LirLabelRef) {
                return this.makeLabelDef(((LirLabelRef)form.elem2nd()).label.name());
            }
            return this.makeLabelDef(form.elem2nd().toString());
        }
        StringBuffer res = new StringBuffer();
        if (topLevel) {
            res.append("\t");
        }
        res.append((String)form.elem());
        boolean first = true;
        form = form.next();
        while (!form.atEnd()) {
            if (first) {
                res.append(topLevel ? "\t" : "(");
            } else {
                res.append(",");
            }
            res.append(this.emitObject(form.elem()));
            first = false;
            form = form.next();
        }
        if (!topLevel && !first) {
            res.append(")");
        }
        return res.toString();
    }

    String emitLirDefault(LirNode node) {
        switch (node.opCode) {
            case 7: {
                node = node.kid(0);
            }
            case 6: {
                return ((LirSymRef)node).symbol.name;
            }
            case 4: {
                return this.makeAsmSymbol(((LirSymRef)node).symbol.name);
            }
            case 2: {
                return Long.toString(((LirIconst)node).signedValue());
            }
            case 3: {
                return Double.toString(((LirFconst)node).value);
            }
            case 8: {
                return ((LirLabelRef)node).label.name();
            }
        }
        return node.toString();
    }

    private void convToAsm(Data data) {
        if (data.components[0].opCode == 63) {
            this.emitCommon(this.asmWriter, data.symbol, (int)((LirIconst)data.components[0].kid((int)0)).value);
        } else {
            this.emitSegment(this.asmWriter, data.symbol.segment);
            this.emitAlign(this.asmWriter, data.symbol.boundary);
            this.emitLinkage(this.asmWriter, data.symbol);
            this.emitDataLabel(this.asmWriter, this.makeAsmSymbol(data.symbol.name));
            block5: for (int i = 0; i < data.components.length; ++i) {
                LirNode node = data.components[i];
                switch (node.opCode) {
                    case 64: {
                        this.emitZeros(this.asmWriter, (int)((LirIconst)node.kid((int)0)).value);
                        continue block5;
                    }
                    case 61: {
                        int n = node.nKids();
                        for (int j = 0; j < n; ++j) {
                            this.emitData(this.asmWriter, node.type, node.kid(j));
                        }
                        continue block5;
                    }
                    case 63: {
                        throw new CantHappenException("SPACE in middle");
                    }
                    default: {
                        throw new CantHappenException();
                    }
                }
            }
        }
    }

    public void genTrailer(Module mod) {
        this.emitEndOfModule(mod, this.asmWriter);
    }

    public void close() {
        this.asmWriter.close();
        this.notifyEndToPostProcessor();
    }

    void emitSegment(PrintWriter file, String segment) {
        if (this.currentSegment == null || !this.currentSegment.equals(segment)) {
            if (this.currentSegment != null) {
                this.emitEndOfSegment(file, this.currentSegment);
            }
            this.emitBeginningOfSegment(file, segment);
            this.currentSegment = segment;
        }
    }

    void printLabel(LirNode t, String indent) {
        this.debOut.println(indent + t + " : " + this.showLabel(t));
        int n = t.nKids();
        for (int i = 0; i < n; ++i) {
            this.printLabel(t.kid(i), indent + "  ");
        }
    }

    Match reduce(LirNode t, int goal) throws NoMatchException {
        Rule rule = this.getRule(t, goal);
        int cost1 = this.getCost1(t, goal);
        int cost2 = this.getCost2(t, goal);
        if (rule == null) {
            throw new NoMatchException();
        }
        Match[] mkid = null;
        int n = rule.subgoals.length;
        mkid = new Match[n];
        if (rule.isChain) {
            mkid[0] = this.reduce(t, rule.subgoals[0]);
        } else {
            for (int i = 0; i < n; ++i) {
                mkid[i] = this.reduce(t.kid(i), rule.subgoals[i]);
            }
        }
        return new Match(t, mkid, rule, cost1, cost2);
    }

    boolean isSimple(LirNode node) {
        if (node.opCode == 6) {
            return true;
        }
        if (node.opCode == 47) {
            switch (node.kid((int)0).opCode) {
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    LirNode rewriteCONVUF(LirNode node, BiList pre) {
        LirNode src = node.kid(0);
        if (!this.isSimple(src)) {
            src = this.func.newTemp(src.type);
            pre.add(this.lir.node(48, src.type, src, node.kid(0)));
        }
        LirNode dst = this.func.newTemp(node.type);
        pre.add(this.lir.node(48, dst.type, dst, this.lir.node(25, dst.type, src)));
        Label tlabel = this.func.newLabel();
        Label flabel = this.func.newLabel();
        pre.add(this.lir.node(50, 0, this.lir.node(40, I32, src, this.lir.iconst(src.type, 0L)), this.lir.labelRef(tlabel), this.lir.labelRef(flabel)));
        pre.add(this.lir.node(52, 0, this.lir.labelRef(flabel)));
        pre.add(this.lir.node(48, dst.type, dst, this.lir.node(10, dst.type, dst, this.lir.fconst(dst.type, Type.bits(src.type) > 32 ? 1.8446744073709552E19 : 4.294967296E9))));
        pre.add(this.lir.node(52, 0, this.lir.labelRef(tlabel)));
        return dst;
    }

    LirNode rewriteCONVFU(LirNode node, BiList pre) {
        LirNode src = node.kid(0);
        if (src.opCode != 6) {
            src = this.func.newTemp(src.type);
            pre.add(this.lir.node(48, src.type, src, node.kid(0)));
        }
        Label tlabel = this.func.newLabel();
        Label flabel = this.func.newLabel();
        Label elabel = this.func.newLabel();
        LirNode dst = this.func.newTemp(node.type);
        double boundary = Type.bits(dst.type) > 32 ? 9.223372036854776E18 : 2.147483648E9;
        long bias = Type.bits(dst.type) > 32 ? Long.MIN_VALUE : Integer.MIN_VALUE;
        pre.add(this.lir.node(50, 0, this.lir.node(40, I32, src, this.lir.fconst(src.type, boundary)), this.lir.labelRef(tlabel), this.lir.labelRef(flabel)));
        pre.add(this.lir.node(52, 0, this.lir.labelRef(tlabel)));
        pre.add(this.lir.node(48, dst.type, dst, this.lir.node(10, dst.type, this.lir.node(23, dst.type, this.lir.node(11, src.type, src, this.lir.fconst(src.type, boundary))), this.lir.iconst(dst.type, bias))));
        pre.add(this.lir.node(49, 0, this.lir.labelRef(elabel)));
        pre.add(this.lir.node(52, 0, this.lir.labelRef(flabel)));
        pre.add(this.lir.node(48, dst.type, dst, this.lir.node(23, dst.type, src)));
        pre.add(this.lir.node(52, 0, this.lir.labelRef(elabel)));
        return dst;
    }

    abstract void initLabeling(LirFactory var1);

    abstract String showLabel(LirNode var1);

    abstract void labelTree(LirNode var1);

    abstract Rule getRule(LirNode var1, int var2);

    abstract int getCost1(LirNode var1, int var2);

    abstract int getCost2(LirNode var1, int var2);

    abstract int startNT();

    abstract String defaultRegsetForType(int var1);

    abstract String emitList(ImList var1, boolean var2);

    abstract String emitLir(LirNode var1);

    abstract Object expandBuildMacro(ImList var1);

    abstract Object quiltLir(LirNode var1);

    LirNode rewriteFrame(LirNode node) {
        Symbol fp = this.func.module.globalSymtab.get("%fp");
        int off = ((SymAuto)((LirSymRef)node).symbol).offset();
        return this.lir.node(10, node.type, this.lir.symRef(fp), this.lir.iconst(I32, off));
    }

    void emitIdent(PrintWriter out, String ident) {
        out.println(" .ident \"" + ident + "\"");
    }

    void emitComment(PrintWriter out, String comment) {
        out.println("/* " + comment + " */");
    }

    void emitBeginningOfModule(Module mod, PrintWriter out) {
    }

    void emitEndOfModule(Module mod, PrintWriter out) {
    }

    void emitBeginningOfSegment(PrintWriter out, String segment) {
        out.println("\t.section \"" + segment + "\"");
    }

    void emitEndOfSegment(PrintWriter out, String segment) {
    }

    void emitLinkage(PrintWriter out, SymStatic symbol) {
        if (symbol.linkage == "XDEF") {
            out.println("\t.global\t" + this.makeAsmSymbol(symbol.name));
        }
    }

    void emitDataLabel(PrintWriter out, String label) {
        out.println(this.makeLabelDef(label));
    }

    void emitCodeLabel(PrintWriter out, String label) {
        out.println(this.makeLabelDef(label));
    }

    void emitAlign(PrintWriter out, int align) {
        out.println("\t.align\t" + align);
    }

    void emitCommon(PrintWriter out, SymStatic symbol, int bytes) {
        if (symbol.linkage == "LDEF") {
            out.println("\t.lcomm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes);
        } else {
            out.println("\t.comm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes + "," + symbol.boundary);
        }
    }

    void emitZeros(PrintWriter out, int bytes) {
        if (bytes > 0) {
            out.println("\t.skip\t" + bytes);
        }
    }

    String emitAsmCode(String format, ImList args) {
        StringBuffer buf = new StringBuffer();
        int n = format.length();
        int i = 0;
        while (i < n) {
            char c;
            if ((c = format.charAt(i++)) == '%' && i < n) {
                if ((c = format.charAt(i++)) == '%') {
                    buf.append(c);
                    continue;
                }
                if (Character.isDigit(c)) {
                    buf.append(args.elem(c - 49).toString());
                    continue;
                }
                buf.append('%');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    void emitData(PrintWriter out, int type, LirNode node) {
        if (type == I64) {
            long v = ((LirIconst)node).signedValue();
            out.println("\t.long\t" + (v >> 32 & 0xFFFFFFFFL) + "," + (v & 0xFFFFFFFFL));
        } else if (type == I32) {
            out.println("\t.long\t" + this.lexpConv.convert(node));
        } else if (type == I16) {
            out.println("\t.short\t" + ((LirIconst)node).signedValue());
        } else if (type == I8) {
            out.println("\t.byte\t" + ((LirIconst)node).signedValue());
        } else if (type == F64) {
            double value = ((LirFconst)node).value;
            long bits = Double.doubleToLongBits(value);
            out.println("\t.long\t0x" + Long.toString(bits >> 32 & 0xFFFFFFFFL, 16) + ",0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else if (type == F32) {
            double value = ((LirFconst)node).value;
            long bits = Float.floatToIntBits((float)value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else {
            throw new CantHappenException("unknown type: " + type);
        }
    }

    FunctionAttr newFunctionAttr(Function f) {
        FunctionAttr at = new FunctionAttr(f);
        at.requiredStack = this.clcvnRegLimit();
        return at;
    }

    public int alignForType(int type) {
        return 4;
    }

    String segmentForConst() {
        return ".text";
    }

    String makeAsmSymbol(String symbol) {
        return symbol;
    }

    String makeLabelDef(String label) {
        return label + ":";
    }

    public MachineParams getMachineParams() {
        return this.machineParams;
    }

    class LexpToString
    implements LirVisitor {
        private StringBuffer buf;

        LexpToString() {
        }

        String convert(LirNode node) {
            this.buf = new StringBuffer();
            node.accept(this);
            return this.buf.toString();
        }

        public void visit(LirIconst node) {
            this.buf.append(node.signedValue());
        }

        public void visit(LirSymRef node) {
            this.buf.append(CodeGenerator.this.makeAsmSymbol(node.symbol.name));
        }

        public void visit(LirLabelRef node) {
            this.buf.append(node.label.name());
        }

        public void visit(LirBinOp node) {
            switch (node.opCode) {
                case 10: {
                    node.kid(0).accept(this);
                    this.buf.append('+');
                    node.kid(1).accept(this);
                    break;
                }
                case 11: {
                    node.kid(0).accept(this);
                    this.buf.append('-');
                    node.kid(1).accept(this);
                    break;
                }
                default: {
                    throw new CantHappenException("not an address expression: " + node);
                }
            }
        }

        public void visit(LirNaryOp node) {
            throw new CantHappenException("not an address expression: " + node);
        }

        public void visit(LirUnaOp node) {
            throw new CantHappenException("not an address expression: " + node);
        }

        public void visit(LirFconst node) {
            throw new CantHappenException("not an address expression: " + node);
        }
    }

    class Match {
        LirNode orig;
        Rule rule;
        int cost1;
        int cost2;
        LirNode dest;
        LirNode[] src;
        Match[] kid;
        Match[] rLeaf;
        int[] rLeafIndex;
        Match[] tLeaf;
        int[] tLeafIndex;
        Match[] subtrees;
        int suNumber;
        int[] order;
        Map genLabelTbl;

        private Match ruleLeaf(int n) {
            return this.rLeaf[n].kid[this.rLeafIndex[n]];
        }

        private Match treeLeaf(int n) {
            return this.tLeaf[n].kid[this.tLeafIndex[n]];
        }

        Match(LirNode orig, Match[] kid, Rule rule, int cost1, int cost2) {
            this.orig = orig;
            this.kid = kid;
            this.rule = rule;
            this.cost1 = cost1;
            this.cost2 = cost2;
            this.src = new LirNode[kid.length];
            if (!this.isDerived()) {
                int n = this.numRuleLeaf(0);
                this.rLeaf = new Match[n];
                this.rLeafIndex = new int[n];
                this.fillRuleLeaf(this, 0);
            }
        }

        private int numRuleLeaf(int n) {
            for (int i = 0; i < this.kid.length; ++i) {
                if (this.kid[i].isDerived()) {
                    n = this.kid[i].numRuleLeaf(n);
                    continue;
                }
                ++n;
            }
            return n;
        }

        private int fillRuleLeaf(Match base, int n) {
            for (int i = 0; i < this.kid.length; ++i) {
                if (this.kid[i].isDerived()) {
                    n = this.kid[i].fillRuleLeaf(base, n);
                    continue;
                }
                base.rLeaf[n] = this;
                base.rLeafIndex[n++] = i;
            }
            return n;
        }

        private void setTreeLeaf() {
            int n = this.numTreeLeaf(0);
            this.tLeaf = new Match[n];
            this.tLeafIndex = new int[n];
            this.fillTreeLeaf(this, 0);
            for (int i = 0; i < n; ++i) {
                this.treeLeaf(i).setTreeLeaf();
            }
        }

        private int numTreeLeaf(int n) {
            for (int i = 0; i < this.kid.length; ++i) {
                if (!this.kid[i].isCore()) {
                    n = this.kid[i].numTreeLeaf(n);
                    continue;
                }
                ++n;
            }
            return n;
        }

        private int fillTreeLeaf(Match base, int n) {
            for (int i = 0; i < this.kid.length; ++i) {
                if (!this.kid[i].isCore()) {
                    n = this.kid[i].fillTreeLeaf(base, n);
                    continue;
                }
                base.tLeaf[n] = this;
                base.tLeafIndex[n++] = i;
            }
            return n;
        }

        private void printIt(PrintWriter out, String indent) {
            if (this.rule != null) {
                out.println(indent + (this.isCore() ? "*" : "") + this.rule.toString() + (this.dest != null ? " [dest=" + this.dest + "]" : "") + " SU=" + this.suNumber);
                for (int i = 0; i < this.kid.length; ++i) {
                    this.kid[i].printIt(out, "  " + indent);
                }
            } else {
                out.println(indent + "(no rule)");
            }
        }

        void printIt(PrintWriter out) {
            this.printIt(out, "");
        }

        boolean hasCode() {
            return this.rule.code != null;
        }

        boolean isCore() {
            return this.hasCode() || this.dest != null;
        }

        boolean isDerived() {
            return this.rule.isDerived;
        }

        boolean isCheaperThan(Match x) {
            if (CodeGenerator.this.optSpeed) {
                return this.cost1 < x.cost1 || this.cost1 == x.cost1 && this.cost2 < x.cost2;
            }
            return this.cost2 < x.cost2 || this.cost2 == x.cost2 && this.cost1 < x.cost1;
        }

        private boolean satisfies(LirNode reg, String regset) {
            if (reg.isPhysicalRegister()) {
                return true;
            }
            if (reg.opCode == 7) {
                return false;
            }
            return CodeGenerator.getRegsetOf(reg) == regset;
        }

        private int availRegs(String s) {
            if (s == null) {
                throw new CantHappenException("null pointer");
            }
            return CodeGenerator.this.machineParams.nAvail(CodeGenerator.this.machineParams.getRegSet(s));
        }

        private boolean acceptableAsDestination(LirNode reg) {
            if (this.dest != null) {
                return this.dest == reg;
            }
            String regset = null;
            if (this.rule.regsets != null) {
                regset = this.rule.regsets[0];
            }
            if (regset == null) {
                return false;
            }
            if (this.rule.eqregs != 0L) {
                long w = this.rule.eqregs >> 1;
                for (int i = 0; i < this.rLeaf.length; ++i) {
                    if ((w & 1L) != 0L) {
                        LirNode srcReg = this.ruleLeaf((int)i).orig;
                        if (CodeGenerator.this.root.traceOK("TMD", 1)) {
                            CodeGenerator.this.root.debOut.println("eqreg check: " + reg + " vs " + srcReg + " = " + (srcReg == reg));
                        }
                        if (srcReg != reg) {
                            return false;
                        }
                    }
                    w >>= 1;
                }
            }
            return this.satisfies(reg, regset);
        }

        Match removeSet(boolean pass1) {
            if (this.orig.opCode == 48 && this.orig.kid(0).isRegisterOperand() && this.kid[1].hasCode()) {
                LirNode reg = this.orig.kid(0);
                if (!pass1 || this.kid[1].acceptableAsDestination(reg)) {
                    this.kid[1].dest = reg;
                    return this.kid[1];
                }
            }
            return this;
        }

        private LirNode addClobber(LirNode node) {
            if (this.rule.clobber == null) {
                return node;
            }
            try {
                return CodeGenerator.this.lir.node(56, 0, node, CodeGenerator.this.lir.decodeLir(new ImList("CLOBBER", this.rule.clobber), CodeGenerator.this.func, CodeGenerator.this.func.module));
            }
            catch (SyntaxError e) {
                throw new CantHappenException("clobber syntax: " + e);
            }
        }

        void allocTemp(LirNode required, String regset) {
            int i;
            if (this.isDerived()) {
                throw new CantHappenException();
            }
            if (this.dest == null && this.rule.regsets[0] != null) {
                if (this.hasCode()) {
                    if (required != null && regset == this.rule.regsets[0]) {
                        this.dest = required;
                    } else {
                        this.dest = CodeGenerator.this.func.newTemp(CodeGenerator.this.machineParams.getRegSetType(this.rule.regsets[0]));
                        CodeGenerator.setRegsetOf(this.dest, this.rule.regsets[0]);
                    }
                } else if (this.orig.isRegisterOperand()) {
                    this.dest = this.orig;
                }
            }
            for (i = 0; i < this.rLeaf.length; ++i) {
                if ((this.rule.eqregs >>> i + 1 & 1L) != 1L) continue;
                this.rLeaf[i].src[this.rLeafIndex[i]] = this.dest;
            }
            for (i = 0; i < this.rLeaf.length; ++i) {
                LirNode reg;
                this.ruleLeaf(i).allocTemp(this.rLeaf[i].src[this.rLeafIndex[i]], this.rule.regsets[i + 1]);
                if (this.rule.regsets[i + 1] == null || this.rLeaf[i].src[this.rLeafIndex[i]] != null || (reg = this.ruleLeaf((int)i).dest) == null) continue;
                if (!this.satisfies(reg, this.rule.regsets[i + 1])) {
                    reg = CodeGenerator.this.func.newTemp(reg.type);
                    CodeGenerator.setRegsetOf(reg, this.rule.regsets[i + 1]);
                }
                this.rLeaf[i].src[this.rLeafIndex[i]] = reg;
            }
        }

        void scheduleBySuNumber() {
            int i;
            for (i = 0; i < this.tLeaf.length; ++i) {
                this.treeLeaf(i).scheduleBySuNumber();
            }
            if (this.order == null) {
                this.order = new int[this.tLeaf.length];
            }
            for (i = 0; i < this.tLeaf.length; ++i) {
                this.order[i] = i;
            }
            for (i = 0; i < this.order.length; ++i) {
                for (int j = i + 1; j < this.order.length; ++j) {
                    Match it = this.treeLeaf(this.order[i]);
                    Match jt = this.treeLeaf(this.order[j]);
                    if (it.suNumber >= jt.suNumber && (it.suNumber != jt.suNumber || !it.isCheaperThan(jt))) continue;
                    int w = this.order[i];
                    this.order[i] = this.order[j];
                    this.order[j] = w;
                }
            }
            this.suNumber = 0;
            for (i = 0; i < this.order.length; ++i) {
                int su = this.treeLeaf((int)this.order[i]).suNumber;
                if (su > this.suNumber) {
                    this.suNumber = su;
                    continue;
                }
                if (su != this.suNumber || su <= 0) continue;
                ++this.suNumber;
            }
            if (this.hasCode() && this.rule.regsets[0] != null && this.suNumber == 0) {
                this.suNumber = 1;
            }
        }

        private LirNode makeupTree1() {
            if (this.rule.isChain) {
                if (this.kid[0].isCore()) {
                    return this.src[0];
                }
                return this.kid[0].makeupTree1();
            }
            LirNode node = CodeGenerator.this.lir.makeShallowCopy(this.orig);
            for (int i = 0; i < this.kid.length; ++i) {
                if (this.kid[i].isCore()) {
                    node.setKid(i, this.src[i]);
                    continue;
                }
                node.setKid(i, this.kid[i].makeupTree1());
            }
            return node;
        }

        private LirNode makeupTree() {
            LirNode node = this.kid.length == 0 ? this.orig : this.makeupTree1();
            if (this.dest != null) {
                node = CodeGenerator.this.lir.node(48, this.dest.type, this.dest, node);
            }
            node = this.addClobber(node);
            if (this.rule.useAfterDef) {
                node = node.replaceOptions(CodeGenerator.this.lir, new ImList("&use-after-def", node.opt));
            }
            return node;
        }

        void generateDecomposed(BiList list) {
            BiList after = new BiList();
            for (int i = 0; i < this.tLeaf.length; ++i) {
                int y;
                int x;
                int j = this.order[i];
                this.treeLeaf(j).generateDecomposed(list);
                LirNode s = this.tLeaf[j].src[this.tLeafIndex[j]];
                LirNode d = this.treeLeaf((int)j).dest;
                if (s == d) continue;
                LirNode copy = CodeGenerator.this.lir.node(48, s.type, s, d);
                if (s.isPhysicalRegister()) {
                    x = 1;
                } else {
                    String sRegset = CodeGenerator.getRegsetOf(s);
                    if (sRegset == null) {
                        throw new Error("Variable " + s + " has no regset.");
                    }
                    x = this.availRegs(sRegset);
                }
                if (d.isPhysicalRegister()) {
                    y = 1;
                } else {
                    String dRegset = CodeGenerator.getRegsetOf(d);
                    if (dRegset == null) {
                        throw new Error("Variable " + d + " has no regset.");
                    }
                    y = this.availRegs(dRegset);
                }
                if (x > y) {
                    list.add(copy);
                } else {
                    after.add(copy);
                }
                if (!CodeGenerator.this.root.traceOK("TMD", 1)) continue;
                CodeGenerator.this.debOut.println("  inserted: " + copy);
            }
            list.concatenate(after);
            if (this.hasCode()) {
                list.add(this.makeupTree());
            }
        }

        void decompLir(BiList list) {
            this.allocTemp(null, null);
            this.setTreeLeaf();
            this.scheduleBySuNumber();
            if (CodeGenerator.this.root.traceOK("TMD", 1)) {
                this.printIt(CodeGenerator.this.debOut);
            }
            this.generateDecomposed(list);
        }

        Match skipNonOpRules() {
            if (this.hasCode() || this.kid.length > 1) {
                return this;
            }
            return this.kid[0].skipNonOpRules();
        }

        ImList quiltCode() {
            return this.quiltList(this.rule.code);
        }

        private ImList quiltList(ImList list) {
            if (list == null) {
                return ImList.Empty;
            }
            if (list.atEnd()) {
                return list;
            }
            Object obj = this.quiltObj(list.elem());
            if (obj instanceof ImList) {
                return ((ImList)obj).append(this.quiltList(list.next()));
            }
            return new ImList(obj, this.quiltList(list.next()));
        }

        private Object quiltObj(Object elem) {
            if (elem instanceof ImList) {
                Object result;
                ImList form = this.quiltList((ImList)elem);
                if (!form.atEnd() && form.elem() instanceof String && (result = CodeGenerator.this.expandBuildMacro(form)) != null) {
                    return result;
                }
                return new ImList(form);
            }
            if (elem instanceof String) {
                String word = (String)elem;
                if (word.charAt(0) == '$') {
                    if (word.charAt(1) == '$') {
                        return this.orig;
                    }
                    if (word.charAt(1) == 'L') {
                        return this.genLabel(word.substring(2));
                    }
                    int n = Integer.parseInt(word.substring(1));
                    if (n == 0) {
                        return this.quiltValue();
                    }
                    return this.ruleLeaf(n - 1).quiltValue();
                }
                return word;
            }
            if (elem instanceof LirNode) {
                return CodeGenerator.this.quiltLir((LirNode)elem);
            }
            return elem;
        }

        private Object quiltValue() {
            if (this.rule.value != null) {
                return this.quiltList(this.rule.value);
            }
            if (this.dest != null) {
                return CodeGenerator.this.quiltLir(this.dest);
            }
            if (this.kid.length > 0) {
                return this.kid[0].quiltValue();
            }
            return CodeGenerator.this.quiltLir(this.orig);
        }

        private String genLabel(String labelid) {
            Label label;
            if (this.genLabelTbl == null) {
                this.genLabelTbl = new HashMap();
            }
            if ((label = (Label)this.genLabelTbl.get(labelid)) == null) {
                label = CodeGenerator.this.module.newLabel();
                this.genLabelTbl.put(labelid, label);
            }
            return label.name();
        }
    }

    static class FunctionAttr {
        Function func;
        int requiredStack;
        boolean isVarArg;
        LirNode retPtr;
        int stackParamOffset;

        FunctionAttr(Function func) {
            this.func = func;
        }
    }
}

