/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class AggregateByReference {
    public static final Trigger trig = new Trigger();

    public void doIt(Function func) {
        LirFactory lir = func.newLir;
        LirNode[] map = new LirNode[func.localSymtab.idBound()];
        BiLink p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode stmt = (LirNode)q.elem();
                if (stmt.opCode == 54) {
                    int n = stmt.nKids();
                    for (int i = 1; i < n; ++i) {
                        LirNode reg;
                        if (stmt.kid((int)i).opCode != 47 || Type.tag(stmt.kid((int)i).type) != 1) continue;
                        if (stmt.kid((int)i).kid((int)0).opCode != 5) {
                            throw new CantHappenException("expecting FRAME: " + stmt);
                        }
                        Symbol var = ((LirSymRef)stmt.kid((int)i).kid((int)0)).symbol;
                        String name = (var.name + "%").intern();
                        map[var.id] = reg = lir.symRef(func.addSymbol(name, 2, func.module.targetMachine.typeAddress, 0, 0, null));
                        stmt.setKid(i, reg);
                        func.localSymtab.remove(var);
                    }
                }
                this.rewriteAggRef(stmt, map);
                q = q.next();
            }
            p = p.next();
        }
        int tmpn = 1;
        BiLink p2 = func.flowGraph().basicBlkList.first();
        while (!p2.atEnd()) {
            BasicBlk blk = (BasicBlk)p2.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode stmt = (LirNode)q.elem();
                if (stmt.opCode == 53) {
                    LirNode args = stmt.kid(1);
                    int n = args.nKids();
                    for (int i = 0; i < n; ++i) {
                        if (args.kid((int)i).opCode != 47 || Type.tag(args.kid((int)i).type) != 1) continue;
                        int type = args.kid((int)i).type;
                        String name = ".AG" + tmpn++;
                        LirNode copy = lir.symRef(func.addSymbol(name, 1, type, 0, 0, null));
                        q.addBefore(lir.operator(48, type, lir.operator(47, type, copy, null), args.kid(i), null));
                        args.setKid(i, copy);
                    }
                }
                q = q.next();
            }
            p2 = p2.next();
        }
    }

    private LirNode rewriteAggRef(LirNode node, LirNode[] map) {
        LirNode reg;
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            node.setKid(i, this.rewriteAggRef(node.kid(i), map));
        }
        if (node.opCode == 5 && (reg = map[((LirSymRef)node).symbol.id]) != null) {
            return reg;
        }
        return node;
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new AggregateByReference().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "AggregateByReference";
        }

        public String subject() {
            return "Rewrite Aggregate Parameter Passing";
        }
    }
}

