/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.asmpp;

import coins.backend.asmpp.Pseudo;
import java.util.ArrayList;

class LtorgInstruction
extends Pseudo {
    ArrayList literals = new ArrayList();
    int label = 0;
    int blockSize = 0;
    int braLength = 0;

    LtorgInstruction(String line) {
        super(line);
    }

    public void reset() {
        this.literals.clear();
        this.label = 0;
        this.blockSize = 0;
        this.size = 0;
    }

    public int setAddress(int address) {
        int v = 1 << LtorgInstruction.cpu.codeAlign;
        this.address = address;
        if (this.literals.isEmpty()) {
            return address;
        }
        String l = (String)this.literals.get(0);
        if (l.startsWith("=W")) {
            v = 4;
        }
        this.size = (address + this.braLength + v - 1 & -v) - address;
        v = 1 << LtorgInstruction.cpu.codeAlign;
        return address + this.size + this.blockSize + v - 1 & -v;
    }

    public void addLiteral(String l) {
        for (int index = 0; index < this.literals.size(); ++index) {
            Object o = this.literals.get(index);
            if (!l.equals(o)) continue;
            return;
        }
        this.literals.add(l);
        this.blockSize = l.startsWith("=B") ? ++this.blockSize : (l.startsWith("=S") ? (this.blockSize + 1 & 0xFFFFFFFE) + 2 : (l.startsWith("=D") ? (this.blockSize + 3 & 0xFFFFFFFC) + 8 : (this.blockSize + 3 & 0xFFFFFFFC) + 4));
    }

    public int getAddressOf(String value) {
        int offset = 0;
        int bytes = 0;
        for (int index = 0; index < this.literals.size(); ++index) {
            String l = (String)this.literals.get(index);
            if (l.startsWith("=B")) {
                bytes = 1;
            } else if (l.startsWith("=S")) {
                offset = offset + 1 & 0xFFFFFFFE;
                bytes = 2;
            } else if (l.startsWith("=D")) {
                offset = offset + 3 & 0xFFFFFFFC;
                bytes = 8;
            } else {
                offset = offset + 3 & 0xFFFFFFFC;
                bytes = 4;
            }
            if (value.equals(l)) break;
            offset += bytes;
        }
        if (value.startsWith("=S")) {
            offset = offset + 1 & 0xFFFFFFFE;
        } else if (value.startsWith("=W") || value.startsWith("=D")) {
            offset = offset + 3 & 0xFFFFFFFC;
        }
        return this.address + this.size + offset;
    }

    public String listLiterals() {
        String str = "";
        for (int index = 0; index < this.literals.size(); ++index) {
            str = str + " " + (String)this.literals.get(index);
        }
        return str;
    }

    public String toString() {
        return "LtorgInstruction[" + this.address + ":" + this.size + ":" + this.blockSize + ":" + this.listLiterals() + "]";
    }

    public String generate() {
        String str = "";
        int align = LtorgInstruction.cpu.codeAlign;
        if (!this.literals.isEmpty()) {
            for (int index = 0; index < this.literals.size(); ++index) {
                String s = (String)this.literals.get(index);
                if (s.startsWith("=B")) {
                    str = str + "\n.LB" + (this.label + index) + ":\n\t.byte\t" + s.substring(2);
                    align = 0;
                    continue;
                }
                if (s.startsWith("=S")) {
                    if (align == 0) {
                        str = str + "\n\t.align\t1";
                    }
                    str = str + "\n.LB" + (this.label + index) + ":\n\t.short\t" + s.substring(2);
                    align = 1;
                    continue;
                }
                if (s.startsWith("=D")) {
                    if (align != 2) {
                        str = str + "\n\t.align\t2";
                    }
                    str = str + "\n.LB" + (this.label + index) + ":\n\t.word\t" + s.substring(2).replace('_', ',');
                    align = 2;
                    continue;
                }
                if (align != 2) {
                    str = str + "\n\t.align\t2";
                }
                str = str + "\n.LB" + (this.label + index) + ":\n\t.word\t" + s.substring(2);
                align = 2;
            }
            if (align < LtorgInstruction.cpu.codeAlign) {
                str = str + "\n\t.align\t" + LtorgInstruction.cpu.codeAlign;
            }
            if (str.charAt(0) == '\n') {
                str = str.substring(1);
            }
        }
        return str;
    }

    public String toLabel(String l) {
        if (this.label == 0) {
            return l;
        }
        for (int index = 0; index < this.literals.size(); ++index) {
            if (!l.equals(this.literals.get(index))) continue;
            return ".LB" + (this.label + index);
        }
        return null;
    }

    public int setLabel(int l) {
        this.label = l;
        return this.literals.size();
    }
}

