/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.MachineParams;
import coins.backend.Root;
import coins.backend.ana.EnumRegVars;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BitMapSet;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;
import java.util.Iterator;

public class SaveRegisters
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final BitMapSet calleeSave;
    private Root root;
    private Function function;
    private int timeStamp;
    private EnumRegVars rn;
    private MachineParams m;

    private SaveRegisters(Function func) {
        this.function = func;
        this.root = func.root;
        this.timeStamp = func.timeStamp();
        this.rn = (EnumRegVars)func.require(EnumRegVars.analyzer);
        LirNode.Scanner scan = new LirNode.Scanner();
        this.m = func.module.targetMachine.machineParams;
        this.calleeSave = (BitMapSet)this.m.regSetMap(this.m.getRegSet("*reg-callee-saves*")).clone();
        BitMapSet notUsed = (BitMapSet)this.calleeSave.clone();
        BiLink p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                int def;
                LirNode stmt = (LirNode)q.elem();
                Iterator it = scan.forDefs(stmt);
                while (it.hasNext()) {
                    def = this.rn.index((LirNode)it.next());
                    if (def == 0) continue;
                    this.m.removeRegister(notUsed, def);
                }
                it = scan.forClobbers(stmt);
                while (it.hasNext()) {
                    def = this.rn.index((LirNode)it.next());
                    if (def == 0) continue;
                    this.m.removeRegister(notUsed, def);
                }
                q = q.next();
            }
            p = p.next();
        }
        this.calleeSave.subtract(notUsed);
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
        output.println();
        output.print("Registers should be saved:");
        NumberSet.Iterator it = this.calleeSave.iterator();
        while (it.hasNext()) {
            int reg = it.next();
            output.print(" " + this.m.registerToString(reg));
        }
        output.println();
        output.println();
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new SaveRegisters(func);
        }

        public String name() {
            return "SaveRegisters";
        }
    }
}

