/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.ana.DFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.UnionFind;
import java.io.PrintWriter;

public class LoopAnalysis
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final boolean[] isLoop;
    public final BasicBlk[] loopHeader;
    public final boolean[] multiEntry;
    public final boolean[] hasExit;
    public final int[] nestLevel;
    public final BiList[] kids;
    private Function func;
    private FlowGraph flowGraph;
    private DFST dfst;
    private int timeStamp;

    private LoopAnalysis(Function func) {
        int w;
        this.func = func;
        this.flowGraph = func.flowGraph();
        this.timeStamp = this.flowGraph.timeStamp();
        this.dfst = (DFST)func.require(DFST.analyzer);
        int n = this.dfst.maxDfn;
        UnionFind uf = new UnionFind(n + 1);
        int[] name = new int[n + 1];
        int[] added = new int[n + 1];
        int[] body = new int[n + 1];
        int[] worklist = new int[n + 1];
        int nBlks = this.flowGraph.idBound();
        this.loopHeader = new BasicBlk[nBlks];
        this.isLoop = new boolean[nBlks];
        this.multiEntry = new boolean[nBlks];
        this.hasExit = new boolean[nBlks];
        this.nestLevel = new int[nBlks];
        this.kids = new BiList[nBlks];
        BasicBlk[] v = this.dfst.blkVectorByPre();
        for (w = 1; w <= n; ++w) {
            name[w] = w;
            added[w] = 0;
        }
        for (w = n; w >= 1; --w) {
            int y;
            int nb = 0;
            int nw = 0;
            BiLink s = v[w].predList().first();
            while (!s.atEnd()) {
                int xx;
                int x = this.dfst.dfnPre[((BasicBlk)s.elem()).id];
                if (x != 0 && this.dfst.dfn[v[x].id] >= this.dfst.dfn[v[w].id] && added[xx = name[uf.find(x)]] != w) {
                    int n2 = nw++;
                    int n3 = nb++;
                    int n4 = xx;
                    body[n3] = n4;
                    worklist[n2] = n4;
                    added[xx] = w;
                }
                s = s.next();
            }
            if (nw <= 0) continue;
            this.isLoop[v[w].id] = true;
            while (nw > 0) {
                int x = worklist[--nw];
                BiLink s2 = v[x].predList().first();
                while (!s2.atEnd()) {
                    y = this.dfst.dfnPre[((BasicBlk)s2.elem()).id];
                    if (y != 0 && this.dfst.dfn[v[y].id] < this.dfst.dfn[v[x].id]) {
                        int yy = name[uf.find(y)];
                        if (w <= yy && this.dfst.dfn[v[w].id] <= this.dfst.dfn[v[yy].id]) {
                            if (added[yy] != w && yy != w) {
                                int n5 = nw++;
                                int n6 = nb++;
                                int n7 = yy;
                                body[n6] = n7;
                                worklist[n5] = n7;
                                added[yy] = w;
                            }
                        } else if (x != w) {
                            this.multiEntry[v[w].id] = true;
                        }
                    }
                    s2 = s2.next();
                }
            }
            for (int i = 0; i < nb; ++i) {
                int x = body[i];
                if (x != w) {
                    this.loopHeader[v[x].id] = v[w];
                }
                name[uf.union((int)x, (int)w)] = w;
            }
            boolean itHas = false;
            BiLink s3 = v[w].succList().first();
            while (!s3.atEnd()) {
                y = this.dfst.dfnPre[((BasicBlk)s3.elem()).id];
                if (name[uf.find(y)] != w) {
                    itHas = true;
                    break;
                }
                s3 = s3.next();
            }
            block7: while (nb > 0 && !itHas) {
                int x = body[--nb];
                BiLink s4 = v[x].succList().first();
                while (!s4.atEnd()) {
                    int y2 = this.dfst.dfnPre[((BasicBlk)s4.elem()).id];
                    if (name[uf.find(y2)] != w) {
                        itHas = true;
                        continue block7;
                    }
                    s4 = s4.next();
                }
            }
            this.hasExit[v[w].id] = itHas;
        }
        this.kids[0] = new BiList();
        for (w = 1; w <= n; ++w) {
            BasicBlk parent;
            BasicBlk blk = v[w];
            if (this.isLoop[blk.id] && this.kids[blk.id] == null) {
                this.kids[blk.id] = new BiList();
            }
            if ((parent = this.loopHeader[blk.id]) != null) {
                this.kids[parent.id].add(blk);
                this.nestLevel[blk.id] = this.nestLevel[parent.id] + 1;
            }
            if (!this.isLoop[blk.id]) continue;
            if (parent == null) {
                this.kids[0].add(blk);
            }
            int n8 = blk.id;
            this.nestLevel[n8] = this.nestLevel[n8] + 1;
        }
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.flowGraph.timeStamp();
    }

    public void printIt(PrintWriter out) {
        this.printAfterFunction(out);
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter out) {
        BasicBlk[] v = this.dfst.blkVectorByPre();
        int n = this.dfst.maxDfn;
        out.println("Loop Structure:");
        for (int i = 1; i <= n; ++i) {
            if (!this.isLoop[v[i].id]) continue;
            for (int k = 0; k < this.nestLevel[v[i].id]; ++k) {
                out.print("  ");
            }
            out.print("Loop starts at #" + v[i].id + ": ");
            boolean first = true;
            for (int j = i; j <= n; ++j) {
                if (this.loopHeader[v[j].id] == null || this.loopHeader[v[j].id].id != v[i].id) continue;
                if (!first) {
                    out.print(",");
                }
                out.print("#" + v[j].id);
                first = false;
            }
            if (this.multiEntry[v[i].id]) {
                out.print(" (multi)");
            }
            if (!this.hasExit[v[i].id]) {
                out.print(" (infinite)");
            }
            out.println();
        }
        out.println();
        out.println("Loop Structure:");
        BiLink p = this.kids[0].first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.printLoopTree(blk, out);
            p = p.next();
        }
    }

    private void printLoopTree(BasicBlk loop, PrintWriter out) {
        BasicBlk blk;
        for (int i = 0; i < this.nestLevel[loop.id]; ++i) {
            out.print("  ");
        }
        out.print("#" + loop.id);
        if (this.multiEntry[loop.id]) {
            out.print(" (multi)");
        }
        if (!this.hasExit[loop.id]) {
            out.print(" (infinite)");
        }
        out.print(":");
        String prefix = " ";
        BiLink p = this.kids[loop.id].first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            out.print(prefix + "#" + blk.id);
            prefix = ",";
            p = p.next();
        }
        out.println();
        p = this.kids[loop.id].first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            if (this.isLoop[blk.id]) {
                this.printLoopTree(blk, out);
            }
            p = p.next();
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new LoopAnalysis(func);
        }

        public String name() {
            return "LoopAnalysis";
        }
    }
}

