/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.GlobalTransformer;
import coins.backend.LocalAnalyzer;
import coins.backend.LocalTransformer;
import coins.backend.ModuleElement;
import coins.backend.Root;
import coins.backend.SyntaxError;
import coins.backend.SyntaxErrorException;
import coins.backend.TargetMachine;
import coins.backend.Transformer;
import coins.backend.ana.ControlDependences;
import coins.backend.ana.DominanceFrontiers;
import coins.backend.ana.Dominators;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.ana.LoopAnalysis;
import coins.backend.ana.Postdominators;
import coins.backend.ana.ReverseDFST;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.opt.If2Jumpc;
import coins.backend.opt.IntroVirReg;
import coins.backend.opt.JumpCanon;
import coins.backend.opt.JumpOpt;
import coins.backend.opt.LoopInversion;
import coins.backend.opt.PreHeaders;
import coins.backend.opt.Profiler;
import coins.backend.opt.SimpleOpt;
import coins.backend.regalo.LiveRange;
import coins.backend.sym.Label;
import coins.backend.sym.SymTab;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.Misc;
import coins.backend.util.QuotedString;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class Module {
    static final String DEFAULT_TARGET = "sparc";
    static final String DEFAULT_CONVENTION = "standard";
    public final String name;
    public final SymTab globalSymtab;
    public final BiList elements;
    public final Root root;
    public final TargetMachine targetMachine;
    public final LirFactory newLir;
    private int currentLineNo;
    private long lap;
    private int labelGenerator = 1;
    private Map labelTable;
    private int symbolIdGenerator = 1;
    private Symbol[] constDataTbl = new Symbol[0];
    private int constNumber = 1;

    public Module(Object sexp, Root root) throws SyntaxErrorException {
        this(sexp, DEFAULT_TARGET, DEFAULT_CONVENTION, root);
    }

    public Module(Object sexp, String targetName, String convention, Root root) throws SyntaxErrorException {
        this.root = root;
        this.elements = new BiList();
        this.globalSymtab = new SymTab(this);
        this.labelTable = new HashMap();
        if (targetName == null) {
            targetName = DEFAULT_TARGET;
        }
        if (convention == null) {
            convention = DEFAULT_CONVENTION;
        }
        if (root.dispIntervalTime) {
            this.lap = root.timer.checkPoint();
        }
        root.registerTransformer(IntroVirReg.trig);
        root.registerTransformer(If2Jumpc.trig);
        root.registerTransformer(SimpleOpt.trig);
        root.registerTransformer(JumpOpt.trig);
        root.registerTransformer(JumpCanon.trig);
        root.registerTransformer(PreHeaders.trig);
        root.setHook("LoopInversion", new BiList());
        if (root.optLoopInversion) {
            root.addHook("LoopInversion", LoopInversion.trig);
        }
        root.registerTransformer(Profiler.trig);
        if (root.isOptionSet("profile")) {
            root.addHook("+AfterEarlyRewriting", "Profiler");
        }
        root.registerTransformer(Function.toMachineCodeTrig);
        root.registerTransformer(LiveRange.trig);
        try {
            this.newLir = new LirFactory(this);
            this.targetMachine = new TargetMachine(this.globalSymtab, targetName, convention, this);
            if (root.dispIntervalTime) {
                root.debOut.println("TMD initialization: " + root.timer.getIntervalTime() + " lap:" + root.timer.getIntervalTime(this.lap));
            }
            if (!(sexp instanceof ImList)) {
                throw new SyntaxError("Expected (");
            }
            ImList ptr = (ImList)sexp;
            if (ptr.elem() != "MODULE") {
                throw new SyntaxError("Expected MODULE");
            }
            if ((ptr = ptr.next()).atEnd()) {
                throw new SyntaxError("Expected module name");
            }
            this.name = ((QuotedString)ptr.elem()).body;
            while (!(ptr = ptr.next()).atEnd()) {
                ImList top = (ImList)ptr.elem();
                String kw = (String)top.elem();
                if (kw == "SYMTAB") {
                    this.doSymtbl(top);
                    continue;
                }
                if (kw == "DATA") {
                    this.elements.add(new Data(this, top));
                    continue;
                }
                if (kw == "FUNCTION") {
                    this.elements.add(new Function(this, top));
                    continue;
                }
                if (kw == "LINE") {
                    this.currentLineNo = Integer.parseInt((String)top.elem2nd());
                    continue;
                }
                if (kw == "INFO") {
                    if (top.next().atEnd() || top.elem() != "LINE") continue;
                    this.currentLineNo = Integer.parseInt((String)top.elem3rd());
                    continue;
                }
                throw new SyntaxError("Unexpected " + kw);
            }
            if (root.dispIntervalTime) {
                root.debOut.println("ListLIR->LirNode: " + root.timer.getIntervalTime() + " lap:" + root.timer.getIntervalTime(this.lap));
            }
        }
        catch (SyntaxError e) {
            root.debOut.println(e.getMessage());
            throw new SyntaxErrorException(e.getMessage());
        }
    }

    public int getCurrentLineNo() {
        return this.currentLineNo;
    }

    private void doSymtbl(ImList ptr) throws SyntaxError {
        while (!(ptr = ptr.next()).atEnd()) {
            this.globalSymtab.addSymbol((ImList)ptr.elem());
        }
    }

    public Symbol addSymbol(String name, int storage, int type, int boundary, String segment, String linkage, ImList opt) {
        return this.globalSymtab.addSymbol(name, storage, type, boundary, segment, linkage, opt);
    }

    void doData(ImList node) throws SyntaxError {
        this.elements.add(new Data(this, node));
    }

    public void addData(Symbol sym, LirNode value) {
        this.elements.add(new Data(this, sym, value));
    }

    public Label lookupLabel(String internalName) {
        return (Label)this.labelTable.get(internalName);
    }

    private String genNewLabelName() {
        return (".L" + this.labelGenerator++).intern();
    }

    public Label newLabel() {
        Label label = new Label(this.genNewLabelName());
        this.labelTable.put(label.name(), label);
        return label;
    }

    public void renameLabelToFinal(Label label) {
        if (this.lookupLabel(label.name()) != null) {
            return;
        }
        label.rename(this.genNewLabelName());
        this.labelTable.put(label.name(), label);
    }

    public int genSymbolId() {
        return this.symbolIdGenerator++;
    }

    public int symbolIdBound() {
        return this.symbolIdGenerator;
    }

    public Symbol getSymbol(String name) {
        return this.globalSymtab.get(name);
    }

    public void apply(LocalAnalyzer analyzer) {
        BiLink p = this.elements.first();
        while (!p.atEnd()) {
            if (p.elem() instanceof Function) {
                ((Function)p.elem()).apply(analyzer);
            }
            p = p.next();
        }
    }

    public void require(LocalAnalyzer analyzer) {
        BiLink p = this.elements.first();
        while (!p.atEnd()) {
            if (p.elem() instanceof Function) {
                ((Function)p.elem()).require(analyzer);
            }
            p = p.next();
        }
    }

    public void apply(Object trans) {
        if (trans instanceof ImList) {
            this.apply((ImList)trans);
        } else if (trans instanceof BiList) {
            this.apply((BiList)trans);
        } else if (trans instanceof Transformer[]) {
            this.apply((Transformer[])trans);
        } else if (trans instanceof Transformer) {
            this.apply((Transformer)trans);
        } else if (trans instanceof String[]) {
            this.apply((String[])trans);
        } else if (trans instanceof String) {
            this.apply((String)trans);
        } else {
            throw new CantHappenException("Unexpected type: " + trans.getClass());
        }
    }

    public void apply(String hook) {
        Object trans = this.root.getHook(hook);
        if (trans == null) {
            if (hook.charAt(0) != '+') {
                throw new CantHappenException("Undefined Hook: " + hook);
            }
        } else {
            this.apply(trans);
        }
    }

    public void apply(ImList transList) {
        ImList p = transList;
        while (!p.atEnd()) {
            this.apply(p.elem());
            p = p.next();
        }
    }

    public void apply(BiList transList) {
        BiLink p = transList.first();
        while (!p.atEnd()) {
            this.apply(p.elem());
            p = p.next();
        }
    }

    public void apply(Object[] transVector) {
        for (int i = 0; i < transVector.length; ++i) {
            this.apply(transVector[i]);
        }
    }

    public void apply(Transformer xformer) {
        this.apply(xformer, ImList.list());
    }

    public void apply(Transformer xformer, ImList args) {
        if (this.root.traceOK(xformer.name(), 2)) {
            this.root.debOut.println();
            this.root.debOut.println("Before " + xformer.name() + " (" + xformer.subject() + "):");
            this.printIt(this.root.debOut);
        }
        if (this.root.GCflush) {
            this.root.timer.gcReport(this.root.debOut);
        }
        long start = this.root.timer.getLaptime();
        if (xformer instanceof LocalTransformer) {
            BiLink p = this.elements.first();
            while (!p.atEnd()) {
                if (p.elem() instanceof Function) {
                    ((LocalTransformer)xformer).doIt((Function)p.elem(), args);
                } else if (p.elem() instanceof Data) {
                    ((LocalTransformer)xformer).doIt((Data)p.elem(), args);
                }
                p = p.next();
            }
        } else {
            ((GlobalTransformer)xformer).doIt(this, args);
        }
        if (this.root.dispIntervalTime) {
            this.root.debOut.println(xformer.name() + ": " + this.root.timer.getIntervalTime(start) + "  lap:" + this.root.timer.getIntervalTime(this.lap));
        }
        if (this.root.traceOK(xformer.name(), 1)) {
            this.root.debOut.println();
            this.root.debOut.println("After " + xformer.name() + " (" + xformer.subject() + "):");
            this.printIt(this.root.debOut);
        }
    }

    private void setConstDataTbl(int index, Symbol sym) {
        if (index >= this.constDataTbl.length) {
            Symbol[] w = new Symbol[Misc.clp2(index + 1)];
            for (int i = 0; i < this.constDataTbl.length; ++i) {
                w[i] = this.constDataTbl[i];
            }
            this.constDataTbl = w;
        }
        this.constDataTbl[index] = sym;
    }

    private Symbol getConstDataTbl(int index) {
        if (index < this.constDataTbl.length) {
            return this.constDataTbl[index];
        }
        return null;
    }

    public Symbol constToData(LirNode value) {
        Symbol sym = this.getConstDataTbl(value.id);
        if (sym == null) {
            sym = this.addSymbol(".LC" + this.constNumber++, 0, value.type, this.targetMachine.alignForType(value.type), ".text", "LDEF", null);
            this.addData(sym, value);
            this.setConstDataTbl(value.id, sym);
        }
        return sym;
    }

    public void printStandardForm(PrintWriter out) {
        out.println("(MODULE \"" + this.name + "\"");
        this.globalSymtab.printStandardForm(out, "  ");
        BiLink p = this.elements.first();
        while (!p.atEnd()) {
            ((ModuleElement)p.elem()).printStandardForm(out);
            p = p.next();
        }
        out.println(")");
    }

    public void printIt(PrintWriter out) {
        this.printIt(out, null);
    }

    public void printIt(PrintWriter out, LocalAnalyzer[] anals) {
        out.println("Module \"" + this.name + "\":");
        out.print("Global ");
        this.globalSymtab.printIt(out, this.root.traceOK("LIR", 3));
        BiLink p = this.elements.first();
        while (!p.atEnd()) {
            ((ModuleElement)p.elem()).printIt(out, anals);
            p = p.next();
        }
        out.println("End Module");
        out.println();
    }

    public String toString() {
        return "<Module " + this.name + ">";
    }

    public Object toSexp() {
        ImList list = ImList.Empty;
        list = new ImList("MODULE", list);
        list = new ImList(new QuotedString(this.name), list);
        list = new ImList(this.globalSymtab.toSexp(), list);
        BiLink p = this.elements.first();
        while (!p.atEnd()) {
            list = new ImList(((ModuleElement)p.elem()).toSexp(), list);
            p = p.next();
        }
        return list.destructiveReverse();
    }

    public static void doCompile(ImList sexp, String targetName, String convention, Root root) throws SyntaxErrorException {
        Module compileUnit = new Module(sexp, targetName, convention, root);
        compileUnit.apply(new String[]{"IntroVirReg", "EarlyRewriting", "+AfterEarlyRewriting", "If2Jumpc", "+BeforeBasicOpt", "SimpleOpt", "JumpOpt", "PreHeaders", "LoopInversion", "+AfterBasicOpt", "+BeforeCodeGeneration", "LateRewriting", "+AfterLateRewriting", "ToMachineCode", "+AfterToMachineCode", "ConvToAsm"});
    }

    public static Module loadSLir(ImList sexp, String targetName, String convention, Root root) throws SyntaxErrorException {
        Module compileUnit = new Module(sexp, targetName, convention, root);
        if (root.traceOK("LIR", 1)) {
            root.debOut.println();
            root.debOut.println("After CFG created:");
            compileUnit.printIt(root.debOut);
        }
        compileUnit.apply(new String[]{"IntroVirReg", "EarlyRewriting", "+AfterEarlyRewriting", "If2Jumpc"});
        return compileUnit;
    }

    public void basicOptimization() {
        this.apply(new String[]{"+BeforeBasicOpt", "SimpleOpt", "JumpOpt", "PreHeaders", "LoopInversion", "+AfterBasicOpt"});
    }

    public void setAsmOut(OutputStream codeStream) {
        this.targetMachine.setAsmStream(codeStream);
    }

    public void generateCode(OutputStream codeStream) {
        this.targetMachine.setAsmStream(codeStream);
        this.generateCode();
    }

    public void generateCodeWith(OutputStream codeStream, Object trans) {
        this.targetMachine.setAsmStream(codeStream);
        this.generateCodeWith(trans);
    }

    public void generateCode() {
        this.generateCodeWith(new String[]{"+BeforeCodeGeneration", "LateRewriting", "+AfterLateRewriting", "ToMachineCode", "+AfterToMachineCode", "ConvToAsm"});
    }

    public void generateCodeWith(Object trans) {
        if (this.root.traceOK("LIR", 1)) {
            this.root.debOut.println();
            this.root.debOut.println("Before Code Generation:");
            this.printIt(this.root.debOut, new LocalAnalyzer[]{Dominators.analyzer, DominanceFrontiers.analyzer, Postdominators.analyzer, ControlDependences.analyzer, LoopAnalysis.analyzer, ReverseDFST.analyzer, LiveVariableSlotwise.analyzer});
        }
        this.apply(trans);
        if (this.root.traceOK("ListDump", 1)) {
            this.root.debOut.println("External-LIR Format:");
            ImList.printIt(this.root.debOut, this.toSexp());
        }
        if (this.root.dispIntervalTime) {
            this.root.debOut.println("BackEnd Total: " + this.root.timer.getIntervalTime(this.lap));
        }
    }

    public long elapsedTime() {
        return this.root.timer.getIntervalTime(this.lap);
    }
}

