/*
 * Decompiled with CFR 0.152.
 */
package coins.ast;

import coins.ast.ASTree;
import coins.ast.Pair;

public class TreeWalker {
    private NodeList nodeList;

    public TreeWalker(ASTree root) {
        this.nodeList = new NodeList(null, root);
    }

    private TreeWalker() {
    }

    public TreeWalker copy() {
        TreeWalker w = new TreeWalker();
        w.nodeList = this.nodeList;
        return w;
    }

    public ASTree begin() {
        while (this.left() != null) {
        }
        return this.current();
    }

    public ASTree next() {
        ASTree node;
        while ((node = this.next0()) instanceof Pair) {
        }
        return node;
    }

    private ASTree next0() {
        ASTree c = this.nodeList.node;
        ASTree p = this.parent();
        if (p == null) {
            return null;
        }
        if (this.nodeList.node.getRight() == c) {
            return p;
        }
        if (this.right() == null) {
            return this.current();
        }
        return this.begin();
    }

    public ASTree current() {
        if (this.nodeList == null) {
            return null;
        }
        return this.nodeList.node;
    }

    public ASTree left() {
        if (this.nodeList == null) {
            return null;
        }
        ASTree child = this.nodeList.node.getLeft();
        if (child == null) {
            return null;
        }
        this.nodeList = new NodeList(this.nodeList, child);
        return child;
    }

    public ASTree right() {
        if (this.nodeList == null) {
            return null;
        }
        ASTree child = this.nodeList.node.getRight();
        if (child == null) {
            return null;
        }
        this.nodeList = new NodeList(this.nodeList, child);
        return child;
    }

    public ASTree parent() {
        NodeList p;
        if (this.nodeList == null) {
            return null;
        }
        this.nodeList = p = this.nodeList.parent;
        if (p == null) {
            return null;
        }
        return this.nodeList.node;
    }

    static class NodeList {
        NodeList parent;
        ASTree node;

        NodeList(NodeList p, ASTree n) {
            this.parent = p;
            this.node = n;
        }
    }
}

