/*
 * Decompiled with CFR 0.152.
 */
package coins.ast;

import coins.ast.ASTree;
import coins.ast.Visitor;

public class ASTList
extends ASTree {
    private ASTree left;
    private ASTList right;
    private ASTList rightMost = null;

    public ASTList(ASTree _head, ASTList _tail) {
        this.left = _head;
        this.right = _tail;
        this.rightMost = _tail;
    }

    public ASTList(ASTree _head) {
        this.left = _head;
        this.right = null;
        this.rightMost = null;
    }

    public ASTree getLeft() {
        return this.left;
    }

    public ASTree getRight() {
        return this.right;
    }

    public void setLeft(ASTree _left) {
        this.left = _left;
    }

    public void setRight(ASTree _right) {
        this.right = (ASTList)_right;
    }

    public ASTree head() {
        return this.left;
    }

    public void setHead(ASTree _head) {
        this.left = _head;
    }

    public ASTList tail() {
        return this.right;
    }

    public void setTail(ASTList _tail) {
        this.right = _tail;
        this.rightMost = _tail;
    }

    public void accept(Visitor v) {
        v.atASTList(this);
    }

    protected String getTag() {
        return "<list>";
    }

    protected void rightToString(StringBuffer sbuf, ASTree _right) {
        while (_right != null) {
            if (_right instanceof ASTList) {
                this.putSeparator(sbuf);
                ASTList list = (ASTList)_right;
                this.toString1(sbuf, list.getLeft());
                _right = list.getRight();
                continue;
            }
            sbuf.append(" . ");
            sbuf.append(_right.toString());
            break;
        }
    }

    public boolean subst(ASTree newObj, ASTree oldObj) {
        for (ASTList list = this; list != null; list = list.tail()) {
            if (list.head() != oldObj) continue;
            list.setHead(newObj);
            return true;
        }
        return false;
    }

    public static ASTList append(ASTList a, ASTree b) {
        return ASTList.concat(a, new ASTList(b));
    }

    public static ASTList concat(ASTList a, ASTList b) {
        if (a == null) {
            return b;
        }
        if (a.rightMost != null) {
            ASTList list0 = a.rightMost;
            while (list0.right != null) {
                list0 = list0.right;
            }
            list0.right = b;
            a.rightMost = b;
            return a;
        }
        ASTList list = a;
        while (list.right != null) {
            list = list.right;
        }
        list.right = b;
        a.rightMost = b;
        return a;
    }
}

