/*
 * Decompiled with CFR 0.152.
 */
package coins.alias.alias2;

import coins.HirRoot;
import coins.IoRoot;
import coins.alias.AliasAnalHir1;
import coins.alias.AliasError;
import coins.alias.AliasGroup;
import coins.alias.AliasUtil;
import coins.alias.alias2.AliasFactory2;
import coins.alias.alias2.ConstructPointsToGraph2;
import coins.alias.alias2.Prescan;
import coins.alias.alias2.TagVector2;
import coins.alias.util.BriggsSet;
import coins.alias.util.Scanner;
import coins.ir.hir.Exp;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.RepeatStmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.WhileStmt;
import coins.sym.Elem;
import coins.sym.Label;
import coins.sym.StructType;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AliasAnalHir2
extends AliasAnalHir1 {
    protected static final int AREA_INCLUDES = 1;
    protected static final int AREA_OVERLAPS = 2;
    protected static final int MUST_ALIAS = 3;
    protected static final int NOT_ALIAS = 4;
    protected static final int MAY_ALIAS = 7;
    protected static final String PREDEFINED = "aliaspredefined";
    protected Set fPredefined;
    Map fHIRToLoc;
    private Map fHIRToAliasGroup = new HashMap();
    private Set fAccessedVars;
    private Set fAccessedElems;
    private Set fAccessedConstSubscripts;
    private Set fmallocs;
    TagVector2[] fLocalRootVects;
    int fTagBitCount;
    TagVector2[] fPointsTo;
    private TagVector2 fNonNullInitials;
    private TagVector2 fInitialAddressTakens;
    TagVector2 fGlobals;
    TagVector2 fExternOpt;
    public final HirRoot hirRoot;
    public final IoRoot ioRoot;
    final boolean fIsOptimistic;
    final AliasFactory2 fFactory;
    protected final AliasUtil fUtil;
    private TagVector2 fFullVect;
    Map fVarToLoc;
    Map fSubscriptToMask;
    Map fElemToMask;
    Map fmallocToLoc;
    private Map fVectToParam;
    private boolean fUseLevel1;

    public AliasAnalHir2(HirRoot pHirRoot) {
        this(pHirRoot.ioRoot.getCompileSpecification().getCoinsOptions().getArg("alias") != null ? pHirRoot.ioRoot.getCompileSpecification().getCoinsOptions().getArg("alias").equals("opt") : false, pHirRoot);
    }

    public AliasAnalHir2(boolean pIsOptimistic, HirRoot pHirRoot) {
        super(pIsOptimistic, pHirRoot);
        this.hirRoot = pHirRoot;
        this.ioRoot = this.hirRoot.ioRoot;
        this.fFactory = new AliasFactory2(this.hirRoot);
        this.fUtil = new AliasUtil(this.hirRoot.symRoot);
        this.fIsOptimistic = pIsOptimistic;
        this.readPredefined(this.ioRoot);
        this.dbg(1, "AliasAnalHir2", "optimistic=" + pIsOptimistic);
    }

    private Set readPredefined(IoRoot pIo) {
        HashSet lPredefineds = new HashSet();
        lPredefineds.addAll(this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect);
        this.dbg(2, "AliasAnalHir2", "functionsWithoutSideEffect" + lPredefineds);
        this.fPredefined = lPredefineds;
        return this.fPredefined;
    }

    public void prepareForAliasAnalHir(SubpDefinition pSubpDef) {
        if (!this.jumpCheck(pSubpDef)) {
            this.fUseLevel1 = true;
            super.prepareForAliasAnalHir(pSubpDef);
            return;
        }
        this.fUseLevel1 = false;
        this.init();
        this.prepare(pSubpDef);
        this.constructPointsToGraph(pSubpDef);
        this.buildAliasGroups(pSubpDef);
    }

    boolean jumpCheck(SubpDefinition pSubpDef) {
        return new JumpChecker(pSubpDef).go();
    }

    private void init() {
        this.fVarToLoc = new HashMap();
        this.fSubscriptToMask = new HashMap();
        this.fElemToMask = new HashMap();
        this.fmallocToLoc = new HashMap();
        this.fVectToParam = new HashMap();
    }

    void prepare(SubpDefinition pSubpDef) {
        int i;
        Prescan lBuilder = new Prescan(pSubpDef, this);
        lBuilder.process();
        this.fAccessedVars = lBuilder.fAccessedVars;
        this.fAccessedElems = lBuilder.fAccessedElems;
        this.fAccessedConstSubscripts = lBuilder.fAccessedConstSubscripts;
        this.fmallocs = lBuilder.fmallocs;
        this.fTagBitCount = lBuilder.fTagBitCount;
        this.countBits();
        this.fFullVect = this.fFactory.tagVector(this.fTagBitCount);
        this.fFullVect.vectorNot(this.fFullVect);
        this.fNonNullInitials = this.fFactory.tagVector(this.fTagBitCount);
        this.fInitialAddressTakens = this.fFactory.tagVector(this.fTagBitCount);
        this.fGlobals = this.fFactory.tagVector(this.fTagBitCount);
        this.fExternOpt = this.fFactory.tagVector(this.fTagBitCount);
        this.fLocalRootVects = new TagVector2[this.fTagBitCount];
        this.fPointsTo = new TagVector2[this.fTagBitCount];
        for (i = 0; i < this.fTagBitCount; ++i) {
            this.fLocalRootVects[i] = this.fFactory.tagVector(this.fTagBitCount);
            this.fPointsTo[i] = this.fFactory.tagVector(this.fTagBitCount);
        }
        this.assignBits();
        for (i = 0; i < this.fTagBitCount; ++i) {
            if (!this.fNonNullInitials.isSet(i)) continue;
            this.fPointsTo[i].vectorOr(this.fInitialAddressTakens, this.fPointsTo[i]);
            for (Map.Entry lEntry : this.fVectToParam.entrySet()) {
                TagVector2 lVect = (TagVector2)lEntry.getKey();
                if (!lVect.isSet(i)) continue;
                this.fPointsTo[i].fAssociatedParam = (Var)lEntry.getValue();
                break;
            }
            if (this.fDbgLevel <= 3) continue;
            this.dbg(5, "fPointsTo", Arrays.asList(this.fPointsTo));
        }
    }

    private void countBits() {
        for (Var lVar : this.fAccessedVars) {
            if (this.fDbgLevel > 3) {
                this.dbg(5, "counting bits for ", lVar);
                this.dbg(5, "current count = " + this.fTagBitCount, "");
            }
            this.countUnder(lVar.getSymType());
        }
        if (this.fDbgLevel > 3) {
            this.dbg(5, "fTagBitCount", new Integer(this.fTagBitCount));
        }
    }

    private void countUnder(Type pType) {
        if (this.fDbgLevel > 3) {
            this.dbg(5, "counting bits for ", pType);
            this.dbg(5, "current count = " + this.fTagBitCount, "");
        }
        switch (pType.getTypeKind()) {
            case 23: {
                Type lSubtype = ((VectorType)pType).getElemType();
                for (List lPair : this.fAccessedConstSubscripts) {
                    if (lPair.get(1) != this.fUtil.toBareAndSigned(lSubtype)) continue;
                    ++this.fTagBitCount;
                    this.countUnder(lSubtype);
                }
                break;
            }
            case 24: {
                ListIterator lElemIt = ((StructType)pType).getElemList().iterator();
                while (lElemIt.hasNext()) {
                    Elem lElem = (Elem)lElemIt.next();
                    if (!this.fAccessedElems.contains(lElem)) continue;
                    ++this.fTagBitCount;
                    this.countUnder(lElem.getSymType());
                }
                break;
            }
        }
    }

    private void assignBits() {
        TagVector2 lTagVect;
        BitAssigner lAssigner = new BitAssigner();
        for (Var lVar : this.fAccessedVars) {
            lTagVect = this.fFactory.tagVector(this.fTagBitCount);
            lTagVect.fIsDefinite = true;
            this.fVarToLoc.put(lVar, lTagVect);
            lAssigner.assignUnder(lTagVect, lVar.getSymType());
            if (lVar.getSymKind() == 9) {
                this.fNonNullInitials.vectorOr(lTagVect, this.fNonNullInitials);
                if (this.fIsOptimistic) {
                    this.fVectToParam.put(lTagVect, lVar);
                }
            }
            if (lVar.getStorageClass() != 6) continue;
            if (lVar.isGlobal()) {
                this.fGlobals.vectorOr(lTagVect, this.fGlobals);
                this.fInitialAddressTakens.vectorOr(lTagVect, this.fInitialAddressTakens);
            }
            if (lVar.getFlag(6)) {
                this.fInitialAddressTakens.vectorOr(lTagVect, this.fInitialAddressTakens);
            }
            this.fNonNullInitials.vectorOr(lTagVect, this.fNonNullInitials);
        }
        for (Exp lmalloc : this.fmallocs) {
            lTagVect = this.fFactory.tagVector(this.fTagBitCount);
            this.fmallocToLoc.put(lmalloc, lTagVect);
            lTagVect.setBit(lAssigner.fCurBitPos);
            lTagVect.vectorCopy(this.fLocalRootVects[lAssigner.fCurBitPos++]);
        }
        if (lAssigner.fCurBitPos != this.fTagBitCount - 1) {
            throw new AliasError();
        }
        this.fGlobals.vectorCopy(this.fExternOpt);
        this.fExternOpt.setBit(this.fTagBitCount - 1);
        this.fInitialAddressTakens.setBit(this.fTagBitCount - 1);
        this.fNonNullInitials.setBit(this.fTagBitCount - 1);
        TagVector2 lExternVect = this.fFactory.tagVector(this.fTagBitCount);
        lExternVect.setBit(this.fTagBitCount - 1);
        this.fLocalRootVects[this.fTagBitCount - 1] = lExternVect;
    }

    private TagVector2[] constructPointsToGraph(SubpDefinition pSubpDef) {
        ConstructPointsToGraph2 lConstructPointsToGraph2 = new ConstructPointsToGraph2(pSubpDef, this);
        this.fPointsTo = lConstructPointsToGraph2.fPointsTo;
        this.fHIRToLoc = lConstructPointsToGraph2.fHIRToLoc;
        if (this.fDbgLevel > 2) {
            this.dbg(3, "fPointsTo after points-to graph creation ", Arrays.asList(this.fPointsTo));
        }
        return this.fPointsTo;
    }

    private Map buildAliasGroups(SubpDefinition pSubpDef) {
        AliasGroup lAliasGroup;
        BriggsSet lBriggsSet;
        TagVector2 lTagVect;
        AliasGroup[] lAliasGroups = new AliasGroup[this.fTagBitCount];
        for (int i = 0; i < lAliasGroups.length; ++i) {
            lAliasGroups[i] = this.fFactory.aliasGroup();
        }
        HashMap<TagVector2, BriggsSet> lTagToAliasGroups = new HashMap<TagVector2, BriggsSet>();
        for (Map.Entry lEntry : this.fHIRToLoc.entrySet()) {
            Exp lExp = (Exp)lEntry.getKey();
            lTagVect = (TagVector2)lEntry.getValue();
            lBriggsSet = lTagVect.toBriggsSet();
            Scanner lScanner = lBriggsSet.scanner();
            while (lScanner.hasNext()) {
                int lBitPos = lScanner.next();
                lAliasGroups[lBitPos].add(lExp);
            }
            lTagToAliasGroups.put(lTagVect, lBriggsSet);
        }
        Object lIt = this.fHIRToLoc.entrySet().iterator();
        while (lIt.hasNext()) {
            Map.Entry lEntry;
            lAliasGroup = this.fFactory.aliasGroup();
            lEntry = lIt.next();
            Exp lExp = (Exp)lEntry.getKey();
            if (this.fDbgLevel > 3) {
                this.dbg(5, "Building AliasGroup for " + lExp + " ...", "");
            }
            lTagVect = (TagVector2)lEntry.getValue();
            lBriggsSet = (BriggsSet)lTagToAliasGroups.get(lTagVect);
            Scanner lScanner = lBriggsSet.scanner();
            while (lScanner.hasNext()) {
                int lBitPos = lScanner.next();
                for (Exp lExp0 : lAliasGroups[lBitPos]) {
                    Exp lExp1 = lExp;
                    Exp lUnion = null;
                    while (lExp1.getOperator() == 19 || lExp1.getOperator() == 17) {
                        if (lExp1.getType().getTypeKind() == 25) {
                            lUnion = lExp1;
                        }
                        lExp1 = lExp1.getExp1();
                    }
                    if (lExp1.getType().getTypeKind() == 25) {
                        lUnion = lExp1;
                    }
                    Type lType = lUnion == null ? lExp.getType() : lUnion.getType();
                    lExp1 = lExp0;
                    lUnion = null;
                    while (lExp1.getOperator() == 19 || lExp1.getOperator() == 17) {
                        if (lExp1.getType().getTypeKind() == 25) {
                            lUnion = lExp1;
                        }
                        lExp1 = lExp1.getExp1();
                    }
                    if (lExp1.getType().getTypeKind() == 25) {
                        lUnion = lExp1;
                    }
                    Type lType0 = lUnion == null ? lExp0.getType() : lUnion.getType();
                    TagVector2 lTagVect0 = (TagVector2)this.fHIRToLoc.get(lExp0);
                    if (this.fIsOptimistic && (!this.fUtil.mayAlias(lType, lType0) || lTagVect.fAssociatedParam != null && lTagVect0.fAssociatedParam != null && lTagVect.fAssociatedParam != lTagVect0.fAssociatedParam)) continue;
                    lAliasGroup.add(lExp0);
                }
            }
            this.fHIRToAliasGroup.put(lExp, lAliasGroup);
        }
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("Alias", 3)) {
            lIt = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
            while (lIt.hasNext()) {
                HIR lHIR = lIt.next();
                if (!this.fHIRToLoc.containsKey(lHIR)) continue;
                lAliasGroup = (AliasGroup)this.fHIRToAliasGroup.get(lHIR);
                this.ioRoot.printOut.println("AliasGroup for " + lHIR + ": " + lAliasGroup.sort());
            }
        }
        return this.fHIRToAliasGroup;
    }

    protected int areAliased(Exp pExp, Exp pExp0) {
        if (this.fUseLevel1) {
            return super.areAliased(pExp, pExp0);
        }
        if (!this.isLvalue(pExp)) {
            throw new IllegalArgumentException(pExp + " not lvalue.");
        }
        if (!this.isLvalue(pExp0)) {
            throw new IllegalArgumentException(pExp0 + " not lvalue.");
        }
        if (this.getAliasGroupFor(pExp).contains(pExp0)) {
            return this.areAliased0(pExp, pExp0);
        }
        return 4;
    }

    private int areAliased0(Exp pExp, Exp pExp0) {
        TagVector2 lTagVect1 = this.fFactory.tagVector(this.fTagBitCount);
        TagVector2 lTag = null;
        lTag = (TagVector2)this.fHIRToLoc.get(pExp);
        TagVector2 lTag0 = (TagVector2)this.fHIRToLoc.get(pExp0);
        TagVector2 lTagVect = lTag;
        TagVector2 lTagVect0 = lTag0;
        lTagVect.vectorAnd(lTagVect0, lTagVect1);
        if (!lTagVect1.isZero()) {
            if (lTagVect.vectorEqual(lTagVect1) && lTag0.fIsDefinite || lTagVect0.vectorEqual(lTagVect1) && lTag.fIsDefinite) {
                return 3;
            }
            return 7;
        }
        throw new AliasError("Unexpected.");
    }

    public AliasGroup getAliasGroupFor(Exp pExp) {
        if (this.fUseLevel1) {
            return super.getAliasGroupFor(pExp);
        }
        return (AliasGroup)this.fHIRToAliasGroup.get(pExp);
    }

    public void printAliasPairs(SubpDefinition pSubpDef) {
        if (this.fUseLevel1) {
            super.printAliasPairs(pSubpDef);
            return;
        }
        ArrayList<HIR> lHIRList = new ArrayList<HIR>();
        TagVector2 lTagVect1 = this.fFactory.tagVector(this.fTagBitCount);
        HirIterator lIt = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
        while (lIt.hasNext()) {
            HIR lHIR = lIt.next();
            lHIRList.add(lHIR);
        }
        HIR[] lHIRs = lHIRList.toArray(new HIR[0]);
        this.ioRoot.printOut.println("---Alias Pairs--- " + pSubpDef.getSubpSym().getName());
        this.ioRoot.printOut.println("Legend (D: Definitely aliased, P: Possibly aliased)");
        this.ioRoot.printOut.println("");
        for (int i = 0; i < lHIRs.length; ++i) {
            TagVector2 lTagVect = (TagVector2)this.fHIRToLoc.get(lHIRs[i]);
            if (lTagVect == null) continue;
            block6: for (int j = i + 1; j < lHIRs.length; ++j) {
                TagVector2 lTagVect0 = (TagVector2)this.fHIRToLoc.get(lHIRs[j]);
                if (lTagVect0 == null) continue;
                switch (this.areAliased((Exp)lHIRs[i], (Exp)lHIRs[j])) {
                    case 3: {
                        this.ioRoot.printOut.println("(D: " + lHIRs[i] + ", " + lHIRs[j] + ")");
                        continue block6;
                    }
                    case 7: {
                        this.ioRoot.printOut.println("(P: " + lHIRs[i] + ", " + lHIRs[j] + ")");
                    }
                }
            }
        }
        this.ioRoot.printOut.println();
    }

    public boolean mayAlias(Exp pExp, Exp pExp0) {
        if (this.fUseLevel1) {
            return super.mayAlias(pExp, pExp0);
        }
        return (this.areAliased(pExp, pExp0) & 3) != 0;
    }

    public boolean mustAlias(Exp pExp, Exp pExp0) {
        if (this.fUseLevel1) {
            return super.mustAlias(pExp, pExp0);
        }
        return (this.areAliased(pExp, pExp0) & 4) == 0;
    }

    public boolean isLvalue(Exp pExp) {
        if (this.fUseLevel1) {
            return super.isLvalue(pExp);
        }
        return this.fHIRToLoc.containsKey(pExp);
    }

    private class BitAssigner {
        int fCurBitPos;

        private BitAssigner() {
        }

        private void assignUnder(TagVector2 pVarVect, Type pType) {
            HashMap<List, TagVector2> lSubscriptToLocalVectorElemMask = new HashMap<List, TagVector2>();
            HashMap<Elem, TagVector2> lElemToLocalStructMemMask = new HashMap<Elem, TagVector2>();
            int lAggregateBitPos = this.fCurBitPos;
            AliasAnalHir2.this.fLocalRootVects[this.fCurBitPos].setBit(this.fCurBitPos);
            pVarVect.setBit(this.fCurBitPos++);
            switch (pType.getTypeKind()) {
                case 23: {
                    TagVector2 lLocalVectorElemMask;
                    TagVector2 lMaskVect;
                    lSubscriptToLocalVectorElemMask.clear();
                    Type lSubtype = ((VectorType)pType).getElemType();
                    TagVector2 lLocalVectorMask = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                    for (List lPair : AliasAnalHir2.this.fAccessedConstSubscripts) {
                        if (lPair.get(1) != AliasAnalHir2.this.fUtil.toBareAndSigned(lSubtype)) continue;
                        lMaskVect = (TagVector2)AliasAnalHir2.this.fSubscriptToMask.get(lPair);
                        if (lMaskVect == null) {
                            lMaskVect = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                            AliasAnalHir2.this.fFullVect.vectorCopy(lMaskVect);
                            AliasAnalHir2.this.fSubscriptToMask.put(lPair, lMaskVect);
                        }
                        lLocalVectorMask.setBit(this.fCurBitPos);
                        lLocalVectorElemMask = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                        lLocalVectorElemMask.setBit(this.fCurBitPos);
                        lSubscriptToLocalVectorElemMask.put(lPair, lLocalVectorElemMask);
                        this.assignUnder(pVarVect, lSubtype);
                    }
                    for (List lPair : AliasAnalHir2.this.fAccessedConstSubscripts) {
                        if (lPair.get(1) != AliasAnalHir2.this.fUtil.toBareAndSigned(lSubtype)) continue;
                        lMaskVect = (TagVector2)AliasAnalHir2.this.fSubscriptToMask.get(lPair);
                        lLocalVectorElemMask = (TagVector2)lSubscriptToLocalVectorElemMask.get(lPair);
                        lLocalVectorElemMask.vectorXor(lLocalVectorMask, lLocalVectorElemMask);
                        lMaskVect.vectorSub(lLocalVectorElemMask, lMaskVect);
                        lMaskVect.resetBit(lAggregateBitPos);
                        lMaskVect.fIsDefinite = true;
                    }
                    break;
                }
                case 24: {
                    TagVector2 lLocalStructMemMask;
                    TagVector2 lMaskVect;
                    Elem lElem;
                    lElemToLocalStructMemMask.clear();
                    TagVector2 lLocalStructMask = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                    ListIterator lElemIt = ((StructType)pType).getElemList().iterator();
                    while (lElemIt.hasNext()) {
                        lElem = (Elem)lElemIt.next();
                        if (!AliasAnalHir2.this.fAccessedElems.contains(lElem)) continue;
                        lMaskVect = (TagVector2)AliasAnalHir2.this.fElemToMask.get(lElem);
                        if (lMaskVect == null) {
                            lMaskVect = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                            AliasAnalHir2.this.fFullVect.vectorCopy(lMaskVect);
                            AliasAnalHir2.this.fElemToMask.put(lElem, lMaskVect);
                        }
                        lLocalStructMask.setBit(this.fCurBitPos);
                        lLocalStructMemMask = AliasAnalHir2.this.fFactory.tagVector(AliasAnalHir2.this.fTagBitCount);
                        lLocalStructMemMask.setBit(this.fCurBitPos);
                        lElemToLocalStructMemMask.put(lElem, lLocalStructMemMask);
                        this.assignUnder(pVarVect, lElem.getSymType());
                    }
                    lElemIt = ((StructType)pType).getElemList().iterator();
                    while (lElemIt.hasNext()) {
                        lElem = (Elem)lElemIt.next();
                        if (!AliasAnalHir2.this.fAccessedElems.contains(lElem)) continue;
                        lMaskVect = (TagVector2)AliasAnalHir2.this.fElemToMask.get(lElem);
                        lLocalStructMemMask = (TagVector2)lElemToLocalStructMemMask.get(lElem);
                        lLocalStructMemMask.vectorXor(lLocalStructMask, lLocalStructMemMask);
                        lMaskVect.vectorSub(lLocalStructMemMask, lMaskVect);
                        lMaskVect.resetBit(lAggregateBitPos);
                        lMaskVect.fIsDefinite = true;
                    }
                    break;
                }
                case 25: {
                    break;
                }
            }
        }
    }

    private class JumpChecker
    extends HirVisitorModel2 {
        private boolean fUnstructuredJumpDetected;
        List fLoopStack;
        List fSwitchStack;
        SubpDefinition fSubpDef;

        private JumpChecker(SubpDefinition pSubpDef) {
            super(AliasAnalHir2.this.hirRoot);
            this.fLoopStack = new ArrayList();
            this.fSwitchStack = new ArrayList();
            this.fSubpDef = pSubpDef;
        }

        private boolean go() {
            this.visit(this.fSubpDef.getHirBody());
            return !this.fUnstructuredJumpDetected;
        }

        public void atForStmt(ForStmt pFor) {
            if (!pFor.isSimpleForLoop()) {
                this.fUnstructuredJumpDetected = true;
                return;
            }
            this.fLoopStack.add(pFor);
            this.visitChildren(pFor);
            this.fLoopStack.remove(this.fLoopStack.size() - 1);
        }

        public void atLoopStmt(LoopStmt pFor) {
            this.fLoopStack.add(pFor);
            this.visitChildren(pFor);
            this.fLoopStack.remove(this.fLoopStack.size() - 1);
        }

        public void atRepeatStmt(RepeatStmt pFor) {
            if (!pFor.isSimpleRepeatLoop()) {
                this.fUnstructuredJumpDetected = true;
                return;
            }
            this.fLoopStack.add(pFor);
            this.visitChildren(pFor);
            this.fLoopStack.remove(this.fLoopStack.size() - 1);
        }

        public void atWhileStmt(WhileStmt pFor) {
            if (!pFor.isSimpleWhileLoop()) {
                this.fUnstructuredJumpDetected = true;
                return;
            }
            this.fLoopStack.add(pFor);
            this.visitChildren(pFor);
            this.fLoopStack.remove(this.fLoopStack.size() - 1);
        }

        public void atSwitchStmt(SwitchStmt pSwitch) {
            this.fSwitchStack.add(pSwitch);
            this.visitChildren(pSwitch);
            this.fSwitchStack.remove(pSwitch);
        }

        public void atJumpStmt(JumpStmt pJumpStmt) {
            Label lLabel = pJumpStmt.getLabel();
            switch (lLabel.getLabelKind()) {
                case 8: 
                case 21: {
                    if (this.fLoopStack.size() > 0 && ((LoopStmt)this.fLoopStack.get(this.fLoopStack.size() - 1)).getLabel() == lLabel) {
                        return;
                    }
                }
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 16: 
                case 18: 
                case 20: {
                    this.fUnstructuredJumpDetected = true;
                    return;
                }
                case 22: {
                    if (((SwitchStmt)this.fSwitchStack.get(this.fSwitchStack.size() - 1)).getEndLabel() == lLabel) {
                        return;
                    }
                    this.fUnstructuredJumpDetected = true;
                    return;
                }
            }
        }
    }
}

