/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.alias.Tag;
import coins.alias.util.BitVector;
import coins.alias.util.BitVectorIterator;
import coins.alias.util.BriggsSet;
import java.util.HashSet;
import java.util.Set;

class TagVector
extends BitVector {
    private Set fSet = new HashSet();
    private BriggsSet fBriggs;
    private boolean fSetSynced;
    private boolean fBriggsSynced;

    TagVector(int pBitCount) {
        super(pBitCount);
        this.fBriggs = new BriggsSet(pBitCount);
    }

    public void setBit(int pIndex) {
        super.setBit(pIndex);
        this.fSetSynced = false;
        this.fBriggsSynced = false;
    }

    public void resetBit(int pIndex) {
        super.resetBit(pIndex);
        this.fSetSynced = false;
        this.fBriggsSynced = false;
    }

    public BitVector vectorNot(BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorNot(pResult);
    }

    public BitVector vectorAnd(BitVector pOperand2, BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorAnd(pOperand2, pResult);
    }

    public BitVector vectorOr(BitVector pOperand2, BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorOr(pOperand2, pResult);
    }

    public BitVector vectorXor(BitVector pOperand2, BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorXor(pOperand2, pResult);
    }

    public BitVector vectorSub(BitVector pOperand2, BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorSub(pOperand2, pResult);
    }

    public BitVector vectorCopy(BitVector pResult) {
        ((TagVector)pResult).fSetSynced = false;
        ((TagVector)pResult).fBriggsSynced = false;
        return super.vectorCopy(pResult);
    }

    public BitVector vectorReset() {
        super.vectorReset();
        this.fSetSynced = false;
        this.fBriggsSynced = false;
        return this;
    }

    Set toSet(Tag[] pBitAssignedTags) {
        if (this.fSetSynced) {
            return this.fSet;
        }
        this.fSet.clear();
        BitVectorIterator lIt = this.bitVectorIterator();
        while (lIt.hasNext()) {
            int lIndex = lIt.nextIndex();
            if (lIndex == 0) continue;
            this.fSet.add(pBitAssignedTags[lIndex]);
        }
        this.fSetSynced = true;
        return this.fSet;
    }

    BriggsSet toBriggsSet() {
        if (this.fBriggsSynced) {
            return this.fBriggs;
        }
        this.fBriggs.makeSetEmpty();
        BitVectorIterator lIt = this.bitVectorIterator();
        while (lIt.hasNext()) {
            int lIndex = lIt.nextIndex();
            if (lIndex == -1) continue;
            this.fBriggs.insertElement(lIndex);
        }
        this.fBriggsSynced = true;
        return this.fBriggs;
    }
}

