/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.HirRoot;
import coins.IoRoot;
import coins.alias.AliasAnalHir1;
import coins.alias.AliasError;
import coins.alias.AliasFactory;
import coins.alias.AliasUtil;
import coins.alias.Tag;
import coins.alias.TagVector;
import coins.alias.util.Scanner;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.PointedExp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ConstructPointsToGraph {
    private boolean fIsOptimistic;
    private List fAssigns = new ArrayList();
    private List fExps = new ArrayList();
    private Map fHIRToTag;
    private Map fHIRTomallocTag;
    private int fTagBitCount;
    private Tag[] fBitAssignedTags;
    private final AliasFactory fFactory;
    private final AliasUtil fUtil;
    private TagVector[] fPointsTo;
    private final TagVector fRoot;
    private final TagVector fCurFrame;
    private final TagVector fStatic;
    private final TagVector fHeap;
    private final TagVector fOther;
    private final TagVector fGlobals;
    private final TagVector fExternPes;
    private final TagVector fExternOpt;
    private final AliasAnalHir1 fAliasAnal;
    public final HirRoot hirRoot;
    public final IoRoot ioRootAlias;
    protected TagVector fAddressExternallyVisibles = null;

    ConstructPointsToGraph(AliasAnalHir1 pAnal, HirRoot pHirRoot) {
        this.hirRoot = pHirRoot;
        this.ioRootAlias = this.hirRoot.ioRoot;
        this.fHIRToTag = pAnal.fHIRToTag;
        this.fHIRTomallocTag = pAnal.fHIRTomallocTag;
        this.fTagBitCount = pAnal.fTagBitCount;
        this.fBitAssignedTags = pAnal.fBitAssignedTags;
        this.fPointsTo = pAnal.fPointsTo;
        this.fFactory = pAnal.fFactory;
        this.fUtil = pAnal.fUtil;
        this.fAliasAnal = pAnal;
        if (this.ioRootAlias.dbgAlias.getLevel() > 0) {
            this.fAliasAnal.dbg(2, "ConstructPointsToGraph", "tagBitCount " + this.fTagBitCount);
        }
        this.fIsOptimistic = pAnal.fIsOptimistic;
        TagVector lTagVect = this.fFactory.tagVector(this.fTagBitCount);
        this.fRoot = (TagVector)lTagVect.vectorNot(lTagVect);
        this.fCurFrame = pAnal.fCurFrame;
        this.fStatic = pAnal.fStatic;
        this.fHeap = pAnal.fHeap;
        this.fOther = pAnal.fOther;
        this.fGlobals = pAnal.fGlobals;
        this.fExternOpt = pAnal.fExternOpt;
        this.fExternPes = pAnal.fExternPes;
    }

    TagVector[] makePointsToGraph(SubpDefinition pSubpDef) {
        if (this.ioRootAlias.dbgAlias.getLevel() > 0) {
            this.fAliasAnal.dbg(3, "makePointsToGraph", pSubpDef.getSubpSym().getName());
        }
        AssignAndExpScanner lScanner = new AssignAndExpScanner(pSubpDef);
        lScanner.visit(pSubpDef.getHirBody());
        if (this.ioRootAlias.dbgAlias.getLevel() > 3) {
            this.fAliasAnal.dbg(4, "fExps", this.fExps.toString());
        }
        TagVector[] lReturnVal = this.process();
        return lReturnVal;
    }

    private TagVector[] process() {
        if (this.ioRootAlias.dbgAlias.getLevel() > 0) {
            this.fAliasAnal.dbg(2, "TagVector.process", "fPointsTo.length " + this.fPointsTo.length + "fAssigns.length " + this.fPointsTo.length + " fTagBitCount " + this.fTagBitCount);
        }
        Object[] lPointsTo = new TagVector[this.fPointsTo.length];
        for (int i = 0; i < this.fPointsTo.length; ++i) {
            lPointsTo[i] = this.fFactory.tagVector(this.fTagBitCount);
        }
        if (this.ioRootAlias.dbgAlias.getLevel() > 3) {
            this.fAliasAnal.dbg(5, "lPointsTo(initial)", Arrays.asList(this.fPointsTo));
        }
        int lRepetition = 0;
        do {
            ++lRepetition;
            if (this.ioRootAlias.dbgAlias.getLevel() > 0) {
                this.fAliasAnal.dbg(2, "ConsructPointsToGraph", "repetition " + lRepetition);
            }
            for (int j = 0; j < this.fPointsTo.length; ++j) {
                this.fPointsTo[j].vectorCopy(lPointsTo[j]);
            }
            for (AssignStmt lAssignStmt : this.fAssigns) {
                TagVector lLLocVect = this.findLLocSet(lAssignStmt.getLeftSide());
                TagVector lRLocVect = this.findRLocSet(lAssignStmt.getRightSide());
                if (this.ioRootAlias.dbgAlias.getLevel() > 3) {
                    this.fAliasAnal.dbg(6, "lAssignStmt ", lAssignStmt.toStringShort());
                    this.fAliasAnal.dbg(6, "lLLLLocVect ", lLLocVect);
                    this.fAliasAnal.dbg(6, "lRLLLocVect ", lRLocVect);
                }
                if (lRLocVect.isZero() || lLLocVect.isZero()) continue;
                Scanner lScanner = lLLocVect.toBriggsSet().scanner();
                while (lScanner.hasNext()) {
                    int lNext = lScanner.next();
                    this.fPointsTo[lNext].vectorOr(lRLocVect, this.fPointsTo[lNext]);
                    if (this.ioRootAlias.dbgAlias.getLevel() <= 3) continue;
                    this.fAliasAnal.dbg(6, "fPointsTo " + lNext, Arrays.asList(this.fPointsTo));
                }
            }
            Iterator lIt = this.fExps.iterator();
            while (lIt.hasNext()) {
                this.findRLocSet((Exp)lIt.next());
            }
            this.fAliasAnal.dbg(5, "ConstructPointsToGraph", "Main loop");
            if (this.ioRootAlias.dbgAlias.getLevel() <= 3) continue;
            this.fAliasAnal.dbg(5, "fPointsTo", Arrays.asList(this.fPointsTo));
        } while (!Arrays.equals(this.fPointsTo, lPointsTo));
        return this.fPointsTo;
    }

    private TagVector findLLocSet(Exp pLHS) {
        Tag lTag = (Tag)this.fHIRToTag.get(pLHS);
        if (lTag == null) {
            return this.fFactory.tagVector(this.fTagBitCount);
        }
        if (lTag.isAnchored()) {
            return lTag.fTagVect;
        }
        return new LocVisitor(pLHS).process();
    }

    private TagVector findRLocSet(Exp pRHS) {
        return new LocVisitor(pRHS).process();
    }

    private void printPointsToGraph() {
        for (int i = 0; i < this.fPointsTo.length; ++i) {
            this.ioRootAlias.printOut.println(this.fBitAssignedTags[i] + " points to ");
            Scanner lScanner = this.fPointsTo[i].toBriggsSet().scanner();
            while (lScanner.hasNext()) {
                this.ioRootAlias.printOut.println(" " + this.fBitAssignedTags[lScanner.next()]);
            }
        }
    }

    private TagVector storageClassVect(int pStorageClass) {
        switch (pStorageClass) {
            case 0: {
                return this.fRoot;
            }
            case 1: {
                return this.fCurFrame;
            }
            case 2: {
                return this.fStatic;
            }
            case 3: {
                return this.fHeap;
            }
            case 4: {
                return this.fOther;
            }
        }
        throw new AliasError("Unexpected.");
    }

    static /* synthetic */ Map access$1000(ConstructPointsToGraph x0) {
        return x0.fHIRTomallocTag;
    }

    static /* synthetic */ AliasUtil access$1100(ConstructPointsToGraph x0) {
        return x0.fUtil;
    }

    static /* synthetic */ TagVector access$1200(ConstructPointsToGraph x0) {
        return x0.fExternOpt;
    }

    static /* synthetic */ TagVector access$1300(ConstructPointsToGraph x0) {
        return x0.fExternPes;
    }

    static /* synthetic */ TagVector access$1500(ConstructPointsToGraph x0) {
        return x0.fCurFrame;
    }

    private class LocVisitor
    extends HirVisitorModel2 {
        TagVector fTagVect;
        Exp fRoot;

        LocVisitor(Exp pRoot) {
            super(ConstructPointsToGraph.this.hirRoot);
            this.fTagVect = ConstructPointsToGraph.this.fFactory.tagVector(ConstructPointsToGraph.this.fTagBitCount);
            this.fRoot = pRoot;
        }

        TagVector process() {
            this.visit(this.fRoot);
            return this.fTagVect;
        }

        public void atVarNode(VarNode pVarNode) {
            TagVector lTagVect = ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pVarNode)).fTagVect;
            this.dereferenceIfNeeded(lTagVect, pVarNode);
        }

        public void atExp(Exp pExp) {
            switch (pExp.getOperator()) {
                case 68: {
                    TagVector lTagVect = new LocVisitor((Exp)pExp.getChild1()).process();
                    if (pExp.getType().getTypeKind() == 27) break;
                    ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pExp)).fTagVect = lTagVect;
                    this.dereferenceIfNeeded(lTagVect, pExp);
                    break;
                }
                case 38: 
                case 39: {
                    this.visitChildren(pExp);
                    Scanner lScanner0 = this.fTagVect.toBriggsSet().scanner();
                    while (lScanner0.hasNext()) {
                        if (this.ioRoot.dbgAlias.getLevel() > 3) {
                            ConstructPointsToGraph.this.fAliasAnal.dbg(6, "fTagVect = ", this.fTagVect);
                        }
                        int lNext = lScanner0.next();
                        if (ConstructPointsToGraph.this.fIsOptimistic) {
                            this.fTagVect.vectorOr(((ConstructPointsToGraph)ConstructPointsToGraph.this).fBitAssignedTags[lNext].promote().fTagVect, this.fTagVect);
                            continue;
                        }
                        this.fTagVect.vectorOr(ConstructPointsToGraph.this.storageClassVect(((ConstructPointsToGraph)ConstructPointsToGraph.this).fBitAssignedTags[lNext].fStorageClass), this.fTagVect);
                    }
                    break;
                }
                case 64: {
                    this.visitChildren(pExp);
                    break;
                }
                case 65: {
                    this.visitChildren(pExp);
                    break;
                }
                case 66: {
                    this.visitChildren(pExp);
                    break;
                }
                case 67: {
                    TagVector lTagVect0;
                    new LocVisitor((Exp)pExp.getChild1()).process();
                    new LocVisitor((Exp)pExp.getChild2()).process();
                    ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pExp)).fTagVect = lTagVect0 = ConstructPointsToGraph.this.fRoot;
                    this.dereferenceIfNeeded(lTagVect0, pExp);
                    break;
                }
                default: {
                    this.visitChildren(pExp);
                    if (ConstructPointsToGraph.this.fIsOptimistic) break;
                    Scanner lScanner1 = this.fTagVect.toBriggsSet().scanner();
                    while (lScanner1.hasNext()) {
                        if (this.ioRoot.dbgAlias.getLevel() > 3) {
                            ConstructPointsToGraph.this.fAliasAnal.dbg(6, "fTagVect = ", this.fTagVect);
                        }
                        int lNext = lScanner1.next();
                        this.fTagVect.vectorOr(ConstructPointsToGraph.this.storageClassVect(((ConstructPointsToGraph)ConstructPointsToGraph.this).fBitAssignedTags[lNext].fStorageClass), this.fTagVect);
                    }
                    break block0;
                }
            }
        }

        public void atSubscriptedExp(SubscriptedExp pExp) {
            if (pExp.getArrayExp().getOperator() == 5) {
                new LocVisitor(pExp.getSubscriptExp()).process();
                return;
            }
            Tag lTag = (Tag)ConstructPointsToGraph.this.fHIRToTag.get(pExp);
            if (lTag != null && lTag.isAnchored()) {
                TagVector lTagVect = lTag.fTagVect;
                this.dereferenceIfNeeded(lTagVect, pExp);
                new LocVisitor(pExp.getSubscriptExp()).process();
            } else {
                this.visit(pExp.getArrayExp());
                new LocVisitor(pExp.getSubscriptExp()).process();
                if (lTag != null) {
                    TagVector lTagVect;
                    if (ConstructPointsToGraph.this.fIsOptimistic || pExp.getSubscriptExp().getOperator() == 5 && AliasUtil.subscriptCheck((VectorType)pExp.getArrayExp().getType(), ((ConstNode)pExp.getSubscriptExp()).getIntValue())) {
                        lTag.fTagVect = lTagVect = ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pExp.getArrayExp())).fTagVect;
                    } else {
                        lTagVect = ConstructPointsToGraph.this.fFactory.tagVector(ConstructPointsToGraph.this.fTagBitCount);
                        ConstructPointsToGraph.this.storageClassVect(lTag.fStorageClass).vectorCopy(lTagVect);
                        lTag.fTagVect = lTagVect;
                    }
                    this.dereferenceIfNeeded(lTagVect, pExp);
                }
            }
        }

        public void atQualifiedExp(QualifiedExp pExp) {
            Tag lTag = (Tag)ConstructPointsToGraph.this.fHIRToTag.get(pExp);
            if (lTag != null && lTag.isAnchored()) {
                TagVector lTagVect = lTag.fTagVect;
                this.dereferenceIfNeeded(lTagVect, pExp);
            } else {
                this.visit((Exp)pExp.getChild1());
                if (lTag != null) {
                    TagVector lTagVect;
                    lTag.fTagVect = lTagVect = ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pExp.getChild1())).fTagVect;
                    this.dereferenceIfNeeded(lTagVect, pExp);
                }
            }
        }

        public void atPointedExp(PointedExp pExp) {
            TagVector lTagVect;
            ((Tag)((ConstructPointsToGraph)ConstructPointsToGraph.this).fHIRToTag.get((Object)pExp)).fTagVect = lTagVect = new LocVisitor((Exp)pExp.getChild1()).process();
            this.dereferenceIfNeeded(lTagVect, pExp);
        }

        /*
         * Unable to fully structure code
         */
        public void atFunctionExp(FunctionExp pExp) {
            block17: {
                block16: {
                    lActuals = pExp.getActualParamList();
                    lIsmalloc = false;
                    lIsPredefined = false;
                    lAddressExternallyVisibles = ConstructPointsToGraph.access$300(ConstructPointsToGraph.this).tagVector(ConstructPointsToGraph.access$200(ConstructPointsToGraph.this));
                    if (!ConstructPointsToGraph.access$1000(ConstructPointsToGraph.this).containsKey(pExp)) break block16;
                    lIsmalloc = true;
                    break block17;
                }
                lFuncSpec = pExp.getSubpSpec();
                if (lFuncSpec.getOperator() != 64 || (lSubpNode = lFuncSpec.getExp1()).getOperator() != 9) ** GOTO lbl-1000
                ConstructPointsToGraph.access$1100(ConstructPointsToGraph.this);
                if (AliasUtil.isPredefined(((SubpNode)lSubpNode).getSubp(), ConstructPointsToGraph.access$500((ConstructPointsToGraph)ConstructPointsToGraph.this).fPredefined)) {
                    lIsPredefined = true;
                } else lbl-1000:
                // 2 sources

                {
                    new LocVisitor(pExp.getFunctionSpec()).process();
                }
            }
            lIt = lActuals.iterator();
            while (lIt.hasNext()) {
                lAddressExternallyVisibles.vectorOr(new LocVisitor((Exp)lIt.next()).process(), lAddressExternallyVisibles);
            }
            if (lIsmalloc) {
                this.fTagVect.vectorOr(((Tag)ConstructPointsToGraph.access$1000((ConstructPointsToGraph)ConstructPointsToGraph.this).get((Object)pExp)).fTagVect, this.fTagVect);
            } else if (!lIsPredefined) {
                if (ConstructPointsToGraph.access$600(ConstructPointsToGraph.this)) {
                    lAddressExternallyVisibles.vectorOr(ConstructPointsToGraph.access$1200(ConstructPointsToGraph.this), lAddressExternallyVisibles);
                } else {
                    lAddressExternallyVisibles.vectorOr(ConstructPointsToGraph.access$1300(ConstructPointsToGraph.this), lAddressExternallyVisibles);
                }
                lTemp = ConstructPointsToGraph.access$300(ConstructPointsToGraph.this).tagVector(ConstructPointsToGraph.access$200(ConstructPointsToGraph.this));
                if (ConstructPointsToGraph.this.fAddressExternallyVisibles == null) {
                    lIteration = 0;
                    do {
                        ++lIteration;
                        if (this.ioRoot.dbgAlias.getLevel() > 3) {
                            ConstructPointsToGraph.access$500(ConstructPointsToGraph.this).dbg(6, "AddressExternallyVisible", "iteration " + lIteration);
                        }
                        lAddressExternallyVisibles.vectorCopy(lTemp);
                        lScanner = lAddressExternallyVisibles.toBriggsSet().scanner();
                        while (lScanner.hasNext()) {
                            lNext = lScanner.next();
                            lAddressExternallyVisibles.vectorOr(ConstructPointsToGraph.access$1400(ConstructPointsToGraph.this)[lNext], lAddressExternallyVisibles);
                        }
                    } while (!lAddressExternallyVisibles.vectorEqual(lTemp));
                    if (!ConstructPointsToGraph.access$600(ConstructPointsToGraph.this) && !lAddressExternallyVisibles.vectorAnd(ConstructPointsToGraph.access$1500(ConstructPointsToGraph.this), ConstructPointsToGraph.access$300(ConstructPointsToGraph.this).tagVector(ConstructPointsToGraph.access$200(ConstructPointsToGraph.this))).isZero()) {
                        lAddressExternallyVisibles.vectorOr(ConstructPointsToGraph.access$1500(ConstructPointsToGraph.this), lAddressExternallyVisibles);
                    }
                    if (this.ioRoot.dbgAlias.getLevel() > 3) {
                        ConstructPointsToGraph.access$500(ConstructPointsToGraph.this).dbg(6, "lAddressExternallyVisibles", lAddressExternallyVisibles);
                    }
                    lScanner0 = lAddressExternallyVisibles.toBriggsSet().scanner();
                    while (lScanner0.hasNext()) {
                        lNext0 = lScanner0.next();
                        ConstructPointsToGraph.access$1400(ConstructPointsToGraph.this)[lNext0].vectorOr(lAddressExternallyVisibles, ConstructPointsToGraph.access$1400(ConstructPointsToGraph.this)[lNext0]);
                        if (this.ioRoot.dbgAlias.getLevel() <= 3) continue;
                        ConstructPointsToGraph.access$500(ConstructPointsToGraph.this).dbg(6, "fPointsTo(atFunctionExp)" + lNext0, Arrays.asList(ConstructPointsToGraph.access$1400(ConstructPointsToGraph.this)));
                    }
                    this.fTagVect.vectorOr(lAddressExternallyVisibles, this.fTagVect);
                    ConstructPointsToGraph.this.fAddressExternallyVisibles = lAddressExternallyVisibles;
                } else {
                    this.fTagVect.vectorOr(ConstructPointsToGraph.this.fAddressExternallyVisibles, this.fTagVect);
                }
            }
        }

        private void dereferenceIfNeeded(TagVector pTagVect, HIR pHIR) {
            if (this.ioRoot.dbgAlias.getLevel() > 3) {
                ConstructPointsToGraph.this.fAliasAnal.dbg(6, "HIR to be dereferenced", pHIR);
            }
            HIR lParent = (HIR)pHIR.getParent();
            int lParentOpCode = lParent.getOperator();
            switch (lParentOpCode) {
                case 17: 
                case 19: 
                case 64: 
                case 66: {
                    this.fTagVect.vectorOr(pTagVect, this.fTagVect);
                    break;
                }
                case 22: {
                    if (((AssignStmt)lParent).getLeftSide() == pHIR) {
                        this.fTagVect.vectorOr(pTagVect, this.fTagVect);
                        break;
                    }
                    this.fTagVect.vectorReset();
                    this.deref(pTagVect);
                    break;
                }
                case 20: 
                case 68: {
                    this.fTagVect.vectorReset();
                    this.deref(pTagVect);
                    break;
                }
                default: {
                    if (this.ioRoot.dbgAlias.getLevel() <= 3) break;
                    ConstructPointsToGraph.this.fAliasAnal.dbg(6, "default. parent", ((Object)lParent).toString());
                }
            }
        }

        private TagVector deref(TagVector pTagVect) {
            Scanner lScanner = pTagVect.toBriggsSet().scanner();
            while (lScanner.hasNext()) {
                int lnext = lScanner.next();
                if (this.ioRoot.dbgAlias.getLevel() > 3) {
                    ConstructPointsToGraph.this.fAliasAnal.dbg(6, "fPointsTo(deref)" + lnext, Arrays.asList(ConstructPointsToGraph.this.fPointsTo));
                }
                this.fTagVect.vectorOr(ConstructPointsToGraph.this.fPointsTo[lnext], this.fTagVect);
            }
            return this.fTagVect;
        }
    }

    private class AssignAndExpScanner
    extends HirVisitorModel2 {
        SubpDefinition fSubpDef;

        AssignAndExpScanner(SubpDefinition pSubpDef) {
            super(ConstructPointsToGraph.this.hirRoot);
            this.fSubpDef = pSubpDef;
        }

        public void atAssignStmt(AssignStmt pAssignStmt) {
            ConstructPointsToGraph.this.fAssigns.add(pAssignStmt);
        }

        public void atExp(Exp pExp) {
            ConstructPointsToGraph.this.fExps.add(pExp);
        }

        public void atVarNode(VarNode pVarNode) {
            ConstructPointsToGraph.this.fExps.add(pVarNode);
        }

        public void atSubscriptedExp(SubscriptedExp pExp) {
            ConstructPointsToGraph.this.fExps.add(pExp);
        }

        public void atQualifiedExp(QualifiedExp pExp) {
            ConstructPointsToGraph.this.fExps.add(pExp);
        }

        public void atPointedExp(PointedExp pExp) {
            ConstructPointsToGraph.this.fExps.add(pExp);
        }

        public void atFunctionExp(FunctionExp pExp) {
            ConstructPointsToGraph.this.fExps.add(pExp);
        }
    }
}

