/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow.util;

import coins.aflow.util.CoinsIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CoinsList
implements Cloneable,
List {
    protected transient Entry header = new Entry(null, null, null);
    protected transient int size = 0;
    protected List fIterators = new LinkedList();
    protected int modCount;

    public CoinsList() {
        this.header.next = this.header.previous = this.header;
    }

    public CoinsList(Collection c) {
        this();
        this.addAll(c);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object first = this.header.next.element;
        this.remove(this.header.next, 0);
        return first;
    }

    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous, this.size - 1);
        return last;
    }

    public void addFirst(Object o) {
        this.addBefore(o, this.header.next, 0);
    }

    public void addLast(Object o) {
        this.addBefore(o, this.header, this.size);
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(Object o) {
        this.addBefore(o, this.header, this.size);
        return true;
    }

    public boolean remove(Object o) {
        int i = 0;
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e, i);
                    return true;
                }
                e = e.next;
                ++i;
            }
        } else {
            i = 0;
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e, i);
                    return true;
                }
                e = e.next;
                ++i;
            }
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator lIt = c.iterator();
        while (lIt.hasNext()) {
            if (this.contains(lIt.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        ++this.modCount;
        Entry successor = index == this.size ? this.header : this.entry(index);
        Entry predecessor = successor.previous;
        Iterator it = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            Entry e;
            predecessor.next = e = new Entry(it.next(), successor, predecessor);
            predecessor = e;
            this.notifyIteratorsOfAddition(index++);
        }
        successor.previous = predecessor;
        this.size += numNew;
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
        this.notifyIteratorsOfClearance();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public Object get(int index) {
        return this.entry((int)index).element;
    }

    public Object set(int index, Object element) {
        Entry e = this.entry(index);
        Object oldVal = e.element;
        e.element = element;
        return oldVal;
    }

    public void add(int index, Object element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index), index);
    }

    public Object remove(int index) {
        Entry e = this.entry(index);
        this.remove(e, index);
        return e.element;
    }

    protected Entry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (e.element == null) {
                    return index;
                }
                e = e.previous;
            }
        } else {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (o.equals(e.element)) {
                    return index;
                }
                e = e.previous;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return this.coinsIterator();
    }

    public ListIterator listIterator() {
        return this.coinsIterator();
    }

    public ListIterator listIterator(int index) {
        return this.coinsIterator(index);
    }

    public CoinsIterator coinsIterator() {
        return this.coinsIterator(0);
    }

    public CoinsIterator coinsIterator(int pIndex) {
        return new Itr(pIndex);
    }

    protected void notifyIteratorsOfAddition(int pIndex) {
        for (Itr lItr : this.fIterators) {
            if (pIndex > lItr.nextIndex) continue;
            ++lItr.nextIndex;
        }
    }

    protected void notifyIteratorsOfClearance() {
        for (Itr lItr : this.fIterators) {
            lItr.next = this.header;
            lItr.lastReturned = this.header;
            lItr.nextIndex = 0;
        }
    }

    protected void notifyIteratorsOfRemoval(Entry e, int pIndex) {
        for (Itr lItr : this.fIterators) {
            if (lItr.next == e) {
                lItr.next = e.next;
            }
            if (e == lItr.lastReturned) {
                lItr.lastReturned = this.header;
            }
            if (pIndex >= lItr.nextIndex) continue;
            --lItr.nextIndex;
        }
    }

    protected Entry addBefore(Object o, Entry e, int pIndex) {
        Entry newEntry;
        newEntry.previous.next = newEntry = new Entry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        this.notifyIteratorsOfAddition(pIndex);
        return newEntry;
    }

    protected void remove(Entry e, int pIndex) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        ++this.modCount;
        this.notifyIteratorsOfRemoval(e, pIndex);
    }

    public Object clone() {
        CoinsList clone = null;
        try {
            clone = (CoinsList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.header.next = clone.header.previous = (clone.header = new Entry(null, null, null));
        clone.size = 0;
        clone.modCount = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            clone.add(e.element);
            e = e.next;
        }
        return clone;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            a[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(e.next()));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    class SubList
    extends CoinsList {
        private CoinsList l;
        private int offset;
        private int size;
        private int expectedModCount;

        SubList(CoinsList list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.l = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.expectedModCount = this.l.modCount;
        }

        public Object set(int index, Object element) {
            this.rangeCheck(index);
            this.checkForComodification();
            return this.l.set(index + this.offset, element);
        }

        public Object get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return this.l.get(index + this.offset);
        }

        public int size() {
            this.checkForComodification();
            return this.size;
        }

        public void add(int index, Object element) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            this.checkForComodification();
            this.l.add(index + this.offset, element);
            this.expectedModCount = this.l.modCount;
            ++this.size;
            ++this.modCount;
        }

        public Object remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            Object result = this.l.remove(index + this.offset);
            this.expectedModCount = this.l.modCount;
            --this.size;
            ++this.modCount;
            return result;
        }

        public boolean addAll(Collection c) {
            return this.addAll(this.size, c);
        }

        public boolean addAll(int index, Collection c) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.l.addAll(this.offset + index, c);
            this.expectedModCount = this.l.modCount;
            this.size += cSize;
            ++this.modCount;
            return true;
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(final int index) {
            this.checkForComodification();
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return new ListIterator(){
                private ListIterator i;
                {
                    this.i = SubList.this.l.listIterator(index + SubList.this.offset);
                }

                public boolean hasNext() {
                    return this.nextIndex() < SubList.this.size;
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this.i.next();
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                public Object previous() {
                    if (this.hasPrevious()) {
                        return this.i.previous();
                    }
                    throw new NoSuchElementException();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                public int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                public void remove() {
                    this.i.remove();
                    SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                    SubList.this.size--;
                    ++SubList.this.modCount;
                }

                public void set(Object o) {
                    this.i.set(o);
                }

                public void add(Object o) {
                    this.i.add(o);
                    SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                    SubList.this.size++;
                    ++SubList.this.modCount;
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new SubList(this, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        private void checkForComodification() {
            if (this.l.modCount != this.expectedModCount) {
                // empty if block
            }
        }
    }

    protected static class Entry {
        public Object element;
        public Entry next;
        public Entry previous;

        protected Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }

    protected class Itr
    implements CoinsIterator {
        protected Entry lastReturned;
        protected Entry next;
        protected int nextIndex;
        protected int expectedModCount;
        protected boolean lNexted;

        protected Itr(int index) {
            this.lastReturned = CoinsList.this.header;
            this.expectedModCount = CoinsList.this.modCount;
            if (index < 0 || index > CoinsList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + CoinsList.this.size);
            }
            if (index < CoinsList.this.size / 2) {
                this.next = CoinsList.this.header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = CoinsList.this.header;
                this.nextIndex = CoinsList.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
            CoinsList.this.fIterators.add(this);
        }

        public boolean hasNext() {
            return this.nextIndex != CoinsList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == CoinsList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            this.lNexted = true;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            this.lNexted = false;
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            CoinsList.this.remove(this.lastReturned, this.nextIndex - (this.lNexted ? 1 : 0));
            ++this.expectedModCount;
        }

        public Object lastReturned() {
            return this.lastReturned.element;
        }

        public void set(Object o) {
            if (this.lastReturned == CoinsList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = o;
        }

        public void add(Object o) {
            this.checkForComodification();
            this.lastReturned = CoinsList.this.header;
            CoinsList.this.addBefore(o, this.next, this.nextIndex);
            ++this.expectedModCount;
        }

        public void addAfter(Object o) {
            this.add(o);
            this.next = this.next.previous;
            --this.nextIndex;
        }

        protected final void checkForComodification() {
            if (CoinsList.this.modCount != this.expectedModCount) {
                // empty if block
            }
        }
    }
}

