/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.AssignFlowExpId;
import coins.aflow.BBlock;
import coins.aflow.BBlockHirImpl;
import coins.aflow.BBlockVector;
import coins.aflow.BBlockVectorImpl;
import coins.aflow.DefUseList;
import coins.aflow.DefVector;
import coins.aflow.DefVectorImpl;
import coins.aflow.DefVectorIterator;
import coins.aflow.DefVectorIteratorImpl;
import coins.aflow.ExpVector;
import coins.aflow.ExpVectorImpl;
import coins.aflow.ExpVectorIterator;
import coins.aflow.ExpVectorIteratorImpl;
import coins.aflow.Flow;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorImpl;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.MakeDominatorTreeForSubpFlow;
import coins.aflow.MakePostdominatorTreeForSubpFlow;
import coins.aflow.PointVector;
import coins.aflow.PointVectorImpl;
import coins.aflow.PointVectorIterator;
import coins.aflow.PointVectorIteratorImpl;
import coins.aflow.RecordSetRefReprs;
import coins.aflow.SetRefRepr;
import coins.aflow.SubpFlow;
import coins.aflow.UDList;
import coins.aflow.util.FAList;
import coins.aflow.util.FlowError;
import coins.alias.RecordAlias;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.VarNode;
import coins.sym.FlowAnalSym;
import coins.sym.Subp;
import coins.sym.SymIterator;
import coins.sym.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class SubpFlowImpl
implements SubpFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public final Flow flow;
    protected SubpDefinition fSubpDefinition;
    protected BBlock fPrevBBlockInSearch;
    protected BBlock fEntryBBlock;
    protected BBlock fExitBBlock;
    protected BBlock fCurrentBBlock;
    protected FAList fBBlockTable = new FAList(20);
    protected IrList fDfoList = null;
    protected IrList fInverseDfoList = null;
    protected List fReachableBBlocks;
    public final FlowResults fResults;
    public boolean fHirAnalExtended = false;
    public RecordSetRefReprs fRecordSetRefReprs;
    protected SetRefRepr[] fSetRefReprTable;
    protected BBlock[] fBBlockOfIR;
    protected int fIrIndexMin = 0;
    protected int fIrIndexMax = 0;
    protected FlowExpId[] fExpIdTable;
    protected boolean fRestructured = false;
    protected Set fSetOfGlobalVariables = null;
    protected Set fSetOfAddressTakenVariables = null;
    protected Map fTempExpCorrespondence;
    protected RecordAlias fRecordAlias = null;

    public SubpFlowImpl(SubpDefinition pSubpDef, FlowResults pResults) {
        this.fSubpDefinition = pSubpDef;
        this.fResults = pResults;
        this.flowRoot = this.fResults.flowRoot;
        this.flow = this.flowRoot.aflow;
        this.ioRoot = this.flowRoot.ioRoot;
        this.symRoot = this.flowRoot.symRoot;
        this.hirRoot = this.flowRoot.hirRoot;
        this.flowRoot.subpUnderAnalysis = this.fSubpDefinition.getSubpSym();
        this.symRoot.symTableCurrentSubp = this.symRoot.symTableCurrent = this.fSubpDefinition.getSymTable();
        this.fTempExpCorrespondence = new HashMap();
        this.flowRoot.aflow.dbg(1, "\nsubpFlowImpl", pSubpDef.getSubpSym().toString());
    }

    public BBlock getEntryBBlock() {
        return this.fEntryBBlock;
    }

    public void setEntryBBlock(BBlock pBlock) {
        this.fEntryBBlock = pBlock;
    }

    public BBlock getExitBBlock() {
        return this.fExitBBlock;
    }

    public void setExitBBlock(BBlock pBBlock) {
        this.fExitBBlock = pBBlock;
    }

    public BBlock bblock(LabeledStmt pLabeledStmt) {
        if (!this.flowRoot.isHirAnalysis()) {
            throw new FlowError("FlowRoot suggests LIR flow analysis is being performed now.");
        }
        BBlockHirImpl lBBlock = new BBlockHirImpl(pLabeledStmt, this);
        this.recordBBlock(lBBlock);
        return lBBlock;
    }

    public BBlockVector bblockVector() {
        BBlockVectorImpl lBBlockVector = new BBlockVectorImpl(this);
        return lBBlockVector;
    }

    public ExpVector expVector() {
        ExpVectorImpl lExpVector = new ExpVectorImpl(this);
        return lExpVector;
    }

    public PointVector pointVector() {
        PointVectorImpl lPointVector = new PointVectorImpl(this);
        return lPointVector;
    }

    public DefVector defVector() {
        DefVectorImpl lDefVector = new DefVectorImpl(this);
        return lDefVector;
    }

    public FlowAnalSymVector flowAnalSymVector() {
        return new FlowAnalSymVectorImpl(this);
    }

    public PointVectorIterator pointVectorIterator(PointVector pPointVector) {
        return new PointVectorIteratorImpl(pPointVector);
    }

    public DefVectorIterator defVectorIterator(DefVector pDefVector) {
        return new DefVectorIteratorImpl(pDefVector);
    }

    public ExpVectorIterator expVectorIterator(ExpVector pExpVector) {
        return new ExpVectorIteratorImpl(pExpVector);
    }

    public BBlock getBBlock(int pBlockNumber) {
        BBlock lBBlock = (BBlock)this.getBBlockTable().get(pBlockNumber);
        if (lBBlock != null) {
            return lBBlock;
        }
        return null;
    }

    public void recordBBlock(BBlock pBlock) {
        this.ioRoot.dbgFlow.print(4, "recordBBlock " + pBlock.getBBlockNumber());
        this.fBBlockTable.add(pBlock);
        if (pBlock.getLabel() != null) {
            this.ioRoot.dbgFlow.print(5, " " + pBlock.getLabel().getName());
        }
    }

    public int getNumberOfBBlocks() {
        return this.fBBlockTable.size();
    }

    public SubpDefinition getSubpDefinition() {
        return this.fSubpDefinition;
    }

    public Subp getSubpSym() {
        return this.fSubpDefinition.getSubpSym();
    }

    public Iterator cfgIterator() {
        this.ioRoot.msgRecovered.put(5011, "Incomplete flow information (cfgIterator)");
        return this.fDfoList.iterator();
    }

    public Iterator cfgFromExitIterator() {
        this.ioRoot.msgRecovered.put(5012, "Incomplete flow information (cfgFromExitIterator)");
        return this.fInverseDfoList.iterator();
    }

    public FAList getBBlockTable() {
        if (this.fBBlockTable.isEmpty()) {
            this.fResults.find("ControlFlowGraph", this);
        }
        return this.fBBlockTable;
    }

    public List getBBlocks() {
        return this.getReachableBBlocks();
    }

    public void setBBlocks(List pBBlocks) {
        this.fReachableBBlocks = pBBlocks;
    }

    public List getReachableBBlocks() {
        if (this.fReachableBBlocks == null) {
            this.ioRoot.msgRecovered.put(5555, "SubpFlowImpl: BBlocks not found. Has control flow graph been created?");
        }
        return this.fReachableBBlocks;
    }

    public void setReachableBBlocks(List pBBlocks) {
        this.flowRoot.aflow.dbg(2, "setReachableBBlocks", pBBlocks.toString());
        this.fReachableBBlocks = pBBlocks;
    }

    public List getBBlocksFromEntry() {
        return FlowUtil.bfSearch(this.getEntryBBlock(), this.getExitBBlock(), true);
    }

    public List getBBlocksFromExit() {
        return FlowUtil.bfSearch(this.getExitBBlock(), this.getEntryBBlock(), false);
    }

    public int getNumberOfRelevantBBlocks() {
        return this.getReachableBBlocks().size();
    }

    public FAList getFlowExpIdTable() {
        return (FAList)this.fResults.get("FlowExpIdTable", this);
    }

    public void setFlowExpIdTable(FAList pFlowExpIdTable) {
        this.ioRoot.dbgFlow.print(2, " setFlowExpIdTable", "to fResults");
        this.fResults.put("FlowExpIdTable", this, pFlowExpIdTable);
    }

    public FlowResults results() {
        return this.fResults;
    }

    public AssignFlowExpId assigner() {
        AssignFlowExpId lAssigner = (AssignFlowExpId)this.fResults.getRaw("AssignerForSubpFlow", this);
        if (lAssigner == null) {
            return this.flow.assigner(this);
        }
        return lAssigner;
    }

    public FAList getSetRefReprs() {
        this.flowRoot.aflow.dbg(5, "getSetRefReprs", this.getSubpSym().toString());
        return (FAList)this.fResults.get("SubpFlowSetReprs", this);
    }

    public void setSetRefReprs(FAList pSetReprs) {
        this.flowRoot.aflow.dbg(4, "setSetRefReprs", this.getSubpSym().toString());
        this.fResults.put("SubpFlowSetReprs", this, pSetReprs);
    }

    public Iterator cfgBfoIterator() {
        return FlowUtil.bfSearch(this.getEntryBBlock(), this.getExitBBlock(), true).iterator();
    }

    public DefUseList getDefUseList(FlowAnalSym pFlowAnalSym) {
        return (DefUseList)this.fResults.get("DefUseList", pFlowAnalSym, this);
    }

    public void setDefUseList(FlowAnalSym pFlowAnalSym, DefUseList pDefUseList) {
        this.fResults.put("DefUseList", pFlowAnalSym, this, pDefUseList);
    }

    public UDList getUDList(FlowAnalSym pFlowAnalSym) {
        return (UDList)this.fResults.get("UDList", pFlowAnalSym, this);
    }

    public void setUDList(FlowAnalSym pFlowAnalSym, UDList pUDList) {
        this.fResults.put("UDList", pFlowAnalSym, this, pUDList);
    }

    public FAList getSymIndexTable() {
        return (FAList)this.fResults.get("SymIndexTable", this);
    }

    public void setSymIndexTable(FAList pSymIndexTable) {
        this.fResults.put("SymIndexTable", this, pSymIndexTable);
    }

    public void makeDominatorTree() {
        new MakeDominatorTreeForSubpFlow(this).makeDominatorTree();
    }

    public void makePostdominatorTree() {
        new MakePostdominatorTreeForSubpFlow(this).makePostdominatorTree();
    }

    public void initiateDataFlow() {
        this.ioRoot.dbgFlow.print(1, "initiateDataFlow", this.fSubpDefinition.getSubpSym().getName());
        this.fResults.find("Initiate", this);
    }

    public void findPDef() {
        this.fResults.find("PDef", this);
    }

    public void findDDefined() {
        this.fResults.find("DDefined", this);
    }

    public void findPDefined() {
        this.fResults.find("PDefined", this);
    }

    public void findDKill() {
        this.fResults.find("DKill", this);
    }

    public void findPKill() {
        this.fResults.find("PKill", this);
    }

    public void findDExposedUsed() {
        this.fResults.find("DExposed", this);
    }

    public void findPExposedUsed() {
        this.fResults.find("PExposed", this);
    }

    public void findDEGen() {
        this.fResults.find("DEGen", this);
    }

    public void findPEKill() {
        this.fResults.find("PEKill", this);
    }

    public void findDReach() {
        this.fResults.find("DReach", this);
    }

    public void findPReach() {
        this.fResults.find("PReach", this);
    }

    public void findDAvailInAvailOut() {
        this.fResults.find("DAvailIn", this);
    }

    public void findPLiveInLiveOut() {
        this.fResults.find("PLiveIn", this);
    }

    public void findDDefInDefOut() {
        this.fResults.find("DDefIn", this);
    }

    public void findDDefUse() {
        this.fResults.find("DDefUseList", this);
    }

    public void findDUseDef() {
        this.fResults.find("DUDList", this);
    }

    public void findDefUse() {
        this.fResults.find("DefUseList", this);
    }

    public void findUseDef() {
        this.fResults.find("UDList", this);
    }

    public void allocateSetRefReprTable() {
        this.flowRoot.aflow.dbg(2, "allocateSetRefReprTable", "size " + this.fIrIndexMax + "-" + this.fIrIndexMin + "-1");
        this.fSetRefReprTable = new SetRefRepr[this.fIrIndexMax - this.fIrIndexMin + 1];
    }

    public SetRefRepr getSetRefReprOfIR(int pIndex) {
        if (this.fSetRefReprTable == null) {
            this.allocateSetRefReprTable();
        }
        return this.fSetRefReprTable[pIndex - this.fIrIndexMin];
    }

    public void setSetRefReprOfIR(SetRefRepr pSetRefRepr, int pIndex) {
        if (this.fSetRefReprTable == null) {
            this.allocateSetRefReprTable();
        }
        this.fSetRefReprTable[pIndex - this.fIrIndexMin] = pSetRefRepr;
    }

    public void correlateBBlockAndIR() {
    }

    public void allocateBBlockOfIR() {
        this.flowRoot.aflow.dbg(2, "allocateBBlockOfIR", "size " + this.fIrIndexMax + "-" + this.fIrIndexMin + "-1");
        this.fBBlockOfIR = new BBlock[this.fIrIndexMax - this.fIrIndexMin + 1];
    }

    public BBlock getBBlockOfIR(int pIndex) {
        if (this.fBBlockOfIR == null) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "getBBlockOfIR requires allocateBBlockOfIR. index " + pIndex);
            this.allocateBBlockOfIR();
        }
        if (pIndex < this.fIrIndexMin) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "setBBlockOfIR with invalid index " + pIndex + " fIndexMin " + this.fIrIndexMin);
        }
        return this.fBBlockOfIR[pIndex - this.fIrIndexMin];
    }

    public void setBBlockOfIR(BBlock pBBlock, int pIndex) {
        if (this.fBBlockOfIR == null) {
            this.allocateBBlockOfIR();
        }
        if (pIndex < this.fIrIndexMin) {
            this.flowRoot.ioRoot.msgRecovered.put(5555, "setBBlockOfIR with invalid index " + pIndex + " fIndexMin " + this.fIrIndexMin);
        } else {
            this.fBBlockOfIR[pIndex - this.fIrIndexMin] = pBBlock;
        }
    }

    public int getIrIndexMin() {
        return this.fIrIndexMin;
    }

    public int getIrIndexMax() {
        return this.fIrIndexMax;
    }

    public void allocateExpIdTable() {
        this.fExpIdTable = new FlowExpId[this.fIrIndexMax - this.fIrIndexMin + 1];
    }

    public FlowExpId getExpId(IR pIr) {
        if (pIr != null && this.fExpIdTable != null && pIr.getIndex() >= this.fIrIndexMin && pIr.getIndex() <= this.fIrIndexMax && !this.getRestructureFlag()) {
            return this.fExpIdTable[pIr.getIndex() - this.fIrIndexMin];
        }
        return null;
    }

    public FlowExpId getExpId(IR pIr, int pIndex) {
        if (pIr != null) {
            return this.fExpIdTable[pIndex - this.fIrIndexMin];
        }
        return null;
    }

    public void setExpId(IR pIr, FlowExpId pFlowExpId) {
        if (pIr != null && this.fExpIdTable != null && pIr.getIndex() >= this.fIrIndexMin) {
            this.fExpIdTable[pIr.getIndex() - this.fIrIndexMin] = pFlowExpId;
        }
    }

    public void printExpIdTable() {
        FAList lFlowExpIdTable;
        System.out.print("\nExpIdTable for " + this.getSubpSym());
        if (this.fResults != null && (lFlowExpIdTable = this.getFlowExpIdTable()) != null) {
            for (FlowExpId lExpId : lFlowExpIdTable) {
                if (lExpId == null) continue;
                IR lTree = lExpId.getLinkedNode();
                System.out.print("\n " + lExpId.toStringShort() + " ");
                if (lTree instanceof HIR) {
                    System.out.print(FlowUtil.toString((HIR)lTree));
                    continue;
                }
                System.out.print(" " + lTree.toString());
            }
        }
    }

    public Set setOfGlobalVariables() {
        return this.fSetOfGlobalVariables;
    }

    public Set setOfAddressTakenVariables() {
        return this.fSetOfAddressTakenVariables;
    }

    public void clear() {
        this.fSetRefReprTable = null;
        this.fIrIndexMin = this.fSubpDefinition.getNodeIndexMin();
        this.fIrIndexMax = this.fSubpDefinition.getNodeIndexMax();
        this.fExpIdTable = new FlowExpId[this.fIrIndexMax - this.fIrIndexMin + 1];
        this.fBBlockTable = new FAList(20);
        this.fBBlockOfIR = new BBlock[this.fIrIndexMax - this.fIrIndexMin + 1];
        this.fSetOfAddressTakenVariables = null;
        this.fSetOfGlobalVariables = null;
        this.fRecordAlias = null;
        this.flowRoot.ioRoot.dbgOpt1.print(2, "\n subpFlow.clear() IrIndex " + this.fIrIndexMin + " - " + this.fIrIndexMax);
    }

    public Set computeSetOfGlobalVariables() {
        if (this.fSetOfGlobalVariables == null) {
            HashSet<Var> lGlobalVariables = new HashSet<Var>();
            SymIterator lIterator = this.flowRoot.symRoot.symTableRoot.getSymIterator();
            while (lIterator.hasNext()) {
                Var lSym = lIterator.nextVar();
                if (lSym == null) continue;
                lGlobalVariables.add(lSym);
            }
            this.fSetOfGlobalVariables = lGlobalVariables;
            this.flowRoot.aflow.dbg(2, "\nglobalVariables ", ((Object)lGlobalVariables).toString());
            return lGlobalVariables;
        }
        this.flowRoot.aflow.dbg(2, "\nglobalVariables ", this.fSetOfGlobalVariables.toString());
        return this.fSetOfGlobalVariables;
    }

    public Set computeSetOfAddressTakenVariables() {
        HashSet lAddressTakenVariables = new HashSet();
        if (this.flowRoot.isHirAnalysis()) {
            Stmt lSubpBody = this.fSubpDefinition.getHirBody();
            this.computeSetOfAddressTakenVariables(lSubpBody, lAddressTakenVariables, false);
        }
        this.fSetOfAddressTakenVariables = lAddressTakenVariables;
        this.flowRoot.aflow.dbg(2, "\naddressTakenVariables ", ((Object)lAddressTakenVariables).toString());
        return lAddressTakenVariables;
    }

    public void computeSetOfAddressTakenVariables(HIR pHir, Set pSet, boolean pAddrOperand) {
        if (pHir != null) {
            if (pHir instanceof VarNode) {
                FlowAnalSym lSym = pHir.getSymOrExpId();
                if (pAddrOperand && lSym instanceof Var) {
                    pSet.add(lSym);
                }
            } else {
                switch (pHir.getOperator()) {
                    case 64: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, true);
                        break;
                    }
                    case 17: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, pAddrOperand);
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, false);
                        break;
                    }
                    case 20: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, false);
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, pAddrOperand);
                        break;
                    }
                    case 68: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, true);
                        break;
                    }
                    case 38: 
                    case 39: {
                        if (pHir.getType().getTypeKind() == 22) {
                            this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, true);
                        } else {
                            this.computeSetOfAddressTakenVariables((HIR)pHir.getChild1(), pSet, false);
                        }
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, false);
                        break;
                    }
                    case 21: {
                        this.computeSetOfAddressTakenVariables((HIR)pHir.getChild2(), pSet, false);
                        break;
                    }
                    case 35: {
                        for (Stmt lStmt = ((BlockStmt)pHir).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            this.computeSetOfAddressTakenVariables(lStmt, pSet, false);
                        }
                        break;
                    }
                    case 14: {
                        ListIterator lIterator = ((HirList)pHir).iterator();
                        while (lIterator.hasNext()) {
                            HIR lHir = (HIR)lIterator.next();
                            if (lHir == null) continue;
                            this.computeSetOfAddressTakenVariables(lHir, pSet, false);
                        }
                        break;
                    }
                    default: {
                        if (pHir.getChildCount() <= 0) break;
                        for (int i = 1; i <= pHir.getChildCount(); ++i) {
                            this.computeSetOfAddressTakenVariables((HIR)pHir.getChild(i), pSet, false);
                        }
                    }
                }
            }
        }
    }

    public void setRestructureFlag() {
        this.fRestructured = true;
    }

    public boolean getRestructureFlag() {
        return this.fRestructured;
    }

    public void setRecordAlias(RecordAlias pRecordAlias) {
        this.fRecordAlias = pRecordAlias;
        this.ioRoot.dbgFlow.print(4, " setRecordAlias", this.fSubpDefinition.getSubpSym().getName());
    }

    public RecordAlias getRecordAlias() {
        return this.fRecordAlias;
    }

    public void setExpOfTemp(Var pTempVar, Exp pExp) {
        this.fTempExpCorrespondence.put(pTempVar, pExp);
    }

    public Exp getExpOfTemp(Var pTempVar) {
        if (this.fTempExpCorrespondence.containsKey(pTempVar)) {
            return (Exp)this.fTempExpCorrespondence.get(pTempVar);
        }
        return null;
    }
}

