/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.IoRoot;
import coins.aflow.BBlock;
import coins.aflow.BBlockHir;
import coins.aflow.Flow;
import coins.aflow.FlowResults;
import coins.aflow.MakeControlFlowGraph;
import coins.aflow.SubpFlow;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.sym.Label;
import java.util.ListIterator;

public class MakeControlFlowGraphHir
extends MakeControlFlowGraph {
    public final Flow flow;
    Stmt lGlobalNextStmt;

    public MakeControlFlowGraphHir(FlowResults pResults) {
        super(pResults);
        this.flow = this.flowRoot.aflow;
    }

    public void find(Label pLabel, SubpFlow pSubpFlow) {
        this.find(pSubpFlow);
    }

    void makeControlFlowGraph(SubpDefinition pSubpDef, SubpFlow pSubpFlow) {
        Stmt lHirBody = pSubpDef.getHirBody();
        this.generateBBlocks(lHirBody, pSubpFlow);
        this.flowRoot.ioRoot.dbgFlow.print(2, "makeControlFlowGraph", "of HIR");
        BBlock firstBBlock = null;
        BBlock lastBBlock = null;
        lastBBlock = this.makeEdge(lHirBody, firstBBlock);
        firstBBlock = this.findEntryBlock();
        this.deleteEdge(firstBBlock);
        this.recordReachableBBlocks();
        this.findExitBlock();
        pSubpFlow.correlateBBlockAndIR();
    }

    private BBlock makeEdge(Stmt pstmt, BBlock pblock) {
        BBlock LabelBlock = null;
        Stmt nextStmt = pstmt;
        BBlock currBlock = pblock;
        this.lGlobalNextStmt = nextStmt;
        this.flow.dbg(5, "\nmakeEdge", "to stmt= " + pstmt + " from B" + pblock);
        block9: while (nextStmt != null) {
            int lop = nextStmt.getOperator();
            this.flow.dbg(5, "\nMakeEdge", "nextStmt = " + nextStmt + " nextToNext " + IoRoot.toStringObject(nextStmt.getNextStmt()) + " lGlobalNextStmt " + this.lGlobalNextStmt);
            switch (lop) {
                case 23: {
                    IfStmt stmtIF = (IfStmt)nextStmt;
                    BBlock thenBlock = this.makeEdge(stmtIF.getThenPart(), currBlock);
                    BBlock elseBlock = this.makeEdge(stmtIF.getElsePart(), currBlock);
                    LabelBlock = this.fResults.getBBlockForLabel(stmtIF.getEndLabel());
                    this.addEdge(thenBlock, LabelBlock);
                    this.addEdge(elseBlock, LabelBlock);
                    LabeledStmt lIfEnd = (LabeledStmt)stmtIF.getChild(4);
                    this.flow.dbg(6, " ", "if-end " + lIfEnd.toStringShort());
                    currBlock = lIfEnd.getStmt() != null ? this.makeEdge(lIfEnd.getStmt(), LabelBlock) : LabelBlock;
                    nextStmt = this.getNextStmtSeeingAncestor(stmtIF);
                    this.flow.dbg(6, " next-of-if " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 21: {
                    LabelBlock = this.fResults.getBBlockForLabel(((LabeledStmt)nextStmt).getLabel());
                    this.addEdge(currBlock, LabelBlock);
                    currBlock = LabelBlock;
                    Stmt nextStmt1 = ((LabeledStmt)nextStmt).getStmt();
                    if (nextStmt1 == null) {
                        nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                        this.flow.dbg(6, " next-of-labeledSt " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    } else {
                        nextStmt = nextStmt1;
                    }
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 32: {
                    SwitchStmt stmtSWITCH = (SwitchStmt)nextStmt;
                    int CaseCount = stmtSWITCH.getCaseCount();
                    for (int i = 0; i < CaseCount; ++i) {
                        LabelBlock = this.fResults.getBBlockForLabel(stmtSWITCH.getCaseLabel(i));
                        this.addEdge(currBlock, LabelBlock);
                    }
                    BBlock defaultBlock = this.fResults.getBBlockForLabel(stmtSWITCH.getDefaultLabel());
                    BBlock endBlock = this.fResults.getBBlockForLabel(stmtSWITCH.getEndLabel());
                    if (defaultBlock == null) {
                        this.addEdge(currBlock, endBlock);
                    } else {
                        this.addEdge(currBlock, defaultBlock);
                    }
                    BBlock bodyBlock = this.makeEdge(stmtSWITCH.getBodyStmt(), currBlock);
                    this.addEdge(bodyBlock, endBlock);
                    LabeledStmt lSwitchEnd = (LabeledStmt)stmtSWITCH.getChild(4);
                    this.flow.dbg(6, " ", "switch-end " + lSwitchEnd.toStringShort());
                    currBlock = lSwitchEnd.getStmt() != null ? this.makeEdge(lSwitchEnd.getStmt(), endBlock) : endBlock;
                    nextStmt = this.getNextStmtSeeingAncestor(stmtSWITCH);
                    this.flow.dbg(6, " next-of-switch " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    LoopStmt stmtLOOP = (LoopStmt)nextStmt;
                    Label l = stmtLOOP.getLoopBackLabel();
                    BBlock loopbackBlock = this.fResults.getBBlockForLabel(l);
                    BBlock lLoopStepBlock = this.fResults.getBBlockForLabel(stmtLOOP.getLoopStepLabel());
                    BBlock endBlock = this.fResults.getBBlockForLabel(stmtLOOP.getLoopEndLabel());
                    this.flow.dbg(6, "Loop", "backBlock " + loopbackBlock + " stepLabel " + stmtLOOP.getLoopStepLabel() + " stepBlock " + lLoopStepBlock + " endBlock " + endBlock);
                    Stmt loopInitPart = stmtLOOP.getLoopInitPart();
                    this.flow.dbg(6, " make-edge to loop-init part from " + currBlock);
                    BBlock loopInitBlock = this.makeEdge(loopInitPart, currBlock);
                    this.flow.dbg(6, " add-edge to loop-back block from " + currBlock + " initBlock " + loopInitBlock);
                    this.addEdge(currBlock, loopbackBlock);
                    this.flow.dbg(6, " make-edge to loop-body part from loop-back block " + loopbackBlock);
                    BBlock bodyBlock = this.makeEdge(stmtLOOP.getLoopBodyPart(), loopbackBlock);
                    l = stmtLOOP.getLoopStepLabel();
                    if (l != null) {
                        BBlock stepBlock = this.fResults.getBBlockForLabel(l);
                        if (stepBlock != null) {
                            if (bodyBlock != stepBlock) {
                                this.flow.dbg(5, " add edge", "from loop-body part " + bodyBlock + " to stepBlock " + stepBlock);
                                this.addEdge(bodyBlock, stepBlock);
                            }
                            this.flow.dbg(5, " add edge", "from loop-step block " + stepBlock + " to loop-back block " + loopbackBlock);
                            this.addEdge(stepBlock, loopbackBlock);
                            stepBlock.getSuccEdge(loopbackBlock).flagBox().setFlag(11, true);
                            this.flow.dbg(5, " make-edge to loop-step part from stepBlock " + stepBlock);
                            BBlock lStepBlock2 = this.makeEdge(stmtLOOP.getLoopStepPart(), stepBlock);
                        } else {
                            this.flow.dbg(4, " stepBlock of " + stmtLOOP + " is null");
                            if (bodyBlock != null) {
                                this.flow.dbg(5, " add edge from bodyBlock " + bodyBlock + " to loop-back block " + loopbackBlock);
                                this.addEdge(bodyBlock, loopbackBlock);
                                bodyBlock.getSuccEdge(loopbackBlock).flagBox().setFlag(11, true);
                            }
                        }
                        if (stmtLOOP.getLoopEndCondition() == (Exp)null) {
                            this.addEdge(loopbackBlock, endBlock);
                        } else if (stepBlock != null) {
                            this.addEdge(stepBlock, endBlock);
                        } else {
                            this.addEdge(bodyBlock, endBlock);
                        }
                    } else {
                        this.addEdge(bodyBlock, loopbackBlock);
                        this.addEdge(loopbackBlock, endBlock);
                    }
                    LabeledStmt lLoopEnd = (LabeledStmt)stmtLOOP.getChild(7);
                    this.flow.dbg(6, " ", "loop-end " + lLoopEnd.toStringShort());
                    currBlock = lLoopEnd.getStmt() != null ? this.makeEdge(lLoopEnd.getStmt(), endBlock) : endBlock;
                    this.flow.dbg(5, " get next statement", "of loop " + stmtLOOP.toStringShort());
                    nextStmt = this.getNextStmtSeeingAncestor(stmtLOOP);
                    this.flow.dbg(6, " next-of-loop " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 34: {
                    currBlock = null;
                    nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                    this.flow.dbg(6, " next-of-return " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 28: {
                    Label l = ((JumpStmt)nextStmt).getLabel();
                    LabelBlock = this.fResults.getBBlockForLabel(l);
                    this.addEdge(currBlock, LabelBlock);
                    currBlock = null;
                    nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
                    this.flow.dbg(6, " next-of-jump " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
                case 35: {
                    currBlock = this.makeEdge(((BlockStmt)nextStmt).getFirstStmt(), currBlock);
                    nextStmt = this.getNextStmtSeeingAncestor(this.lGlobalNextStmt);
                    this.flow.dbg(6, " next-of-block " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
                    this.lGlobalNextStmt = nextStmt;
                    continue block9;
                }
            }
            nextStmt = this.getNextStmtSeeingAncestor(nextStmt);
            this.flow.dbg(6, " next-of-default " + nextStmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
            this.lGlobalNextStmt = nextStmt;
        }
        this.flow.dbg(5, " return " + currBlock + " for " + pstmt + " lGlobalNextStmt " + this.lGlobalNextStmt);
        return currBlock;
    }

    private Stmt getNextStmtSeeingAncestor(Stmt pStmt) {
        this.flow.dbg(5, " getNextStmtSeeingAncestor " + pStmt);
        if (pStmt == null) {
            return null;
        }
        if (pStmt.getNextStmt() != null) {
            return pStmt.getNextStmt();
        }
        HIR lAncestor = pStmt;
        do {
            if ((lAncestor = (HIR)lAncestor.getParent()) == null) {
                return null;
            }
            this.flow.dbg(5, " ancestor " + lAncestor.toStringShort());
            if (lAncestor instanceof IfStmt || lAncestor instanceof LoopStmt || lAncestor instanceof SwitchStmt) {
                this.flow.dbg(5, " Parent is If/Loop/Switch. return null. ");
                return null;
            }
            if (lAncestor instanceof BlockStmt) {
                this.flow.dbg(5, "\n End of BlockStmt. Get nextstmt of " + lAncestor.toStringShort());
                Stmt lNextStmt = this.getNextStmtSeeingAncestor((Stmt)lAncestor);
                this.flow.dbg(6, " next-of-BlockStmt in getNextStmt " + lNextStmt);
                return lNextStmt;
            }
            if (lAncestor.getNextStmt() == null) continue;
            return lAncestor.getNextStmt();
        } while (lAncestor != null);
        return null;
    }

    private void generateBBlocks(Stmt pHirBody, SubpFlow pSubpFlow) {
        this.flow.dbg(2, "generateBBlocks", pSubpFlow.getSubpSym().getName());
        HirIterator lHirIterator = this.flowRoot.hirRoot.hir.hirIterator(pHirBody);
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            this.flow.dbg(5, "generateBBlocks", "lNode = " + lNode);
            if (!(lNode instanceof LabeledStmt)) continue;
            BBlockHir lBBlock = (BBlockHir)pSubpFlow.bblock((LabeledStmt)lNode);
            IrList lLabelDefList = ((LabeledStmt)lNode).getLabelDefList();
            ListIterator lIterator = lLabelDefList.iterator();
            while (lIterator.hasNext()) {
                Label lLabel = ((LabelDef)lIterator.next()).getLabel();
                this.fResults.put("BBlockForLabel", lLabel, lBBlock);
                this.flow.dbg(5, "generateBBlocks", "Label: " + lLabel + ", BBlock: " + lBBlock);
            }
        }
    }
}

