/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.aflow.BBlock;
import coins.aflow.BBlockVector;
import coins.aflow.BBlockVectorImpl;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.ir.hir.SubpDefinition;
import coins.sym.Label;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class MakeControlFlowGraph {
    SubpFlow fSubpFlow;
    protected FlowResults fResults;
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;

    MakeControlFlowGraph(FlowResults pResults) {
        this.fResults = pResults;
        this.flowRoot = this.fResults.flowRoot;
        this.ioRoot = this.flowRoot.ioRoot;
    }

    public void find(SubpFlow pSubpFlow) {
        if (!pSubpFlow.results().fCFGInfo.isEmpty()) {
            this.ioRoot.msgRecovered.put(5555, "MakeControlFlowGraph: CFG info already exists. Call FlowResults#clearAll before begining a new analysis.");
        }
        this.fSubpFlow = pSubpFlow;
        this.makeControlFlowGraph(pSubpFlow.getSubpDefinition(), pSubpFlow);
    }

    abstract void makeControlFlowGraph(SubpDefinition var1, SubpFlow var2);

    BBlock findEntryBlock() {
        Label lStartLabel = this.fSubpFlow.getSubpSym().getStartLabel();
        BBlock lEntryBBlock = this.fResults.getBBlockForLabel(lStartLabel);
        this.fSubpFlow.setEntryBBlock(lEntryBBlock);
        return lEntryBBlock;
    }

    BBlock findExitBlock() {
        BBlock lExitBBlock = null;
        for (BBlock b : this.fSubpFlow.getReachableBBlocks()) {
            List l = b.getSuccList();
            if (l.size() != 0) continue;
            lExitBBlock = b;
        }
        this.fSubpFlow.setExitBBlock(lExitBBlock);
        return lExitBBlock;
    }

    void addEdge(BBlock ppred, BBlock psucc) {
        this.ioRoot.dbgFlow.print(6, "addEdge ");
        if (psucc == null) {
            return;
        }
        if (ppred == null) {
            return;
        }
        this.ioRoot.dbgFlow.print(6, "from " + ppred.getBBlockNumber() + " to " + psucc.getBBlockNumber());
        psucc.addToPredList(ppred);
        ppred.addToSuccList(psucc);
    }

    void deleteEdge(BBlock pBBlock) {
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        BBlockVectorImpl mark = new BBlockVectorImpl(this.fSubpFlow);
        this.markRootDom(pBBlock, mark);
        LinkedList delList = new LinkedList();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            if (mark.getBit(this.domBitLookUp(i)) != 0) continue;
            BBlock Curr = this.fSubpFlow.getBBlock(i);
            List l = Curr.getSuccList();
            MakeControlFlowGraph.ListCopy(l, delList);
            ListIterator Ie = delList.listIterator();
            while (Ie.hasNext()) {
                BBlock Succ = (BBlock)Ie.next();
                Succ.deleteFromPredList(Curr);
                Curr.deleteFromSuccList(Succ);
            }
            l = Curr.getPredList();
            MakeControlFlowGraph.ListCopy(l, delList);
            Ie = delList.listIterator();
            while (Ie.hasNext()) {
                BBlock Pred = (BBlock)Ie.next();
                Pred.deleteFromPredList(Curr);
                Curr.deleteFromPredList(Pred);
            }
        }
    }

    void recordReachableBBlocks() {
        int lBBlockCount = this.fSubpFlow.getNumberOfBBlocks();
        ArrayList<BBlock> lBBlockList = new ArrayList<BBlock>();
        this.flowRoot.aflow.dbg(1, "recordReachableBBlocks", "BBlockCount " + lBBlockCount);
        for (int i = 1; i <= lBBlockCount; ++i) {
            BBlock lBBlock = this.fSubpFlow.getBBlock(i);
            if (lBBlock.getPredList().isEmpty() && !lBBlock.isEntryBBlock()) continue;
            lBBlockList.add(lBBlock);
        }
        this.fSubpFlow.setReachableBBlocks(lBBlockList);
    }

    private void markRootDom(BBlock pBBlock, BBlockVector pmark) {
        List l = pBBlock.getSuccList();
        pmark.setBit(this.domLookUp(pBBlock.getBBlockNumber()));
        ListIterator Ie = l.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            if (pmark.getBit(this.domBitLookUp(b.getBBlockNumber())) != 0) continue;
            this.markRootDom(b, pmark);
        }
    }

    private int domLookUp(int ppNo) {
        int lBitPosition = ppNo;
        return lBitPosition;
    }

    public int domBitLookUp(int pBitPos) {
        int lBlockNo = pBitPos;
        return lBlockNo;
    }

    private static void ListCopy(List from, List to) {
        to.clear();
        ListIterator Ie = from.listIterator();
        while (Ie.hasNext()) {
            to.add(Ie.next());
        }
    }

    void unifyBBlocks() {
        HashSet<BBlock> lDeletedBBlocks = new HashSet<BBlock>();
        for (BBlock lBBlock : this.fSubpFlow.getBBlockTable()) {
            BBlock lSuccBBlock;
            List lSuccList;
            if (lDeletedBBlocks.contains(lBBlock)) continue;
            while ((lSuccList = lBBlock.getSuccList()).size() == 1 && (lSuccBBlock = (BBlock)lSuccList.get(0)).getPredList().size() == 1) {
                lBBlock.fuseSuccessor(lSuccBBlock);
                lDeletedBBlocks.add(lSuccBBlock);
            }
        }
    }
}

