/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.AssignHashBasedFlowExpId;
import coins.aflow.BBlock;
import coins.aflow.DNodeIterator;
import coins.aflow.Flow;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.NodeIterator;
import coins.aflow.NodeListIterator;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprHir;
import coins.aflow.SetRefReprIterator;
import coins.aflow.SubpFlow;
import coins.aflow.util.FAList;
import coins.aflow.util.FlowError;
import coins.aflow.util.UnimplementedMethodException;
import coins.ir.IR;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubscriptedExp;
import coins.sym.FlowAnalSym;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class FlowUtil {
    public static IR getChild1(IR pIR) {
        if (pIR instanceof HIR) {
            return pIR.getChild1();
        }
        throw new FlowError();
    }

    public static IR getChild2(IR pIR) {
        if (pIR instanceof HIR) {
            return pIR.getChild2();
        }
        throw new FlowError();
    }

    public static FlowAnalSym flowAnalSym(IR pIR) {
        if (pIR instanceof HIR) {
            Sym lSym = pIR.getSym();
            if (lSym instanceof FlowAnalSym) {
                return (FlowAnalSym)lSym;
            }
        } else {
            throw new FlowError();
        }
        return null;
    }

    public static FlowAnalSym derefedFlowAnalSym(IR pIR) {
        Sym lSym;
        if (pIR instanceof HIR && (lSym = pIR.getSym()) instanceof FlowAnalSym && ((HIR)pIR.getParent()).getOperator() != 64) {
            return (FlowAnalSym)lSym;
        }
        return null;
    }

    public static int getChildCount(IR pIR) {
        int lChildCount = 0;
        if (!(pIR instanceof HIR)) {
            throw new FlowError();
        }
        lChildCount = ((HIR)pIR).getChildCount();
        return lChildCount;
    }

    public static boolean isConstNode(IR pIR) {
        return pIR instanceof ConstNode;
    }

    public static boolean isSameTree(IR pIR, IR pIR0) {
        if (pIR instanceof HIR) {
            return FlowUtil.isSameTree((HIR)pIR, (HIR)pIR0);
        }
        throw new FlowError();
    }

    public static boolean isSameTree(IR pIR, IR pIR0, FlowResults pResults) {
        try {
            return pResults.getFlowExpIdForNode(pIR) == pResults.getFlowExpIdForNode(pIR0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean hasPointerAssign(SubpFlow pSubpFlow) {
        Iterator lIt = pSubpFlow.getBBlocks().iterator();
        while (lIt.hasNext()) {
            if (!FlowUtil.hasPointerAssign((BBlock)lIt.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPointerAssign(BBlock pBBlock) {
        Set lSetReprModSyms = new HashSet();
        SetRefReprIterator lIt = pBBlock.getSetRefReprs().setRefReprIterator();
        while (lIt.hasNext()) {
            SetRefRepr lSetRefRepr = (SetRefRepr)lIt.next();
            if (!lSetRefRepr.sets() || lSetRefRepr.defSym() != null) continue;
            lSetReprModSyms = lSetRefRepr.modSyms();
            Iterator lModSymIt = lSetReprModSyms.iterator();
            while (lModSymIt.hasNext()) {
                if (((FlowAnalSym)lModSymIt.next()).getSymType().getTypeKind() != 22) continue;
                return true;
            }
        }
        return false;
    }

    public static FlowAnalSymVector globalSymVector(SubpFlow pSubpFlow) {
        FlowAnalSymVector lGlobal = pSubpFlow.flowAnalSymVector();
        FAList lSymIndexTable = pSubpFlow.getSymIndexTable();
        for (int lIndex = 1; lIndex <= lSymIndexTable.size(); ++lIndex) {
            if (!((Sym)lSymIndexTable.get(lIndex)).isGlobal()) continue;
            lGlobal.setBit(lIndex);
        }
        return lGlobal;
    }

    public static FlowAnalSymVector staticSymVector(SubpFlow pSubpFlow) {
        FlowAnalSymVector lStatic = pSubpFlow.flowAnalSymVector();
        FAList lSymIndexTable = pSubpFlow.getSymIndexTable();
        for (int lIndex = 1; lIndex <= lSymIndexTable.size(); ++lIndex) {
            if (((Var)lSymIndexTable.get(lIndex)).getStorageClass() != 6) continue;
            lStatic.setBit(lIndex);
        }
        return lStatic;
    }

    public static List bfSearch(BBlock pEntry, BBlock pExit, boolean pForward) {
        ArrayList<BBlock> lBFList = new ArrayList<BBlock>();
        lBFList.add(pEntry);
        FlowUtil.bfs(lBFList, pExit, 0, pForward);
        return lBFList;
    }

    private static void bfs(List pBFList, BBlock pExit, int pPos, boolean pForward) {
        BBlock lCurrent = (BBlock)pBFList.get(pPos);
        if (lCurrent != pExit) {
            List lSuccList = pForward ? lCurrent.getSuccList() : lCurrent.getPredList();
            for (BBlock lSucc : lSuccList) {
                if (pBFList.contains(lSucc)) continue;
                pBFList.add(lSucc);
            }
        }
        if (pPos < pBFList.size() - 1) {
            FlowUtil.bfs(pBFList, pExit, ++pPos, pForward);
        }
    }

    public static HirIterator hirIterator(HIR pSubtree) {
        return new HirIt(pSubtree, true);
    }

    public static NodeIterator nodeIterator(IR pIR) {
        if (pIR instanceof HIR) {
            return new HirIt0(pIR);
        }
        throw new FlowError();
    }

    public static NodeListIterator nodeListIterator(IR pIR) {
        return FlowUtil.nodeListIterator(pIR, true, true);
    }

    public static NodeListIterator nodeListIterator(IR pIR, boolean pFromTop, boolean pFromLeft) {
        if (pIR instanceof HIR) {
            return new HirListIt0((HIR)pIR, pFromTop, pFromLeft);
        }
        throw new FlowError();
    }

    public static int computeHashCodeOfNode(IR pIR) {
        if (pIR instanceof HIR) {
            return FlowUtil.computeHashCodeOfNode((HIR)pIR);
        }
        throw new FlowError();
    }

    public static boolean isUnder(IR pAncestor, IR pDescendant) {
        if (pAncestor == null) {
            return false;
        }
        while (!pAncestor.equals(pDescendant)) {
            if (pDescendant.getParent() == null) {
                return false;
            }
            pDescendant = pDescendant.getParent();
        }
        return true;
    }

    private static boolean isSameTree(HIR pTree1, HIR pTree2) {
        if (pTree1 == pTree2) {
            return true;
        }
        if (pTree1 == null || pTree2 == null) {
            return false;
        }
        if (FlowUtil.computeHashCodeOfNode(pTree1) != FlowUtil.computeHashCodeOfNode(pTree2)) {
            return false;
        }
        Sym lSym1 = pTree1.getSym();
        if (lSym1 != null) {
            return lSym1 == pTree2.getSym();
        }
        int lChildCount = pTree1.getChildCount();
        if (pTree1.getOperator() != pTree2.getOperator() || pTree2.getChildCount() != lChildCount || pTree1.getType() != pTree2.getType()) {
            return false;
        }
        for (int lChild = 1; lChild <= lChildCount; ++lChild) {
            if (FlowUtil.isSameTree((HIR)pTree1.getChild(lChild), (HIR)pTree2.getChild(lChild))) continue;
            return false;
        }
        return true;
    }

    private static int computeHashCodeOfNode(HIR pNode) {
        if (pNode == null) {
            return 0;
        }
        int lCode = pNode.getOperator() + System.identityHashCode(pNode.getType());
        Sym lSym = pNode.getSym();
        if (lSym != null) {
            lCode = lCode * 2 + System.identityHashCode(lSym);
        } else {
            int lChildCount = pNode.getChildCount();
            if (pNode instanceof HirList) {
                ListIterator lIterator = ((HirList)pNode).iterator();
                while (lIterator.hasNext()) {
                    Object lObject = lIterator.next();
                    if (!(lObject instanceof HIR)) continue;
                    lCode = lCode * 2 + FlowUtil.computeHashCodeOfNode((HIR)lObject);
                }
            } else {
                for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                    lCode = lCode * 2 + FlowUtil.computeHashCodeOfNode((HIR)pNode.getChild(lChild));
                }
            }
        }
        if (pNode.getParent() instanceof AssignStmt && pNode.getParent().getChild1() == pNode) {
            lCode *= 2;
        }
        lCode = (lCode & Integer.MAX_VALUE) % 499;
        return lCode;
    }

    public static String toString(HIR pHIR) {
        StringBuffer lBuff = new StringBuffer();
        if (pHIR == null) {
            return "";
        }
        lBuff.append("(");
        lBuff.append(pHIR.toStringShort());
        for (int i = 1; i <= pHIR.getChildCount(); ++i) {
            lBuff.append(FlowUtil.toString((HIR)pHIR.getChild(i)));
        }
        lBuff.append(")");
        return lBuff.toString();
    }

    public static boolean shouldAssignFlowExpId(IR pIR) {
        return AssignHashBasedFlowExpId.shouldAssignFlowExpId(pIR);
    }

    public static DNodeIterator dNodeIterator(IR pIR) {
        if (pIR instanceof HIR) {
            return new HirIt1((HIR)pIR);
        }
        throw new UnimplementedMethodException();
    }

    public static boolean isDefSymNode(IR pIR) {
        if (pIR instanceof HIR) {
            return ((HIR)pIR.getParent()).getOperator() == 22 && (HIR)pIR.getParent().getChild1() == pIR;
        }
        throw new FlowError();
    }

    public static boolean isUnderCall(IR pIR) {
        if (pIR instanceof HIR) {
            while (pIR != null) {
                if (((HIR)pIR).getOperator() == 33) {
                    return true;
                }
                pIR = pIR.getParent();
            }
        } else {
            throw new FlowError();
        }
        return false;
    }

    public static boolean notDereferenced(IR pIR) {
        int lOpCode;
        return pIR instanceof HIR && (lOpCode = ((HIR)pIR.getParent()).getOperator()) == 64;
    }

    public static boolean isCall(IR pIR) {
        if (pIR instanceof HIR) {
            return ((HIR)pIR).getOperator() == 33;
        }
        throw new FlowError();
    }

    public static List argsOf(IR pIR) {
        ArrayList lArgs = new ArrayList();
        if (pIR instanceof HIR) {
            ListIterator lIt = ((FunctionExp)pIR).getActualParamList().iterator();
            while (lIt.hasNext()) {
                lArgs.add(lIt.next());
            }
        } else {
            throw new FlowError();
        }
        return lArgs;
    }

    public static boolean readsFromIndefiniteAddress(IR pIR) {
        if (pIR instanceof HIR) {
            int lOpCode = ((HIR)pIR).getOperator();
            return lOpCode == 20 || lOpCode == 68 || lOpCode == 67;
        }
        throw new FlowError();
    }

    public static Set modLvalues(SetRefRepr pSetRefRepr, FlowResults pResults) {
        HashSet lLvalues = new HashSet();
        if (pSetRefRepr.sets()) {
            if (pSetRefRepr instanceof SetRefReprHir) {
                FlowUtil.modLvaluesUnder((HIR)pSetRefRepr.defNode(), lLvalues, pSetRefRepr.getBBlock().getSubpFlow(), pResults);
            } else {
                throw new FlowError();
            }
        }
        return lLvalues;
    }

    private static void modLvaluesUnder(HIR pHIR, Set pModLvalues, SubpFlow pSubpFlow, FlowResults pResults) {
        Sym lSym = pHIR.getSym();
        int lOpCode = pHIR.getOperator();
        if (pHIR instanceof Stmt) {
            throw new FlowError("Invalid argument.");
        }
        if (lSym instanceof FlowAnalSym) {
            pModLvalues.add(pResults.getFlowExpIdForNode(pHIR));
        }
        switch (lOpCode) {
            case 17: {
                pModLvalues.add(pResults.getFlowExpIdForNode(pHIR));
                FlowUtil.modLvaluesUnder(((SubscriptedExp)pHIR).getArrayExp(), pModLvalues, pSubpFlow, pResults);
                break;
            }
            case 68: {
                pModLvalues.addAll(pSubpFlow.getFlowExpIdTable());
                break;
            }
            case 64: {
                break;
            }
            default: {
                for (int lChildNumber = 1; lChildNumber <= pHIR.getChildCount(); ++lChildNumber) {
                    FlowUtil.modLvaluesUnder((HIR)pHIR.getChild(lChildNumber), pModLvalues, pSubpFlow, pResults);
                }
            }
        }
    }

    public static boolean isLvalue(IR pIR) {
        if (pIR instanceof HIR) {
            switch (pIR.getOperator()) {
                case 7: 
                case 17: 
                case 19: 
                case 20: 
                case 67: 
                case 68: {
                    return true;
                }
            }
            return false;
        }
        throw new FlowError();
    }

    public static boolean possiblyOverlaps(FlowExpId pFlowExpId, FlowExpId pFlowExpId0, SubpFlow pSubpFlow) {
        HashSet lModSyms = new HashSet();
        HashSet lModSyms0 = new HashSet();
        if (!(pFlowExpId.getLinkedNode() instanceof HIR)) {
            throw new FlowError();
        }
        FlowUtil.modSymsUnder((HIR)pFlowExpId.getLinkedNode(), lModSyms, pSubpFlow);
        FlowUtil.modSymsUnder((HIR)pFlowExpId0.getLinkedNode(), lModSyms0, pSubpFlow);
        return lModSyms.removeAll(lModSyms0);
    }

    public static boolean definitelyOverlaps(FlowExpId pFlowExpId, FlowExpId pFlowExpId0, SubpFlow pSubpFlow) {
        FlowResults lResults = pSubpFlow.results();
        if (pFlowExpId != pFlowExpId0) {
            return false;
        }
        IR lIR = pFlowExpId.getLinkedNode();
        if (lIR instanceof HIR) {
            switch (((HIR)lIR).getOperator()) {
                case 7: {
                    return pFlowExpId == pFlowExpId0;
                }
                case 17: {
                    SubscriptedExp lSubs = (SubscriptedExp)lIR;
                    FlowExpId lLeftChildExpId = lResults.getFlowExpIdForNode(lSubs.getArrayExp());
                    return FlowUtil.definitelyOverlaps(lLeftChildExpId, lLeftChildExpId, pSubpFlow) && lSubs.getSubscriptExp().getOperator() == 5;
                }
                case 20: 
                case 68: {
                    return false;
                }
                case 19: {
                    FlowExpId lLeftChildExpId = lResults.getFlowExpIdForNode(lIR.getChild1());
                    return FlowUtil.definitelyOverlaps(lLeftChildExpId, lLeftChildExpId, pSubpFlow);
                }
                case 67: {
                    return false;
                }
            }
            throw new FlowError();
        }
        throw new FlowError();
    }

    private static void modSymsUnder(HIR pHIR, Set pModSyms, SubpFlow pSubpFlow) {
        Sym lSym = pHIR.getSym();
        int lOpCode = pHIR.getOperator();
        if (pHIR instanceof Stmt) {
            throw new FlowError("Invalid argument.");
        }
        if (lSym instanceof FlowAnalSym) {
            pModSyms.add(pHIR.getSym());
        }
        switch (lOpCode) {
            case 17: {
                FlowUtil.modSymsUnder(((SubscriptedExp)pHIR).getArrayExp(), pModSyms, pSubpFlow);
                break;
            }
            case 68: {
                pModSyms.addAll(pSubpFlow.getSymIndexTable());
                break;
            }
            case 64: {
                break;
            }
            default: {
                for (int lChildNumber = 1; lChildNumber <= pHIR.getChildCount(); ++lChildNumber) {
                    FlowUtil.modSymsUnder((HIR)pHIR.getChild(lChildNumber), pModSyms, pSubpFlow);
                }
            }
        }
    }

    public static boolean hasCallUnder(IR pIR) {
        NodeIterator lIt = FlowUtil.nodeIterator(pIR);
        while (lIt.hasNext()) {
            if (!FlowUtil.isCall(lIt.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubtreeUnremovable(IR pIR) {
        NodeIterator lIt = FlowUtil.nodeIterator(pIR);
        while (lIt.hasNext()) {
            IR lIR = lIt.next();
            if (!FlowUtil.isCall(lIR) && !FlowUtil.isVolatile(lIR)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVolatile(IR pIR) {
        Sym lSym = pIR.getSym();
        return lSym == null ? false : lSym.getSymType().isVolatile();
    }

    public static boolean mayBeExternalAddress(IR pIR) {
        HIR lHIR;
        if (pIR instanceof HIR && (lHIR = (HIR)pIR).getOperator() == 17) {
            return FlowUtil.mayBeExternalAddress(((SubscriptedExp)lHIR).getArrayExp());
        }
        return FlowUtil.readsFromIndefiniteAddress(pIR);
    }

    public static boolean IsVarSyms(Sym pSym) {
        return FlowUtil.IsVarSymType(pSym.getSymType());
    }

    public static HIR getQualVarNode(HIR pNode) {
        HIR c = FlowUtil.getComplexNode(pNode);
        if (c != null) {
            return c;
        }
        if (pNode.getOperator() == 19) {
            if (FlowUtil.IsCommonQUAL(pNode)) {
                return FlowUtil.getQualVarNode((HIR)pNode.getChild2());
            }
            return FlowUtil.getQualVarNode((HIR)pNode.getChild1());
        }
        return pNode;
    }

    public static boolean IsCommonQUAL(HIR pNode) {
        if (pNode == null) {
            return false;
        }
        if (pNode.getOperator() != 19) {
            return false;
        }
        Type t = pNode.getType();
        if (t.getTypeKind() == 24 || t.getTypeKind() == 25) {
            Sym tag = ((StructType)t).getTag();
            if (tag == null) {
                return false;
            }
            if (tag.getFlag(15)) {
                return true;
            }
            if (FlowUtil.IsCommonQUAL((HIR)pNode.getChild1())) {
                return true;
            }
            if (FlowUtil.IsCommonQUAL((HIR)pNode.getChild2())) {
                return true;
            }
        }
        return true;
    }

    public static boolean IsComplexQUAL(HIR pNode) {
        if (pNode.getOperator() != 19) {
            return false;
        }
        HIR c = FlowUtil.getComplexNode(pNode);
        return c != null;
    }

    public static HIR getComplexNode(HIR pNode) {
        if (pNode.getOperator() != 19) {
            return null;
        }
        HIR cNode = (HIR)pNode.getChild1();
        if (FlowUtil.IsComplexNode(cNode)) {
            return cNode;
        }
        cNode = (HIR)pNode.getChild2();
        if (FlowUtil.IsComplexNode(cNode)) {
            return cNode;
        }
        if (pNode.getOperator() == 19) {
            HIR Child = FlowUtil.getComplexNode((HIR)pNode.getChild1());
            if (Child != null) {
                return Child;
            }
            Child = FlowUtil.getComplexNode((HIR)pNode.getChild2());
            if (Child != null) {
                return Child;
            }
        }
        return null;
    }

    public static boolean IsComplexNode(HIR pNode) {
        Type t;
        FlowAnalSym s = FlowUtil.flowAnalSym(pNode);
        if (s != null && (t = pNode.getType()).getTypeKind() == 24) {
            Type tsym = s.getSymType();
            Sym tag = ((StructType)tsym).getTag();
            if (tag == null) {
                return false;
            }
            if (tag.getFlag(14)) {
                return true;
            }
        }
        return false;
    }

    public static boolean IsComplexElemNode(HIR pNode) {
        if (FlowUtil.IsComplexNode(pNode)) {
            return false;
        }
        HIR lParent = (HIR)pNode.getParent();
        return lParent.getOperator() == 19 && FlowUtil.IsComplexQUAL(lParent);
    }

    public static boolean IsVarSymType(Type pType) {
        if (pType.getTypeKind() == 25) {
            return false;
        }
        return pType.getTypeKind() != 24;
    }

    private static class HirIt1
    implements DNodeIterator {
        static final HIR EOB = new HIR_Impl();
        private HIR fNext = null;

        HirIt1(HIR pHIR) {
            this.fNext = pHIR;
        }

        public boolean hasNext() {
            return this.fNext != EOB && this.fNext != null;
        }

        public IR next() {
            HIR lHIRNext;
            if (this.fNext == null) {
                return null;
            }
            HIR lCurrent = this.fNext;
            HIR lHIR = this.fNext;
            boolean lOpCode = false;
            this.fNext = lHIR = (lHIRNext = HirIt1.tryNext(lHIR));
            return lCurrent;
        }

        public IR getNextExecutableNode() {
            HIR lHIR;
            while (!Flow.isExecutable(lHIR = (HIR)this.next()) && lHIR != null && lHIR != EOB) {
            }
            if (lHIR == EOB) {
                lHIR = null;
            }
            return lHIR;
        }

        private static HIR tryNext(HIR pHIR) {
            int i = 1;
            for (i = 1; i <= pHIR.getChildCount(); ++i) {
                HIR lNext = (HIR)pHIR.getChild(i);
                if (lNext == null) continue;
                return lNext;
            }
            return HirIt1.tryNeitherDescendantsNorAncestors(pHIR);
        }

        private static HIR tryNeitherDescendantsNorAncestors(HIR pHIR) {
            HIR lNext = pHIR.getNextStmt();
            if (lNext != null) {
                return lNext;
            }
            int lChildNumber = pHIR.getChildNumber();
            HIR lParent = (HIR)pHIR.getParent();
            if (lParent == null) {
                return EOB;
            }
            int lChildCount = lParent.getChildCount();
            while (0 < lChildNumber && lChildNumber < lChildCount) {
                if ((lNext = (HIR)lParent.getChild(++lChildNumber)) == null) continue;
                return lNext;
            }
            return HirIt1.tryNeitherDescendantsNorAncestors(lParent);
        }

        public IR skipSubtree() {
            HIR lHIRNext;
            if (this.fNext == null) {
                return null;
            }
            HIR lCurrent = this.fNext;
            HIR lHIR = this.fNext;
            boolean lOpCode = false;
            this.fNext = lHIR = (lHIRNext = HirIt1.tryNeitherDescendantsNorAncestors(lHIR));
            return lCurrent;
        }
    }

    private static class HirListIt0
    extends HirIt0
    implements NodeListIterator {
        ListIterator fListIt;
        boolean fFromTop;
        HirIt fHirIt;

        HirListIt0(HIR pHIR, boolean pFromTop, boolean pFromLeft) {
            this.fFromTop = pFromTop;
            this.fHirIt = new HirIt(pHIR, !(pFromTop ^ pFromLeft));
            this.fListIt = pFromTop ? this.fHirIt.fList.listIterator() : this.fHirIt.fList.listIterator(this.fHirIt.fList.size());
        }

        public boolean hasNext() {
            if (this.fFromTop) {
                return this.fListIt.hasNext();
            }
            return this.fListIt.hasPrevious();
        }

        public IR next() {
            if (this.fFromTop) {
                return (IR)this.fListIt.next();
            }
            return (IR)this.fListIt.previous();
        }

        public boolean hasPrevious() {
            if (this.fFromTop) {
                return this.fListIt.hasPrevious();
            }
            return this.fListIt.hasNext();
        }

        public int nextIndex() {
            if (this.fFromTop) {
                return this.fListIt.nextIndex();
            }
            return this.fHirIt.fList.size() - 1 - this.fListIt.previousIndex();
        }

        public IR previous() {
            if (this.fFromTop) {
                return (IR)this.fListIt.previous();
            }
            return (IR)this.fListIt.next();
        }

        public int previousIndex() {
            if (this.fFromTop) {
                return this.fListIt.previousIndex();
            }
            return this.fHirIt.fList.size() - 1 - this.fListIt.nextIndex();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(IR pIR) {
        }
    }

    private static class HirIt0
    implements NodeIterator {
        HirIt fHirIt;

        HirIt0(IR pIR) {
            this.fHirIt = new HirIt((HIR)pIR, true);
        }

        HirIt0() {
        }

        public boolean hasNext() {
            return this.fHirIt.hasNext();
        }

        public IR next() {
            return this.fHirIt.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new FlowError();
        }

        public IR previous() {
            throw new FlowError();
        }
    }

    private static class HirIt
    implements HirIterator {
        List fList = new ArrayList();
        ListIterator fIt;

        HirIt(HIR pSubtree, boolean pFromTopAndLeft) {
            this.addUnder(pSubtree, pFromTopAndLeft);
            this.fIt = this.fList.listIterator();
        }

        private void addUnder(HIR pSubtree, boolean pFromTopAndLeft) {
            block10: {
                block11: {
                    int lOpCode;
                    block9: {
                        if (pSubtree == null) {
                            return;
                        }
                        this.fList.add(pSubtree);
                        lOpCode = pSubtree.getOperator();
                        if (lOpCode != 35) break block9;
                        for (Stmt lStmt = ((BlockStmt)pSubtree).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            this.addUnder(lStmt, pFromTopAndLeft);
                        }
                        break block10;
                    }
                    if (lOpCode != 14) break block11;
                    ArrayList<HIR> lArgs = new ArrayList<HIR>();
                    ListIterator lIt = ((HirList)pSubtree).iterator();
                    while (lIt.hasNext()) {
                        HIR lHir = (HIR)lIt.next();
                        if (pFromTopAndLeft) {
                            this.addUnder(lHir, pFromTopAndLeft);
                            continue;
                        }
                        lArgs.add(lHir);
                    }
                    if (pFromTopAndLeft) break block10;
                    ListIterator lListIt = lArgs.listIterator(lArgs.size());
                    while (lListIt.hasPrevious()) {
                        this.addUnder((HIR)lListIt.previous(), pFromTopAndLeft);
                    }
                    break block10;
                }
                int lChildCount = pSubtree.getChildCount();
                if (pFromTopAndLeft) {
                    for (int i = 1; i <= lChildCount; ++i) {
                        this.addUnder((HIR)pSubtree.getChild(i), pFromTopAndLeft);
                    }
                } else {
                    for (int i = lChildCount; i > 0; --i) {
                        this.addUnder((HIR)pSubtree.getChild(i), pFromTopAndLeft);
                    }
                }
            }
        }

        public HIR next() {
            return (HIR)this.fIt.next();
        }

        public boolean hasNext() {
            return this.fIt.hasNext();
        }

        public HIR getNextExecutableNode() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNextStmt() {
            throw new UnsupportedOperationException();
        }

        public Stmt getNextStmt() {
            throw new UnsupportedOperationException();
        }

        public Stmt nextStmt() {
            throw new UnsupportedOperationException();
        }

        public HIR getParentNode() {
            throw new UnsupportedOperationException();
        }

        public int getStackDepth() {
            throw new UnsupportedOperationException();
        }

        public HIR peekCurrent() {
            throw new UnsupportedOperationException();
        }

        public HIR peekNext() {
            return (HIR)this.fList.get(this.fIt.nextIndex());
        }

        public void replaceNext(HIR pHIR) {
            throw new UnsupportedOperationException();
        }
    }
}

