/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.ExpVector;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorIterator;
import coins.aflow.FlowAnalSymVectorIteratorImpl;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.aflow.SubpFlowImpl;
import coins.aflow.util.BitVectorImpl;
import coins.aflow.util.FAList;
import coins.sym.FlowAnalSym;
import java.util.HashSet;
import java.util.Set;

public class FlowAnalSymVectorImpl
extends BitVectorImpl
implements FlowAnalSymVector {
    private final SubpFlow fSubpFlow;
    final FlowResults fResults;

    public FlowAnalSymVectorImpl(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
        this.fResults = this.fSubpFlow.results();
        this.fBitLength = ((FAList)this.fResults.get("SymIndexTable", this.fSubpFlow)).size();
        this.fLongWordLength = this.fBitLength / 64 + 1;
        this.fVectorWord = new long[this.fLongWordLength];
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public Set flowAnalSyms() {
        HashSet<FlowAnalSym> lFlowAnalSyms = new HashSet<FlowAnalSym>();
        FlowAnalSymVectorIterator lFASVectIt = this.flowAnalSymVectorIterator();
        while (lFASVectIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lFASVectIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lFlowAnalSyms.add(lFlowAnalSym);
        }
        return lFlowAnalSyms;
    }

    public boolean contains(FlowAnalSym pFlowAnalSym) {
        return this.flowAnalSyms().contains(pFlowAnalSym);
    }

    public boolean remove(FlowAnalSym pFlowAnalSym) {
        int lIndex = this.fSubpFlow.getSymIndexTable().indexOf(pFlowAnalSym);
        if (this.isSet(lIndex)) {
            this.resetBit(lIndex);
            return true;
        }
        return false;
    }

    public static FlowAnalSymVector forSet(Set pFlowAnalSyms, SubpFlow pSubpFlow) {
        FlowAnalSymVector lFlowAnalSymVect = pSubpFlow.flowAnalSymVector();
        for (Object lNext : pFlowAnalSyms) {
            lFlowAnalSymVect.setBit(((FAList)pSubpFlow.results().get("SymIndexTable", pSubpFlow)).indexOf(lNext));
        }
        return lFlowAnalSymVect;
    }

    public FlowAnalSymVectorIterator flowAnalSymVectorIterator() {
        return new FlowAnalSymVectorIteratorImpl(this);
    }

    public boolean addAll(Set pFlowAnalSyms) {
        FlowAnalSymVector lVect = FlowAnalSymVectorImpl.forSet(pFlowAnalSyms, this.fSubpFlow);
        FlowAnalSymVector lVectResult = this.fSubpFlow.flowAnalSymVector();
        this.vectorOr(lVect, lVectResult);
        boolean lReturnVal = lVectResult.vectorEqual(this);
        lVectResult.vectorCopy(this);
        return lReturnVal;
    }

    public String toStringDescriptive() {
        StringBuffer lBuff = new StringBuffer();
        FlowAnalSymVectorIterator lIt = this.flowAnalSymVectorIterator();
        while (lIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lBuff.append(lFlowAnalSym + "\n");
        }
        return lBuff.toString();
    }

    public String toStringShort() {
        StringBuffer lBuff = new StringBuffer();
        FlowAnalSymVectorIterator lIt = this.flowAnalSymVectorIterator();
        while (lIt.hasNext()) {
            FlowAnalSym lFlowAnalSym = lIt.nextFlowAnalSym();
            if (lFlowAnalSym == null) continue;
            lBuff.append(lFlowAnalSym.toStringShort() + " ");
        }
        return lBuff.toString();
    }

    public ExpVector flowAnalSymToExpVector() {
        ExpVector lExpVector = this.fSubpFlow.expVector();
        FlowAnalSymVectorIterator lIterator = this.flowAnalSymVectorIterator();
        while (lIterator.hasNext()) {
            FlowAnalSym lSym = lIterator.nextFlowAnalSym();
            if (!(lSym instanceof FlowExpId)) continue;
            lExpVector.setBit(((FlowExpId)((Object)lSym)).getIndex());
        }
        ((SubpFlowImpl)this.fSubpFlow).flow.dbg(4, " flowAnalSymToExpVector", lExpVector.toStringDescriptive());
        return lExpVector;
    }
}

