/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.DefVector;
import coins.aflow.FindKill;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.alias.RecordAlias;
import coins.sym.FlowAnalSym;
import java.util.Set;

public class FindDKill
extends FindKill {
    public FindDKill(FlowResults pResults) {
        super(pResults);
    }

    protected boolean kills(SetRefRepr pKiller, SetRefRepr pKillee) {
        RecordAlias lRecordAlias;
        if (this.flow.fSubpFlow != null && (lRecordAlias = this.flow.fSubpFlow.getRecordAlias()) != null) {
            return this.killsByAlias(pKiller, pKillee, lRecordAlias);
        }
        FlowAnalSym lDefSym = pKiller.defSym();
        return lDefSym != null && lDefSym == pKillee.defSym();
    }

    protected boolean killsByAlias(SetRefRepr pKiller, SetRefRepr pKillee, RecordAlias pRecordAlias) {
        FlowAnalSym lKillerDefSym = pKiller.defSym();
        FlowAnalSym lKilleeDefSym = pKillee.defSym();
        if (lKillerDefSym != null) {
            Set lModSyms = pKiller.modSyms00();
            Set lModSymsAlias = pRecordAlias.aliasSymGroup(lModSyms);
            this.flow.dbg(5, " killsByalias killer " + lModSymsAlias + " killee " + lKilleeDefSym);
            if (lModSymsAlias.contains(lKilleeDefSym)) {
                return true;
            }
        }
        return false;
    }

    protected void register(SetRefRepr pSetRefRepr, DefVector pDefVect) {
        this.fResults.put("DKill", pSetRefRepr, pDefVect);
    }

    protected DefVector getKill(SetRefRepr pSetRefRepr) {
        return (DefVector)this.fResults.get("DKill", pSetRefRepr);
    }

    protected void register(BBlock pBBlock, DefVector pDefVect) {
        pBBlock.setDKill(pDefVect);
    }
}

