/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.aflow.AssignFlowExpId;
import coins.aflow.BBlock;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.HashBasedFlowExpId;
import coins.aflow.NodeIterator;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprIterator;
import coins.aflow.SubpFlow;
import coins.aflow.SubpFlowImpl;
import coins.aflow.util.FAList;
import coins.aflow.util.FlowError;
import coins.ir.IR;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.HIR;
import java.util.HashSet;

public abstract class AssignHashBasedFlowExpId
implements AssignFlowExpId {
    public static final int EXP_ID_HASH_SIZE = 499;
    final HashBasedFlowExpId[] fFlowExpIdHashtable = new HashBasedFlowExpId[499];
    FAList fFlowExpIdTable = new FAList();
    SubpFlow fSubpFlow;
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    protected final FlowResults fResults;

    public AssignHashBasedFlowExpId(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
        this.flowRoot = ((SubpFlowImpl)this.fSubpFlow).flowRoot;
        this.ioRoot = this.flowRoot.ioRoot;
        this.fResults = this.fSubpFlow.results();
        this.fResults.put("AssignerForSubpFlow", this.fSubpFlow, this);
        this.fSubpFlow.allocateExpIdTable();
    }

    public void assign() {
        this.flowRoot.aflow.dbg(2, " AssignHashBasedFlowExpId.", "assign");
        this.flowRoot.aflow.dbg(4, " fRefults=" + this.fResults);
        this.fSubpFlow.setFlowExpIdTable(this.fFlowExpIdTable);
        for (Object lObject : this.fSubpFlow.getBBlocks()) {
            this.flowRoot.aflow.dbg(3, " assign ", ((BBlock)lObject).toString());
            this.assignForBBlock((BBlock)lObject);
        }
        this.ioRoot.dbgFlow.print(4, "fFlowExpIdHashtable: " + this.fFlowExpIdHashtable);
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() >= 2) {
            this.fSubpFlow.printExpIdTable();
        }
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() >= 3) {
            this.fSubpFlow.getSubpDefinition().printHir("after ExpId assignment");
        }
    }

    void assignForBBlock(BBlock pBBlock) {
        SetRefReprIterator lIt = pBBlock.getSetRefReprs().setRefReprIterator();
        while (lIt.hasNext()) {
            Object lObject = lIt.next();
            this.flowRoot.aflow.dbg(3, " assignForBBlock ", lObject);
            SetRefRepr lSetRefRepr = (SetRefRepr)lObject;
            this.assignForSetRefRepr(lSetRefRepr);
        }
    }

    void assignForSetRefRepr(SetRefRepr pSetRefRepr) {
        this.flowRoot.aflow.dbg(3, " assignForSetRefRepr", " ");
        HashSet<FlowExpId> lFlowExpIds = new HashSet<FlowExpId>();
        HashSet<FlowExpId> lUseFlowExpIds = new HashSet<FlowExpId>();
        NodeIterator lIt = FlowUtil.nodeIterator(pSetRefRepr.getIR());
        while (lIt.hasNext()) {
            IR lIR = lIt.next();
            if (!AssignHashBasedFlowExpId.shouldAssignFlowExpId(lIR)) continue;
            FlowExpId lFlowExpId = this.assignToNode(lIR);
            lFlowExpIds.add(lFlowExpId);
            if (pSetRefRepr.sets() && pSetRefRepr.defNode() == lIR) continue;
            lUseFlowExpIds.add(lFlowExpId);
        }
        this.fResults.put("FlowExpIdsForSetRefRepr", pSetRefRepr, lFlowExpIds);
        this.fResults.put("UseFlowExpIdsForSetRefRepr", pSetRefRepr, lUseFlowExpIds);
        this.ioRoot.dbgFlow.print(4, " put UseFlowExpIdsForSetRefRepr", pSetRefRepr + " " + lUseFlowExpIds);
    }

    public FlowExpId assignToNode(IR pIR) {
        HashBasedFlowExpId lFlowExpId;
        int lIndex = pIR.getIndex();
        FlowExpId lFlowExpId0 = ((SubpFlowImpl)this.fSubpFlow).getExpId(pIR, lIndex);
        if (lFlowExpId0 != null) {
            this.ioRoot.dbgFlow.print(4, " allocated " + ((HIR)pIR).toStringShort() + " " + lFlowExpId0.toStringShort());
            return lFlowExpId0;
        }
        int lHashCode = FlowUtil.computeHashCodeOfNode(pIR);
        this.ioRoot.dbgFlow.print(4, "AssignHashBasedFlowExpId", ((HIR)pIR).toStringShort() + ": hash= " + lHashCode);
        FlowResults lResults = this.fSubpFlow.results();
        int lFlowExpIdTableSize = this.fFlowExpIdTable.size();
        for (lFlowExpId = this.fFlowExpIdHashtable[lHashCode]; lFlowExpId != null && !FlowUtil.isSameTree(lFlowExpId.getTree(), pIR); lFlowExpId = lFlowExpId.getNextInChain()) {
        }
        if (lFlowExpId == null) {
            lFlowExpId = this.newHashBasedFlowExpId(pIR, ++lFlowExpIdTableSize, this.fSubpFlow);
            lResults.setFlowExpIdForNode(pIR, lFlowExpId);
            this.fFlowExpIdTable.add(lFlowExpId);
            lFlowExpId.setNextInChain(this.fFlowExpIdHashtable[lHashCode]);
            this.fFlowExpIdHashtable[lHashCode] = lFlowExpId;
        } else {
            lResults.setFlowExpIdForNode(pIR, lFlowExpId);
        }
        this.fSubpFlow.setExpId(pIR, lFlowExpId);
        if (pIR instanceof HIR && ((HIR)pIR).getParent() instanceof AssignStmt && ((HIR)pIR).getParent().getChild1() == pIR) {
            lFlowExpId.setLHSFlag();
        }
        this.ioRoot.dbgFlow.print(4, lFlowExpId.toStringShort());
        return lFlowExpId;
    }

    abstract HashBasedFlowExpId newHashBasedFlowExpId(IR var1, int var2, SubpFlow var3);

    public static boolean shouldAssignFlowExpId(IR pIR) {
        if (pIR instanceof HIR) {
            switch (((HIR)pIR).getOperator()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 71: 
                case 73: 
                case 79: 
                case 80: {
                    return false;
                }
                case 7: 
                case 8: 
                case 12: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 33: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 47: 
                case 48: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 72: 
                case 76: 
                case 77: 
                case 78: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    return true;
                }
            }
            throw new FlowError();
        }
        throw new FlowError();
    }
}

