/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.IoRoot;
import coins.MachineParam;
import coins.sym.Type;

public class MachineParamX86
extends MachineParam {
    public static final int SIZEOF_BOOL = 4;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 4;
    public static final int SIZEOF_LONG_LONG = 8;
    public static final int SIZEOF_CHAR = 1;
    public static final int SIZEOF_WCHAR = 2;
    public static final int SIZEOF_VOID = 4;
    public static final int SIZEOF_PTR = 4;
    public static final int SIZEOF_ENUM = 4;
    public static final int SIZEOF_ADDRESS = 4;
    public static final int SIZEOF_OFFSET = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_LONG_DOUBLE = 8;
    public static final int ALIGN_BOOL = 4;
    public static final int ALIGN_SHORT = 2;
    public static final int ALIGN_INT = 4;
    public static final int ALIGN_LONG = 4;
    public static final int ALIGN_LONG_LONG = 4;
    public static final int ALIGN_CHAR = 1;
    public static final int ALIGN_WCHAR = 2;
    public static final int ALIGN_VOID = 4;
    public static final int ALIGN_PTR = 4;
    public static final int ALIGN_ENUM = 4;
    public static final int ALIGN_ADDRESS = 4;
    public static final int ALIGN_OFFSET = 4;
    public static final int ALIGN_FLOAT = 4;
    public static final int ALIGN_DOUBLE = 4;
    public static final int ALIGN_LONG_DOUBLE = 4;
    public static final int ALIGN_STRUCT_MIN = 1;
    public static final int ALIGN_REGION_MIN = 1;
    public static final int ALIGN_SUBP = 4;

    public MachineParamX86(IoRoot pIoRoot) {
        super(pIoRoot);
    }

    public int getIntKindForAddress() {
        return 3;
    }

    public int getIntKindForChar() {
        return 0;
    }

    public int getAlignment(int pTypeKind) {
        switch (pTypeKind) {
            case 1: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 4;
            }
            case 22: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 4;
            }
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                return 1;
            }
            case 21: {
                return 4;
            }
            case 28: {
                return 4;
            }
            case 27: {
                return 4;
            }
        }
        return 4;
    }

    public int minimumByteForBitFieldSequence() {
        return 1;
    }

    public boolean initGlobalExplicitly() {
        return false;
    }

    public boolean initByDataCode() {
        return true;
    }

    public int evaluateSize(int pTypeKind) {
        switch (pTypeKind) {
            case 1: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 8;
            }
            case 18: {
                return 8;
            }
            case 22: {
                return 4;
            }
            case 6: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 4;
            }
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                return 1;
            }
        }
        return 4;
    }

    public int getCharCode(char pChar) {
        int lCode = Character.digit(pChar, 10);
        if (lCode < 128) {
            return lCode;
        }
        return MachineParamX86.unicodeToJis(lCode);
    }

    private static int unicodeToJis(int pUniCode) {
        return pUniCode;
    }

    public Type getStringElemType() {
        return this.ioRoot.symRoot.getCharType();
    }

    public String blankRegionName() {
        return "_blankRegion".intern();
    }

    public int getLargestAlignment() {
        return 4;
    }

    public boolean isBigEndian() {
        return false;
    }

    public boolean isLittleEndian() {
        return true;
    }

    public boolean isPackedFromRight() {
        return true;
    }

    public boolean isPackedFromLeft() {
        return false;
    }

    public int costOfInstruction(int pIndex) {
        switch (pIndex) {
            case 1: {
                return 3;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 12;
            }
        }
        return 1;
    }

    public int getNumberOfGeneralRegisters() {
        return 8;
    }

    public int getNumberOfFloatingRegisters() {
        return 8;
    }
}

