/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * AWTを用いてGUIを実装したパッケージ
 */
package net.wasamon.mics.gui.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mjlib.util.DataUtil;

public class AWTArchitectureViewer extends MicsArchitectureViewer
		implements ActionListener {

	class ArchitectureCanvas extends Canvas implements MouseListener,
			MouseMotionListener, MicsArchitectureViewer.ViwerCanvas {

		private Hashtable imageTable;

		public ArchitectureCanvas() {
			super();
			imageTable = new Hashtable();
			addMouseListener(this);
			addMouseMotionListener(this);
		}

		public void update(Graphics g) {
			paint(g);
		}

		private Image buf = null;
		private int bufWidth;
		private int bufHeight;

		private Graphics g;

		public void paint(Graphics g) {
			if (buf == null) {
				buf = createImage(this.getWidth(), this.getHeight());
				bufWidth = getWidth();
				bufHeight = getHeight();
			} else if (bufWidth != getWidth() || bufHeight != getHeight()) {
				buf = null;
				buf = createImage(this.getWidth(), this.getHeight());
			}
			Graphics g2 = buf.getGraphics();
			g2.setColor(Color.WHITE);
			g2.fillRect(0, 0, this.getWidth(), this.getHeight());
			this.g = g2;

			AWTArchitectureViewer.this.paint();

			g.drawImage(buf, 0, 0, this);
			pane.doLayout();
		}

		private int selectedOffsetY;
		private int selectedOffsetX;

		public void mouseClicked(MouseEvent arg0) {
			// TODO Auto-generated method stub

		}

		public void mouseEntered(MouseEvent arg0) {
			// TODO Auto-generated method stub

		}

		public void mouseExited(MouseEvent e) {
			// TODO Auto-generated method stub

		}

		public void mousePressed(MouseEvent e) {
			setSelectedNode(e.getX(), e.getY());
			repaint();
			if (selectedNode != null) {
				selectedOffsetX = selectedNode.X - e.getX();
				selectedOffsetY = selectedNode.Y - e.getY();
				setSelectedElement(selectedNode.element);
			}
		}

		public void mouseReleased(MouseEvent e) {
			// selectedNode = null;
		}

		public void mouseDragged(MouseEvent arg0) {
			// TODO Auto-generated method stub
			if (selectedNode != null) {
				selectedNode.setPosition(arg0.getX() + selectedOffsetX, arg0.getY()
						+ selectedOffsetY);
				repaint();
				// pane.setScrollPosition(getScrollPostion(arg0.getX(), arg0.getY()));
			} else {
			}
		}

		public void mouseMoved(MouseEvent arg0) {
			// TODO Auto-generated method stub
		}

		public void drawImage(String name, int x, int y, int w, int h) {
			if (imageTable.containsKey(name) == false) {
				File f = new File(name);
				Image image;
				if(f.exists()){
					image = getToolkit().getImage(f.getAbsolutePath());
					System.out.println(f.getAbsolutePath());
				}else{
					image = getToolkit().getImage(getClass().getClassLoader().getResource(name));
				}
				imageTable.put(name, image);
			}
			g.drawImage((Image)(imageTable.get(name)), x, y, w, h, this);
		}

		public void drawLine(int x0, int y0, int x1, int y1) {
			g.drawLine(x0, y0, x1, y1);
		}

		public void drawRect(int x, int y, int w, int h) {
			g.drawRect(x, y, w, h);
		}

		public void drawString(String str, int x, int y) {
			g.drawString(str, x, y);
		}

		public void fillRect(int x, int y, int w, int h) {
			g.fillRect(x, y, w, h);
		}

		public int height() {
			return getBounds().height;
		}

		public void setBGColor() {
			g.setColor(Color.gray);
		}

		public void setColorBlack() {
			g.setColor(Color.black);
		}

		public void setColorRed() {
			g.setColor(Color.red);
		}

		public void setFGColor() {
			g.setColor(Color.black);
		}

		public int width() {
			return getBounds().width;
		}
	}

	private Frame frame;

	private ArchitectureCanvas canvas;

	private ScrollPane pane;

	public AWTArchitectureViewer(MicsCompositeElement composite) {
		super(composite);
		if (composite.id() != null && !composite.id().equals("")) {
			frame = new Frame("Architecture Viewer: " + composite.id());
		} else {
			frame = new Frame("Architecture Viewer");
		}
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				frame.setVisible(false);
			}
		});
		frame.setBounds(10, 10, 600, 400);
		frame.add(getToolBar(), BorderLayout.NORTH);
		canvas = new ArchitectureCanvas();
		pane = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
		pane.add(canvas);
		frame.add(pane, BorderLayout.CENTER);
		this.selectedElement = null;
		btnView.setEnabled(false);
		btnLoad.setEnabled(false);
		btnPrint.setEnabled(false);
		fieldAddr.setEnabled(false);
		canvas.imageTable.clear();
	}

	private MicsElement selectedElement;

	public MicsElement getSelectedElement() {
		return selectedElement;
	}

	public void setSelectedElement(MicsElement element) {
		if (element != null && selectedElement != element) {
			System.out.println(element.getInfo());
			if (element instanceof DataBuffer) {
				btnLoad.setEnabled(true);
				btnPrint.setEnabled(true);
				fieldAddr.setEnabled(true);
			} else {
				btnLoad.setEnabled(false);
			}
			if (element instanceof MicsViewable) {
				btnView.setEnabled(true);
			} else {
				btnView.setEnabled(false);
			}
			this.selectedElement = element;
		}
	}

	private Button btnLoad;

	private Button btnView;

	private TextField fieldAddr;

	private Button btnPrint;

	private Panel getToolBar() {
		Panel bar = new Panel();
		//bar.setLayout(new GridLayout(1, 3));
		bar.setLayout(new FlowLayout());
		btnLoad = new Button("Load");
		btnLoad.addActionListener(this);
		bar.add(btnLoad);
		btnView = new Button("View");
		btnView.addActionListener(this);
		bar.add(btnView);
		{
			Panel p = new Panel();
			fieldAddr = new TextField("0", 5);
			fieldAddr.addActionListener(this);
			btnPrint = new Button("Print");
			btnPrint.addActionListener(this);
			p.add(fieldAddr);
			p.add(btnPrint);
			bar.add(p);
		}

		return bar;
	}

	public void show() {
		this.selectedElement = null;
		btnView.setEnabled(false);
		btnLoad.setEnabled(false);
		btnPrint.setEnabled(false);
		fieldAddr.setEnabled(false);
		frame.setVisible(true);
		canvas.repaint();
	}

	public void actionPerformed(ActionEvent ev) {
		Object src = ev.getSource();
		if (src == null) {
		} else if (src == btnView) {
			MicsElement element = getSelectedElement();
			if (element != null && element instanceof MicsViewable) {
				((MicsViewable) element).show();
			}
		} else if (src == btnLoad) {
			MicsElement element = getSelectedElement();
			if (element != null && element instanceof DataBuffer) {
				MemoryLoader.getInstance().show((DataBuffer) element);
			}
		} else if (src == btnPrint) {
			int offset = 0;
			try {
				offset = DataUtil.parseInt(fieldAddr.getText());
			} catch (NumberFormatException e) {
				System.out.println("Illegal address format.");
			}
			System.out.println("Read Memory: " + getSelectedElement().id());
			System.out.println("From = " + offset);
			System.out.println(((DataBuffer) (getSelectedElement())).toString(offset,
					4));
		}
	}

	public ViwerCanvas canvas() {
		return canvas;
	}
}
