/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
/**
 * MICSのエンジンおよびMICSで規定するインターフェースの定義などのパッケージ
 */
package net.wasamon.mics;

import java.io.File;

import net.wasamon.mics.gui.MicsArchitectureViewer;

/**
 * MICSを操作するためのユーザインターフェースが実装すべきインターフェース
 * @author Takefumi MIYOSHI
 *
 */
public interface MicsShell {

	/**
	 * flagが真の場合、Micsエンジンへのアクセスを許可し、
	 * 偽の場合には、Micsエンジンへのアクセスを禁止する。
	 * @param flag
	 */
	public void setMicsEngineEnableState(boolean flag);

	/**
	 * プログラムの実行
	 * @param flag
	 */
	public void exec() throws MicsException;

	/**
	 * プログラムの実行。ただし、実行は、与えられたファイルに記述された内容に従う。
	 * @param flag
	 */
	public void exec(File batch) throws MicsException;
	
	/**
	 * 提供するインターフェースに対応するMicsArchitecttureViewerDataを構築し、返す。
	 * @param flag
	 */
	public MicsArchitectureViewer getMicsArchitectureViewerData(MicsCompositeElement composite); 

}
