/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * MICSのエンジンおよびMICSで規定するインターフェースの定義などのパッケージ
 */
package net.wasamon.mics;

/**
 * エンジンによって同期実行させるMICSシミュレーション要素が実装すべきインターフェース
 * @author Takefumi MIYOSHI
 *
 */
public interface ExecutableElement extends IMicsElement {

	/**
	 * あるクロック周期におけるエンジンからの第1回目のアクションとして呼ばれるメソッド。
	 * このメソッドの中では、同じ周期での他のインスタンスからのアクションによらない動作を記述する
	 */
	public ExecInfo exec_first() throws MicsException;

	/**
	 * あるクロック周期におけるエンジンからのエンジンから第2回目のアクションとして呼ばれるメソッド。
	 * 他のインスタンスからの入力を受けたことによるアクションを実装する。
	 */
	public ExecInfo exec_second() throws MicsException;

}
