/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * MICSのエンジンおよびMICSで規定するインターフェースの定義などのパッケージ
 */
package net.wasamon.mics;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * 
 * MICSシミュレーション要素がデータの集まりを保持する場合に、実装すべきインターフェース
 * @author Takefumi MIYOSHi
 *
 */
public interface DataBuffer extends IMicsElement {

	/**
	 * この要素からの読み込みを行う
	 * @param data
	 * @return
	 */
	public MicsDataPacket read(MicsDataPacket data) throws DataBufferException;

	/**
	 * この要素への書き込みを行う
	 * 
	 * @param data
	 */
	public void write(MicsDataPacket data) throws DataBufferException;

	/**
	 * 保持可能なデータの大きさを返す
	 * 
	 * @return
	 */
	public int size();

	/**
	 * 指定したアドレスから指定した長さのデータの内容を示す文字列を返す
	 * 
	 * @param addr
	 * @param length
	 * @return
	 */
	public String toString(int addr, int length);

	/**
	 * 入力ストリームから、データを読み取り、内部に保存する
	 * @param offset
	 * @param reader
	 * @throws DataBufferException
	 */
	public void write(int offset, InputStream reader) throws DataBufferException;

	/**
	 * 出力ストリームへ、保持するデータを出力する
	 * @param offset
	 * @param len
	 * @param writer
	 * @throws DataBufferException
	 */
	public void dump(int offset, int len, OutputStream writer) throws DataBufferException;

}
