/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;

public class LogicalExpression
implements Criterion {
    private final Criterion lhs;
    private final Criterion rhs;
    private final String op;

    protected LogicalExpression(Criterion lhs, Criterion rhs, String op) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.op = op;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        TypedValue[] lhstv = this.lhs.getTypedValues(criteria, criteriaQuery);
        TypedValue[] rhstv = this.rhs.getTypedValues(criteria, criteriaQuery);
        TypedValue[] result = new TypedValue[lhstv.length + rhstv.length];
        System.arraycopy(lhstv, 0, result, 0, lhstv.length);
        System.arraycopy(rhstv, 0, result, lhstv.length, rhstv.length);
        return result;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return '(' + this.lhs.toSqlString(criteria, criteriaQuery) + ' ' + this.getOp() + ' ' + this.rhs.toSqlString(criteria, criteriaQuery) + ')';
    }

    public String getOp() {
        return this.op;
    }

    public String toString() {
        return this.lhs.toString() + ' ' + this.getOp() + ' ' + this.rhs.toString();
    }
}

