package jp.co.powerbeans.jdbcdebug.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimerTask;

import jp.co.powerbeans.jdbcdebug.sql.Driver;


/**
 * <p>プロジェクト名: JDBCDebug</p>
 * <p>タイトル: ValueCheckTask</p>
 * <p>説明: ValueCheckTaskタイマータスク</p>
 * <p>Created on 2003/11/11</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class ValueCheckTask extends TimerTask {

  private final String name;
  private final String sql;
  private final long interval;
  private final int type;
  private final String val;
  private final int intVal;
  
  private Connection con;
private PreparedStatement st;
  
	/**
     * コンストラクタ
     */
    public ValueCheckTask(String name, String sql, long interval, int type,
            String val) {
        super();

        this.name = name;
        this.sql = sql;
        this.interval = interval;
        this.type = type;
        this.val = val;
        
        int int_val = 0;
        try {
            int_val = Integer.parseInt(val);
        } catch (NumberFormatException e) {
        }
        this.intVal = int_val;
    }

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		
		// タスク実行
		// SQLを実行し、結果に対してTypeで値を確認
		
		long now = System.currentTimeMillis();
		Log.println("[ValueCheck] start " + name); 

    try {
		// 0. コネクションを持っていなかったら取得
		if (con == null) {
		    
    		Log.println("getting connection of " + name); 
        con = Driver.getDriverInstance().connectByConfirm();
        if (con == null) {
        		Log.println("connection is null. please wait.. " + name); 
            return ;
        }
		    st = con.prepareStatement(sql);
		    ConCheckMgr.removeChecker(con);
		}
		
		// 1. クエリー実行
		ResultSet rs = st.executeQuery();
		boolean match = false;
		int recnum = 0;
		ArrayList rlist = new ArrayList();
		while(rs.next()) {
		    HashMap map = new HashMap();
		    int cols = rs.getMetaData().getColumnCount();
		    for(int i = 1; i <= cols; i++) {
		        map.put(rs.getMetaData().getColumnName(i),
		                rs.getObject(i));
		    }
		    rlist.add(map);
		    recnum++;
		}
		
		
		switch(type) {
		case 1:
		    match = recnum < interval;
		    break;
		    
		case 2:
		    match = recnum <= interval;
		    break;
		    
		case 3:
		    match = recnum == interval;
		    break;
		    
		case 4:
		    match = recnum >= interval;
		    break;
		    
		case 5:
		    match = recnum > intVal;
		    break;
		    
		case 10:
		    match = rlist.size() > 0 && rlist.get(0) != null &&
		    rlist.get(0) instanceof String &&
		    ((String)rlist.get(0)).equals(val);
		    break;
		    
		case 12:
		    match = rlist.size() > 0 && rlist.get(0) != null &&
		    rlist.get(0) instanceof String &&
		    !((String)rlist.get(0)).equals(val);
		    break;
		    
		}
//		# 1 recnum < val, 2 recnum <= val, 3 recnum == val
//		# 4 recnum >= val, 5 recnum> val
//		# 10 row[0].equals(val) (row[0] == String)
//		# 11 !row[0].equals(val) (row[0] == String)
		
		// 3. マッチしたら出力
		if (match) {
		    Log.println("[ValueCheck] match condition ########（・∀・）###### check db:" + sql);
		}
		
    } catch (SQLException e) {
        e.printStackTrace();
    }
	}

/**
 * @return Returns the interval.
 */
public long getInterval() {
    return interval;
}
/**
 * @return Returns the name.
 */
public String getName() {
    return name;
}
/**
 * @return Returns the sql.
 */
public String getSql() {
    return sql;
}
/**
 * @return Returns the type.
 */
public int getType() {
    return type;
}
/**
 * @return Returns the val.
 */
public String getVal() {
    return val;
}
    /* (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();
        
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }
}
