package jp.co.powerbeans.jdbcdebug.util;

import java.util.HashMap;
import java.util.Timer;

/**
 * <p>プロジェクト名: JDBCDebug</p>
 * <p>タイトル: ValueCheckMgr</p>
 * <p>説明: ValueCheckMgrThread, Group を管理するクラス</p>
 * <p>Created on 2003/11/11</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public final class ValueCheckMgr {

	/** ValueCheck管理Map */
	private static HashMap conMap = new HashMap();
	
	private static Timer timer;
	
	public ValueCheckMgr() {
	    readProps();
	}
	private void readProps() {
	    // 全ValueCheckを起動
//			ResourceBundle bundle =
//					ResourceBundle.getBundle(Driver.JDBC_DEBUG_PROPERTY);
			
			String valcheck = "";
//	    try {
//	        valcheck = bundle.getString(Driver.KEY_VALUE_CHECK);
//	    } catch (RuntimeException e) {
//	        // 設定なし
//	        return;
//	    }
	    if (valcheck == null || valcheck.length() == 0) {
			    return;
			}

//			// Value.check
//			String[] vs = {valcheck};
//			//ArrayList list = new ArrayList();
//			for(int i = 0; i < vs.length; i++) {
//			    String keyp = Driver.KEY_VALUE_CHECK + "." + vs[i] + ".";
//			    ValueCheckTask vctask = new ValueCheckTask(
//			            vs[i],
//			            bundle.getString(keyp + "sql"),
//			            Long.parseLong(bundle.getString(keyp + "interval")),
//			            Integer.parseInt(bundle.getString(keyp + "type")),
//			            bundle.getString(keyp + "val")
//			            );
//			    addChecker(vctask);
//			}	    
	    
	}

	/**
	 * addChecker<BR>
	 * 新規コネクションが渡されたのでコネクション監視開始
	 * @param con 新規コネクション
	 */
	public static void addChecker(ValueCheckTask con) {

		// ValueChecker追加
		conMap.put(con.toString(), con);
		if (timer == null) {
		    timer = new Timer();
		}
		timer.schedule(con, 1000, con.getInterval());
	}

//	/**
//	 * closed<BR>
//	 * コネクションが閉じられたので監視を終了
//	 * @param rcon 既にcloseされたコネクション
//	 */
//	public static void closed(ValueCheck rcon) {
//		if (conMap.containsKey(rcon.toString())) {
//			// 管理Mapから削除
//			// 特にログには出力しない
//			
//			ConnectionDtl dtl = (ConnectionDtl)conMap.get(rcon.toString());
//			conMap.remove(rcon.toString());
//			dtl.setCon(null); // 一応クリア
//
//		} else {
//			// 管理Map に無いConnectionが渡された?
//			Log.println("[ConCheck] closed connection which jdbc debugger not checked.");
//		}
//	}

	/**
	 * getConMap<BR>
	 * @return
	 */
	public static HashMap getConMap() {
		return conMap;
	}

}
