package jp.co.powerbeans.jdbcdebug.util;

/**
 * <p>タイトル: Survey</p>
 * <p>説明: SQL実行前後情報保持クラス</p>
 * <p>Created on 2003/10/01</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class Survey {

	/** 実行前ms */
	long startMs;
	
	/** 実行直後ms */
	long endMs;
	
	/**
	 * コンストラクタ<BR>
	 * 作成と同時に実行前msを保持<BR>
	 * SQL実行直前にインスタンス化
	 */
	public Survey() {
		super();
		
		startMs = System.currentTimeMillis();
	}

	/**
	 * doEnd<BR>
	 * SQL実行直後にインスタンス化
	 * @return 自分自身
	 */
	public Survey doEnd() {
		
		endMs = System.currentTimeMillis();
		return this;
	}
	/**
	 * getEndMs<BR>
	 * @return
	 */
	public long getEndMs() {
		return endMs;
	}

	/**
	 * getStartMs<BR>
	 * @return
	 */
	public long getStartMs() {
		return startMs;
	}

}
