package jp.co.powerbeans.jdbcdebug.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;

import jp.co.powerbeans.jdbcdebug.util.Log;
import jp.co.powerbeans.jdbcdebug.util.Survey;


/**
 * <p>タイトル: Statement</p>
 * <p>説明: </p>
 * <p>Created on 2003/10/01</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class Statement implements java.sql.Statement {

	/** 実 Statement */
	java.sql.Statement st;
  
  /** バッチSQL */
  private ArrayList batchSqlList = new ArrayList();

	/**
	 * コンストラクタ
	 * @param statement
	 */
	Statement(java.sql.Statement statement) {

		st = statement;
	}

	/**
	 * コンストラクタ
	 */
	private Statement() {
		super();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#addBatch(java.lang.String)
	 */
	public void addBatch(String sql) throws SQLException {
		st.addBatch(sql);
    batchSqlList.add(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#cancel()
	 */
	public void cancel() throws SQLException {
		st.cancel();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#clearBatch()
	 */
	public void clearBatch() throws SQLException {
		st.clearBatch();
    batchSqlList.clear();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#clearWarnings()
	 */
	public void clearWarnings() throws SQLException {
		st.clearWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#close()
	 */
	public void close() throws SQLException {
		st.close();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, int)
	 */
	public boolean execute(String sql, int autoGeneratedKeys)
		throws SQLException {

		try {
			Survey s = new Survey();
			boolean r = st.execute(sql, autoGeneratedKeys);
			Log.printlnSqlLog("execute " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, int[])
	 */
	public boolean execute(String sql, int[] columnIndexes)
		throws SQLException {

		try {
			Survey s = new Survey();
			boolean r = st.execute(sql, columnIndexes);
			Log.printlnSqlLog("execute " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, java.lang.String[])
	 */
	public boolean execute(String sql, String[] columnNames)
		throws SQLException {

		try {
			Survey s = new Survey();
			boolean r = st.execute(sql, columnNames);
			Log.printlnSqlLog("execute " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String)
	 */
	public boolean execute(String sql) throws SQLException {

		try {
			Survey s = new Survey();
			boolean r = st.execute(sql);
			Log.printlnSqlLog("execute " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute" + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeBatch()
	 */
	public int[] executeBatch() throws SQLException {
    try {
      Survey s = new Survey();
      int[] c = st.executeBatch();

      // 実行したSQLを全て出力
      int i = 0;
      for(Iterator it = batchSqlList.iterator(); it.hasNext();i++) {
        Log.printlnSqlLog("executeBatch " + it.next() + ", result " + c[i], s.doEnd());
      }
      return c;
    
    } catch (SQLException e) {
      Log.printlnSqlExceptionLog("executeBatch ", e);
      throw e;
    } finally {
      batchSqlList.clear();
    }
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeQuery(java.lang.String)
	 */
	public ResultSet executeQuery(String sql) throws SQLException {

		try {
			Survey s = new Survey();
			ResultSet r = st.executeQuery(sql);
			Log.printlnSqlLog("executeQuery " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeQuery " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, int)
	 */
	public int executeUpdate(String sql, int autoGeneratedKeys)
		throws SQLException {

		try {
			Survey s = new Survey();
			int r = st.executeUpdate(sql, autoGeneratedKeys);
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, int[])
	 */
	public int executeUpdate(String sql, int[] columnIndexes)
		throws SQLException {

		try {
			Survey s = new Survey();
			int r = st.executeUpdate(sql, columnIndexes);
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, java.lang.String[])
	 */
	public int executeUpdate(String sql, String[] columnNames)
		throws SQLException {

		try {
			Survey s = new Survey();
			int r = st.executeUpdate(sql, columnNames);
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String)
	 */
	public int executeUpdate(String sql) throws SQLException {

		try {
			Survey s = new Survey();
			int r = st.executeUpdate(sql);
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd());
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getConnection()
	 */
	public Connection getConnection() throws SQLException {
		return st.getConnection();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getFetchDirection()
	 */
	public int getFetchDirection() throws SQLException {
		return st.getFetchDirection();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getFetchSize()
	 */
	public int getFetchSize() throws SQLException {
		return st.getFetchSize();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getGeneratedKeys()
	 */
	public ResultSet getGeneratedKeys() throws SQLException {
		return st.getGeneratedKeys();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMaxFieldSize()
	 */
	public int getMaxFieldSize() throws SQLException {
		return st.getMaxFieldSize();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMaxRows()
	 */
	public int getMaxRows() throws SQLException {
		return st.getMaxRows();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMoreResults()
	 */
	public boolean getMoreResults() throws SQLException {
		return st.getMoreResults();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMoreResults(int)
	 */
	public boolean getMoreResults(int current) throws SQLException {
		return st.getMoreResults();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getQueryTimeout()
	 */
	public int getQueryTimeout() throws SQLException {
		return st.getQueryTimeout();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSet()
	 */
	public ResultSet getResultSet() throws SQLException {
		return st.getResultSet();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetConcurrency()
	 */
	public int getResultSetConcurrency() throws SQLException {
		return st.getResultSetConcurrency();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetHoldability()
	 */
	public int getResultSetHoldability() throws SQLException {
		return st.getResultSetHoldability();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetType()
	 */
	public int getResultSetType() throws SQLException {
		return st.getResultSetType();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getUpdateCount()
	 */
	public int getUpdateCount() throws SQLException {
		return st.getUpdateCount();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getWarnings()
	 */
	public SQLWarning getWarnings() throws SQLException {
		return st.getWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setCursorName(java.lang.String)
	 */
	public void setCursorName(String name) throws SQLException {
		st.setCursorName(name);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setEscapeProcessing(boolean)
	 */
	public void setEscapeProcessing(boolean enable) throws SQLException {
		st.setEscapeProcessing(enable);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setFetchDirection(int)
	 */
	public void setFetchDirection(int direction) throws SQLException {
		st.setFetchDirection(direction);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setFetchSize(int)
	 */
	public void setFetchSize(int rows) throws SQLException {
		st.setFetchSize(rows);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setMaxFieldSize(int)
	 */
	public void setMaxFieldSize(int max) throws SQLException {
		st.setMaxFieldSize(max);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setMaxRows(int)
	 */
	public void setMaxRows(int max) throws SQLException {
		st.setMaxRows(max);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setQueryTimeout(int)
	 */
	public void setQueryTimeout(int seconds) throws SQLException {
		st.setQueryTimeout(seconds);
	}

}
