package jp.co.powerbeans.jdbcdebug.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

import jp.co.powerbeans.jdbcdebug.notify.NotifyUtil;
import jp.co.powerbeans.jdbcdebug.util.ConCheckMgr;
import jp.co.powerbeans.jdbcdebug.util.ConCheckTask;
import jp.co.powerbeans.jdbcdebug.util.Log;
import jp.co.powerbeans.jdbcdebug.util.ValueCheckMgr;


/**
 * <p>タイトル: Driver</p>
 * <p>説明: </p>
 * <p>Created on 2003/10/01</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class Driver implements java.sql.Driver {

	/** 実DB Driver */
	private java.sql.Driver rdb_driver;
	
	/** Propertyファイル名 */
//	public static final String JDBC_DEBUG_PROPERTY = "jdbcdebug";
	
	/** Property KEY Driver */
	static final String KEY_DRIVER = "jdDriver";
	
	/** Property KEY OutputType */
	public static final String KEY_OUTPUT_TYPE = "jdOutType";

	/** Property KEY OutputPrefix */
	public static final String KEY_OUTPUT_PREFIX = "jdPrefix";
	
	/** Property KEY SQL.check.regexp */
	public static final String KEY_SQL_CHECK_REGEXP = "SQL.check.regexp";

	/** DB value check props */
	public static final String KEY_VALUE_CHECK = "Value.check";
    
  /** これ以上接続しているとログに出力するコネクション時間 */
  public static final String KEY_OUTPUT_OVER_TIME = "jdConOverTime"; 
    
  /** チェック間隔 ms */
  public static final String KEY_INTERVAL_TIME = "jdConIntervalTime";
	
	/** confirm url (for ValueCheck) */
	private String confirm_url = "";
	
	/** confirm Props */
	private Properties confirm_props;
	
	/** driver instance */
	private static jp.co.powerbeans.jdbcdebug.sql.Driver driverInstance;
	
	/** ValueCheckMgr */
	private static ValueCheckMgr vm;

  /** ValueCheckMgr sync checker */
  private static final String VALUE_CHECK_SYNC = "";

  /** URL パラメータ */
	private Properties url_prop;

    static {
        Log.println("jdbcdebug driver loaded");
        try {
        	  DriverManager.registerDriver(new Driver());
            Log.println("jdbcdebug driver registered");
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    }
	/**
	 * コンストラクタ
	 */
	public Driver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		super();
//System.out.println("*************:Driver constracter");
//		ResourceBundle bundle =
//			ResourceBundle.getBundle(JDBC_DEBUG_PROPERTY);
//		
//System.out.println("*************:Driver bundle " + bundle);
//		String driver_name = bundle.getString(KEY_DRIVER);
//System.out.println("*************:Driver name " + driver_name);
//		
//		if (driver_name == null || driver_name.length() == 0) {
//			throw new RuntimeException(JDBC_DEBUG_PROPERTY + " driver_name = " + "\"" + driver_name + "\"");
//		}
//		
//		try {
//			rdb_driver = (java.sql.Driver) Class.forName(driver_name).newInstance();
//			if (driverInstance != null) {
//			    System.out.println("two JDBC Driver instance loaded in a JVM. static driver var has only new instance");
//			}
//			driverInstance = this;
//		} catch (ClassNotFoundException e) {
//			throw new ClassNotFoundException("Not found JDBC driver (Oracle, MySQL..)", e);
//		}
//		
//		if (vm == null) {
//		    synchronized(VALUE_CHECK_SYNC) {
//		    		if (vm == null) {
//		    				// start db value check
//		    				vm = new ValueCheckMgr();
//		    		}
//		    }
//		}
//		
		// リスナーがあれば通知
		NotifyUtil.onLoadDriver(this);
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#connect(java.lang.String, java.util.Properties)
	 */
	public Connection connect(String url, Properties info)
		throws SQLException {

    // URL解析取得
    this.url_prop = parseUrl(url);
    this.confirm_props = info;

    // ドライバ生成
    createDriver();
    
		return new jp.co.powerbeans.jdbcdebug.sql.Connection(rdb_driver.connect(url_prop.getProperty("url"), info));
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#acceptsURL(java.lang.String)
	 */
	public boolean acceptsURL(String url) throws SQLException {
		
    // URL解析取得
    this.url_prop = parseUrl(url);
    
    // ドライバ生成
    createDriver();

		return rdb_driver.acceptsURL(url_prop.getProperty("url"));
	}

	/**
     * URLプロパティの driver パラメータを元にドライバインスタンスを生成する
     * 既に生成済みの場合は生成済みのインスタンスを渡す
	 * @throws SQLException
	 */
	private void createDriver() throws SQLException {
    
		if (rdb_driver != null) {
			return;
    }
		String driver_name = url_prop.getProperty(KEY_DRIVER);
        
    if (driver_name == null || driver_name.length() == 0) {
       System.err.println("can't get driver_name in url (ex) jdbc:postgresql://localhost/TEST?driver=org.postgresql.Driver&Type=3&Prefix=#SQL#");  
    }
		
		try {
		  rdb_driver = (java.sql.Driver) Class.forName(driver_name).newInstance();
//		  if (driverInstance != null) {
//		      System.out.println("two JDBC Driver instance loaded in a JVM. static driver var has only new instance");
//		  }
		  driverInstance = this;
		} catch (Exception e) {
//      throw new ClassNotFoundException("Not found JDBC driver (Oracle, MySQL..)", e);
		    e.printStackTrace();
		    throw new SQLException(e.getMessage());
		}
	}

	/**
     * パラメータ
	 * @param url JDBC URL
	 * @return パラメータ解析結果
	 */
	private Properties parseUrl(String url) {
    
    Properties prop = new Properties();
    
    if (url == null || url.length() == 0) {
     return prop;   
    }
    
    String[] keyvals = url.split("\\?");
    if (keyvals == null) {
     return prop;   
    }
    if (keyvals.length > 0) {
    	prop.setProperty("url", keyvals[0]);
    }
    if (keyvals.length > 1) {
    	keyvals = keyvals[1].split("&");
    }

    for(int i = 0; i < keyvals.length; i++) {
     String[] keyval = keyvals[i].split("=");
     if (keyval != null && keyval.length >= 2) {
     	prop.setProperty(keyval[0], keyval[1]);
     }
    }
    
    // jdbcdebugger 以外のパラメータでurlを再度構築する
    StringBuffer buf = new StringBuffer(prop.getProperty("url"));
		int c = 0;
		for (int i = 0; i < keyvals.length; i++) {
			if (!keyvals[i].startsWith("jd")) {
				if (c++ == 0) {
					buf.append("?");
				} else {
					buf.append("&");
				}
				buf.append(keyvals[i]);
			}
		}
    prop.setProperty("url", buf.toString());

    // 各パラメータ設定
    this.confirm_url = prop.getProperty("url");
    Log.applyProperties(prop);
    ConCheckTask.applyProperties(prop);
    ConCheckMgr.initTimer();
    
    return prop;
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#getPropertyInfo(java.lang.String, java.util.Properties)
	 */
	public DriverPropertyInfo[] getPropertyInfo(String url, Properties info)
		throws SQLException {
		
		return rdb_driver.getPropertyInfo(url, info);
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#getMajorVersion()
	 */
	public int getMajorVersion() {
		
		return rdb_driver.getMajorVersion();
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#getMinorVersion()
	 */
	public int getMinorVersion() {

		return rdb_driver.getMinorVersion();
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#jdbcCompliant()
	 */
	public boolean jdbcCompliant() {
		return rdb_driver.jdbcCompliant();
	}

	/* (non-Javadoc)
	 * @see java.sql.Driver#connect(java.lang.String, java.util.Properties)
	 */
	public Connection connectByConfirm()
		throws SQLException {
			
	    if (confirm_url != null && confirm_props != null) {
	        return new jp.co.powerbeans.jdbcdebug.sql.Connection(rdb_driver.connect(confirm_url, confirm_props));
	    } else {
	        return null;
	    }
	}

    /**
     * @return Returns the driverInstance.
     */
    public static jp.co.powerbeans.jdbcdebug.sql.Driver getDriverInstance() {
        return driverInstance;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        NotifyUtil.onUnloadDriver(this);
        
        super.finalize();
    }

    /**
     * @return url_prop を戻します。
     */
    public Properties getUrl_prop() {
    	return url_prop;
    }
}
