package jp.co.powerbeans.jdbcdebug.sql;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

import jp.co.powerbeans.jdbcdebug.notify.NotifyUtil;
import jp.co.powerbeans.jdbcdebug.util.ConCheckMgr;


/**
 * <p>タイトル: Connection</p>
 * <p>説明: Connection 実装</p>
 * <p>Created on 2003/10/01</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class Connection implements java.sql.Connection {

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        if (rcon != null) {
            return rcon.toString();
        } else {
            return super.toString();
        }
    }
    
	/** 実DB Connection */
	private java.sql.Connection rcon;
	
	/**
	 * コンストラクタ
	 */
	Connection(java.sql.Connection con) {
		super();

		rcon = con;

		ConCheckMgr.addChecker(con);
		NotifyUtil.onConnection(Driver.getDriverInstance(), this);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement()
	 */
	public Statement createStatement() throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.Statement(rcon.createStatement());
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String)
	 */
	public PreparedStatement prepareStatement(String sql) throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			rcon.prepareStatement(sql),
			sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String)
	 */
	public CallableStatement prepareCall(String sql) throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.CallableStatement(
			rcon.prepareCall(sql));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#nativeSQL(java.lang.String)
	 */
	public String nativeSQL(String sql) throws SQLException {

		return rcon.nativeSQL(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setAutoCommit(boolean)
	 */
	public void setAutoCommit(boolean autoCommit) throws SQLException {

		rcon.setAutoCommit(autoCommit);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getAutoCommit()
	 */
	public boolean getAutoCommit() throws SQLException {

		return rcon.getAutoCommit();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#commit()
	 */
	public void commit() throws SQLException {

		rcon.commit();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#rollback()
	 */
	public void rollback() throws SQLException {

		rcon.rollback();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#close()
	 */
	public void close() throws SQLException {

		rcon.close();
		ConCheckMgr.closed(rcon);
		NotifyUtil.onConnectionClose(Driver.getDriverInstance(), this);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#isClosed()
	 */
	public boolean isClosed() throws SQLException {

		if (rcon != null) {
			return rcon.isClosed();
		} else {
			return true;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getMetaData()
	 */
	public DatabaseMetaData getMetaData() throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.DatabaseMetaData(
			rcon.getMetaData());
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean readOnly) throws SQLException {

		rcon.setReadOnly(readOnly);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#isReadOnly()
	 */
	public boolean isReadOnly() throws SQLException {

		return rcon.isReadOnly();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setCatalog(java.lang.String)
	 */
	public void setCatalog(String catalog) throws SQLException {

		rcon.setCatalog(catalog);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getCatalog()
	 */
	public String getCatalog() throws SQLException {

		return rcon.getCatalog();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setTransactionIsolation(int)
	 */
	public void setTransactionIsolation(int level) throws SQLException {

		rcon.setTransactionIsolation(level);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getTransactionIsolation()
	 */
	public int getTransactionIsolation() throws SQLException {

		return rcon.getTransactionIsolation();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getWarnings()
	 */
	public SQLWarning getWarnings() throws SQLException {

		return rcon.getWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#clearWarnings()
	 */
	public void clearWarnings() throws SQLException {

		rcon.clearWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement(int, int)
	 */
	public Statement createStatement(
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.Statement(
			rcon.createStatement(resultSetType, resultSetConcurrency));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			rcon.prepareStatement(sql, resultSetType, resultSetConcurrency),
			sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int)
	 */
	public CallableStatement prepareCall(
		String sql,
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.CallableStatement(
			rcon.prepareCall(sql, resultSetType, resultSetConcurrency));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getTypeMap()
	 */
	public Map getTypeMap() throws SQLException {

		return rcon.getTypeMap();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setTypeMap(java.util.Map)
	 */
	public void setTypeMap(Map map) throws SQLException {

		rcon.setTypeMap(map);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setHoldability(int)
	 */
	public void setHoldability(int holdability) throws SQLException {

		rcon.setHoldability(holdability);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#getHoldability()
	 */
	public int getHoldability() throws SQLException {

		return rcon.getHoldability();
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setSavepoint()
	 */
	public Savepoint setSavepoint() throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.Savepoint(rcon.setSavepoint());
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#setSavepoint(java.lang.String)
	 */
	public Savepoint setSavepoint(String name) throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.Savepoint(rcon.setSavepoint(name));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#rollback(java.sql.Savepoint)
	 */
	public void rollback(Savepoint savepoint) throws SQLException {

		rcon.rollback(savepoint);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#releaseSavepoint(java.sql.Savepoint)
	 */
	public void releaseSavepoint(Savepoint savepoint) throws SQLException {

		rcon.releaseSavepoint(savepoint);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement(int, int, int)
	 */
	public Statement createStatement(
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.Statement(
			rcon.createStatement(
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			rcon.prepareStatement(
				sql,
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability),
			sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int, int)
	 */
	public CallableStatement prepareCall(
		String sql,
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.CallableStatement(
			rcon.prepareCall(
				sql,
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability));
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int autoGeneratedKeys)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			rcon.prepareStatement(sql, autoGeneratedKeys),
			sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int[])
	 */
	public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			prepareStatement(sql, columnIndexes),
			sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, java.lang.String[])
	 */
	public PreparedStatement prepareStatement(String sql, String[] columnNames)
		throws SQLException {

		return new jp.co.powerbeans.jdbcdebug.sql.PreparedStatement(
			prepareStatement(sql, columnNames),
			sql);
	}

}
