package jp.co.powerbeans.jdbcdebug.notify;

import java.sql.SQLException;

import jp.co.powerbeans.jdbcdebug.sql.Driver;
import jp.co.powerbeans.jdbcdebug.util.Survey;


/**
 * タイトル: JDBCDebug<BR>
 * 説明:     <BR>
 * 著作権:   Copyright (c) 2004 amonden<BR>
 * 会社名:   <BR>
 * @author   amonden<BR>
 * @version $Revision: 1.1 $
 * 修正履歴
 *   $Log: NotifyUtil.java,v $
 *   Revision 1.1  2005/08/24 13:45:44  amsoft
 *   submit for JNDI
 * 
 */

public final class NotifyUtil {

    /**
     * 
     */
    private NotifyUtil() {
        super();
    }

    /**
     * @param driver
     * @author  amonden
     */
    public static void onLoadDriver(Driver driver) {
        
        JDBCEventNotifyFactory.getInstance().onLoadDriver(driver);
    }
    
    /**
     * @param driver
     * @author  amonden
     */
    public static void onUnloadDriver(Driver driver) {
        
        JDBCEventNotifyFactory.getInstance().onUnloadDriver(driver);
    }

    /**
     * @param driver
     * @param con
     * @author  amonden
     */
    public static void onConnection(Driver driver, jp.co.powerbeans.jdbcdebug.sql.Connection con) { 
        
        JDBCEventNotifyFactory.getInstance().onConnection(driver, con);
    }

    /**
     * @param driver
     * @param con
     * @author  amonden
     */
    public static void onConnectionClose(Driver driver, jp.co.powerbeans.jdbcdebug.sql.Connection con) { 
        
        JDBCEventNotifyFactory.getInstance().onConnectionClose(driver, con);
    }

    /**
     * @param driver
     * @param sql
     * @param survey
     * @author  amonden
     */
    public static void onExecuteSql(Driver driver, String sql, Survey survey) {
        
        JDBCEventNotifyFactory.getInstance().onExecuteSql(driver, sql, survey);
        
    }

    /**
     * @param driver
     * @param sql
     * @param e
     * @author  amonden
     */
    public static void onExecuteSqlException(Driver driver, String sql, SQLException e) { 
        
        JDBCEventNotifyFactory.getInstance().onExecuteSqlException(driver, sql, e);
        
    }


}
