/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;

public class LOBStoredProcedure {
    public static final int MAX_RETURN_LENGTH = 32672;

    public static int CLOBCREATELOCATOR() throws SQLException {
        EngineLOB engineLOB = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createClob());
        return engineLOB.getLocator();
    }

    public static void CLOBRELEASELOCATOR(int n) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n);
        if (clob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        EmbedClob embedClob = (EmbedClob)clob;
        embedClob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(n);
    }

    public static long CLOBGETPOSITIONFROMSTRING(int n, String string, long l) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).position(string, l);
    }

    public static long CLOBGETPOSITIONFROMLOCATOR(int n, int n2, long l) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).position(LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2), l);
    }

    public static long CLOBGETLENGTH(int n) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).length();
    }

    public static String CLOBGETSUBSTRING(int n, long l, int n2) throws SQLException {
        n2 = Math.min(n2, 32672);
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).getSubString(l, n2);
    }

    public static void CLOBSETSTRING(int n, long l, int n2, String string) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).setString(l, string, 0, n2);
    }

    public static void CLOBTRUNCATE(int n, long l) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n).truncate(l);
    }

    private static Clob getClobObjectCorrespondingtoLOCATOR(int n) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n);
        if (clob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return clob;
    }

    public static int BLOBCREATELOCATOR() throws SQLException {
        EngineLOB engineLOB = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createBlob());
        return engineLOB.getLocator();
    }

    public static void BLOBRELEASELOCATOR(int n) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        EmbedBlob embedBlob = (EmbedBlob)blob;
        embedBlob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(n);
    }

    public static long BLOBGETPOSITIONFROMLOCATOR(int n, int n2, long l) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).position(LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2), l);
    }

    public static long BLOBGETPOSITIONFROMBYTES(int n, byte[] byArray, long l) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).position(byArray, l);
    }

    public static long BLOBGETLENGTH(int n) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).length();
    }

    public static byte[] BLOBGETBYTES(int n, long l, int n2) throws SQLException {
        n2 = Math.min(n2, 32672);
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).getBytes(l, n2);
    }

    public static void BLOBSETBYTES(int n, long l, int n2, byte[] byArray) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).setBytes(l, byArray, 0, n2);
    }

    public static void BLOBTRUNCATE(int n, long l) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n).truncate(l);
    }

    private static Blob getBlobObjectCorrespondingtoLOCATOR(int n) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return blob;
    }

    private static EmbedConnection getEmbedConnection() throws SQLException {
        return (EmbedConnection)DriverManager.getConnection("jdbc:default:connection");
    }

    private static SQLException newSQLException(String string) {
        return Util.generateCsSQLException(string);
    }
}

