name 'zookeeper-colo00'
description 'ZooKeeper colo00 node'

run_list(
  'role[zookeeper]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

ensemble = {
  '0' => {
    :hostname => 'zk00.grid.example.com',
    :leader_port => '2888',
    :election_port => '3888'
  },
  '1' => {
    :hostname => 'zk01.grid.example.com',
    :leader_port => '2888',
    :election_port => '3888'
  },
  '2' => {
    :hostname => 'zk02.grid.example.com',
    :leader_port => '2888',
    :election_port => '3888'
  }
}

default_attributes(
  'zookeeper' => {
    'run_mode' => 'full-replicated',
    'colo_name' => 'colo00',
    'dataLogDir' => '/grid/vol/1/var/lib/zookeeper',
    'ensemble' => ensemble
  }
)

#override_attributes "apache2" => { "max_children" => "50" }
