name 'pleiades-nm'
description 'Pleiades nagios node'

run_list(
  'role[grid-realm]',
  'role[ganglia-gmond]'
)

mcast_addr = '239.2.11.2'
port = '8649'

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'Nagios',
      'owner' => 'grid.example.com'
    },
    'static' => {
      ## static multi-cast
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => [
        {
          'mcast_join' => '',
          'host' => "nm00.#{this.domain}",
          'port' => port,
          'ttl' => ''
        },
        {
          'mcast_join' => '',
          'host' => "nm01.#{this.domain}",
          'port' => port,
          'ttl' => ''
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
