require 'rubygems'
# [chef-workstation]$ sudo /opt/chef/embedded/bin/gem install bracecomp
# String.expand()
require 'bracecomp'

name 'grid-realm'
description 'The Grid realm configurations.'

run_list(
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

this_realm = 'GRID.EXAMPLE.COM'
this_domain = 'grid.example.com'
default_attributes(
  'grid' => {
    'realms' => {
      this_realm => {
        'colocation' => 'colo00',
        'domain' => this_domain,
        'clusters' => {
          'grid-base' => {
            'Admin' => {
              'nodes' => 'adm0{0..1}'.expand
            },
            'ProvisioningMaster' => {
              'nodes' => 'gpm0{0..1}'.expand
            },
            'NameService' => {
              'nodes' => 'ns0{0..1}'.expand
            },
            'ZooKeeper' => {
              'nodes' => 'zk0{0..2}'.expand
            },
            'Ganglia' => {
              'nodes' => 'gm9{0..1}'.expand
            },
            'Nagios' => {
              'nodes' => 'nm9{0..1}'.expand
            },
          },
          'pleiades' => {
            'NameNode' => {
              'nodes' => 'nn0{0..1}'.expand
            },
            'ResourceManager' => {
              'nodes' => 'rm0{0..1}'.expand
            },
            'JobTracker' => {
              'nodes' => 'jt0{0..1}'.expand
            },
            'JobHistory' => {
              'nodes' => 'jh0{0..1}'.expand
            },
            'HBaseMaster' => {
              'nodes' => 'hm0{0..1}'.expand
            },
            'DataNode' => {
              'nodes' => 'dn0000{0..1}'.expand
            },
            'Gateway' => {
              'nodes' => 'gw0{0..1}'.expand
            },
            'Workflow' => {
              'nodes' => 'wf0{0..1}'.expand
            },
            'Proxy' => {
              'nodes' => 'pxy0{0..1}'.expand
            },
            'Meta' => {
              'nodes' => 'meta0{0..1}'.expand
            },
            'Ganglia' => {
              'nodes' => 'gm0{0..1}'.expand
            },
            'Nagios' => {
              'nodes' => 'nm0{0..1}'.expand
            },
          }
        }
      }
    }
  }
)

override_attributes(
  'krb5' => {
    'libdefaults' => {
      'default_realm' => this_realm,
      # strong crypto
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
      # or weak crypto for 1.0.x KSSL
      #'allow_weak_crypto' => 'true',
      #'default_tgs_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'default_tkt_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'permitted_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    },
    'realms' => {
      this_realm => {
        'kdcs' => "ns0{0..2}.#{this_domain}".expand,
        'admin_server' => "krb-admin.#{this_domain}"
      }
    },
    'domain_realms' => [
      ".#{this_domain} = #{this_realm}"
    ]
  },
  'hadoop' => {
    # for 1.0.x KSSL on the JDK 6 only >>
    'krb5_strong_crypto' => {
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
    },
    'krb5_weak_crypto' => {
      'default_tgs_enctypes' \
        => 'des-cbc-crc des-cbc-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    }
    # <<
  }
)
