#
# Cookbook Name:: hadoop
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# default: for pseudo-distributed
default['hadoop']['install_flavor'] = 'apache'
# 1.0.0 <= version < 1.2
default['hadoop']['version'] = '1.1.2'
default['hadoop']['archive_url'] = 'http://archive.apache.org/dist/hadoop/core'
default['hadoop']['with_security'] = false
## hadoop-env.sh
default['hadoop']['HADOOP_PREFIX'] = "#{node['grid']['app_root']}/hadoop"
default['hadoop']['HADOOP_CLASSPATH'] = ''
default['hadoop']['HADOOP_USER_CLASSPATH_FIRST'] = false
## hadoop-policy.xml
default['hadoop']['security.refresh.policy.protocol.acl'] = 'hdfs,mapred hadoop'
default['hadoop']['security.admin.operation.protocol.acl'] = 'hdfs,mapred hadoop'
## core-site.xml
default['hadoop']['this.cluster.name'] = 'localhost' 
default['hadoop']['this.domain'] = 'localhost'
default['hadoop']['this.realm'] = 'LOCALDOMAIN'
default['hadoop']['this.keytab.dir'] = "#{node['grid']['etc_root']}/keytabs/#{node['hadoop']['this.cluster.name']}"
default['hadoop']['this.namenode.fqdn'] = 'localhost'
default['hadoop']['fs.checkpoint.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/checkpoint"
default['hadoop']['hadoop.security.group.mapping'] = 'org.apache.hadoop.security.JniBasedUnixGroupsMapping'
default['hadoop']['hadoop.http.filter.initializers'] = 'org.apache.hadoop.security.AuthenticationFilterInitializer'
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/localhost@${this.realm}'
default['hadoop']['hadoop.proxyuser'] = {
  'oozie' => {
    'hosts' => 'localhost',
    'groups' => 'hadoopers'
  },
  'httpfs' => {
    'hosts' => 'localhost',
    'groups' => 'hadoopers'
  }
}
## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = 'localhost'
default['hadoop']['dfs.name.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/name"
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/localhost@${this.realm}'
default['hadoop']['dfs.replication'] = '1'
default['hadoop']['dfs.cluster.administrators'] = ' hdfs'
## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = 'localhost'
default['hadoop']['this.jobhistory.fqdn'] = 'localhost'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/localhost@${this.realm}'
default['hadoop']['mapreduce.history.server.embedded'] = true
default['hadoop']['mapred.job.tracker.persist.jobstatus.active'] = 'true'
default['hadoop']['mapred.job.tracker.persist.jobstatus.hours'] = '3'
default['hadoop']['mapreduce.cluster.administrators'] = ' mapred'
default['hadoop']['mapred.task.tracker.task-controller'] = 'org.apache.hadoop.mapred.LinuxTaskController'
## mapred-queue-acls.xml
default['hadoop']['mapred.queue.default.acl-submit-job'] = '*'
default['hadoop']['mapred.queue.default.acl-administer-jobs'] = ' hadoop,gridops'
## taskcontroller.cfg
### e.g. CentOS: 500
default['hadoop']['taskcontroller']['min.user.id'] = '1000'
# hadoop-metrics2.properties
default['hadoop']['metrics2']['*.sink.ganglia.class'] = 'org.apache.hadoop.metrics2.sink.ganglia.GangliaSink31'
default['hadoop']['metrics2']['*.sink.ganglia.period'] = '10'
default['hadoop']['metrics2']['*.sink.ganglia.supportsparse'] = 'false'
default['hadoop']['metrics2']['*.sink.ganglia.slope'] = 'jvm.metrics.gcCount=zero,jvm.metrics.memHeapUsedM=both'
default['hadoop']['metrics2']['*.sink.ganglia.dmax'] = 'jvm.metrics.threadsBlocked=70,jvm.metrics.memHeapUsedM=40'
# e.g. default['hadoop']['metrics2']['.sink.ganglia.servers'] = 'addredd1:port1,address2:port2,...'
# '': off
default['hadoop']['metrics2']['namenode.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['datanode.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['jobtracker.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['tasktracker.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['maptask.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['reducetask.sink.ganglia.servers'] = ''
## for 1.0.x KSSL on the JDK 6 only
default['hadoop']['krb5_strong_crypto'] = {
  'default_tgs_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
  'default_tkt_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
  'permitted_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
}
default['hadoop']['krb5_weak_crypto'] = {
  'default_tgs_enctypes' \
    => 'des-cbc-crc des-cbc-md5',
  'default_tkt_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
  'permitted_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
}
## extra settings
default['hadoop']['extra_configs'] = {
  # e.g. 'core-site.xml' => {'k1' => 'v1', 'k2' => 'v2'},
  'hadoop-env.sh' => {},
  'core-site.xml' => {},
  'hdfs-site.xml' => {
    # with HBase
    #'dfs.support.append' => 'true',
    #'truenode.max.xcievers' => '4096'
  },
  'mapred-site.xml' => {}
}
#default['hadoop'][''] = 

=begin
# e.g. for full-distributed 
default['grid']['max_vol_nums'] = '4'
## hadoop-env.sh
default['hadoop']['HADOOP_CLASSPATH'] = '/usr/share/java/commons-daemon.jar'
default['hadoop']['HADOOP_USER_CLASSPATH_FIRST'] = true
## core-site.xml
default['hadoop']['this.cluster.name'] = 'pleiades' 
default['hadoop']['this.domain'] = 'grid.example.com'
default['hadoop']['this.realm'] = 'GRID.EXAMPLE.COM'
default['hadoop']['this.keytab.dir'] = '/grid/etc/keytabs/${this.cluster.name}'
default['hadoop']['this.namenode.fqdn'] = '${this.cluster.name}-nn.${this.domain}'
default['hadoop']['fs.checkpoint.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint"
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/${this.fqdn}@${this.realm}'
## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = '${this.cluster.name}-cn.${this.domain}'
default['hadoop']['dfs.name.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name"
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/_HOST@${this.realm}'
default['hadoop']['dfs.replication'] = '3'
## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
#default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jh.${this.domain}'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/_HOST@${this.realm}'
#default['hadoop'][''] =
=end
