#
# Cookbook Name:: hadoop
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# default: for pseudo-distributed
default['hadoop']['with_security'] = false
## core-site.xml
default['hadoop']['this.cluster.name'] = 'localhost' 
default['hadoop']['this.domain'] = 'localhost'
default['hadoop']['this.realm'] = 'LOCALDOMAIN'
default['hadoop']['this.keytab.dir'] = "/grid/etc/keytabs/#{default['hadoop']['this.cluster.name']}"
default['hadoop']['this.namenode.fqdn'] = 'localhost'
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/localhost@${this.realm}'
## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = 'localhost'
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/localhost@${this.realm}'
default['hadoop']['dfs.replication'] = '1'
## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = 'localhost'
default['hadoop']['this.jobhistory.fqdn'] = 'localhost'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/localhost@${this.realm}'
#default['hadoop'][''] = 

=begin
# e.g. for full-distributed 
## core-site.xml
default['hadoop']['this.cluster.name'] = 'pleiades' 
default['hadoop']['this.domain'] = 'grid.example.com'
default['hadoop']['this.realm'] = 'GRID.EXAMPLE.COM'
default['hadoop']['this.keytab.dir'] = '/grid/etc/keytabs/${this.cluster.name}'
default['hadoop']['this.namenode.fqdn'] = '${this.cluster.name}-nn.${this.domain}'
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/${this.fqdn}@${this.realm}'
## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = '${this.cluster.name}-cn.${this.domain}'
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/_HOST@${this.realm}'
default['hadoop']['dfs.replication'] = '3'
## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
#default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jh.${this.domain}'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/_HOST@${this.realm}'
#default['hadoop'][''] =
=end
