dcos-grid Cookbook
==================

This cookbook sets up your customized DC/OS cluster on bare metal, virtual machines and every cloud. This install method is based on [_Advanced DC/OS Installation Guide_](https://dcos.io/docs/1.8/administration/installing/custom/advanced/).

## Contents

- [Requirements](#requirements)
  - [platforms](#platforms)
  - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [dcos-grid::default](#dcos-griddefault)
    - [dcos-grid::agent](#dcos-gridagent)
    - [dcos-grid::bootstrap](#dcos-gridbootstrap)
    - [dcos-grid::cli (ver. 0.3.0 or later)](#dcos-gridcli-ver-030-or-later)
    - [dcos-grid::cloud-config (for CoreOS only)](#dcos-gridcloud-config-for-coreos-only)
    - [dcos-grid::master](#dcos-gridmaster)
    - [dcos-grid::node](#dcos-gridnode)
    - [dcos-grid::node-commons](#dcos-gridnode-commons)
    - [dcos-grid::public-agent](#dcos-gridpublic-agent)
  - [Role Examples](#role-examples)
  - [Uninstall DC/OS](#uninstall-dcos)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- CentOS, Red Hat Enterprise Linux >= 7.2
- CoreOS Latest version.
- Ubuntu 16.04 (Experimental). DC/OS does not officially support Ubuntu yet. See [_Ubuntu 16.04 Enablement_](https://dcosjira.atlassian.net/browse/DCOS-25).
  - DC/OS requires systemd, which is only fully supported in Ubuntu 15.04 and later releases. See [_SystemdForUpstartUsers_](https://wiki.ubuntu.com/SystemdForUpstartUsers)

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['dcos-grid']['dcos_release_url']`|String|DC/OS download URL.|`'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh'`|
|`['dcos-grid']['dcos_cli_release_url']`|String|DC/OS CLI download URL (ver. 0.3.0 or later).|`'https://downloads.dcos.io/binaries/cli/linux/x86-64/0.4.10/dcos'`|
|`['dcos-grid']['docker']['apt_repo']['url']`|String| (ver. 0.3.1 or later)|`'https://apt.dockerproject.org/repo'`|
|`['dcos-grid']['docker']['apt_repo']['keyserver']`|String| (ver. 0.3.1 or later)|`'hkp://p80.pool.sks-keyservers.net:80'`|
|`['dcos-grid']['docker']['apt_repo']['recv-keys']`|String| (ver. 0.3.1 or later)|`'58118E89F3A912897C070ADBF76221572C52609D'`|
|`['dcos-grid']['docker']['yum_repo']['baseurl']`|String| (ver. 0.3.1 or later)|`'https://yum.dockerproject.org/repo/main/centos/$releasever/'`|
|`['dcos-grid']['docker']['yum_repo']['gpgcheck']`|String|`'0'`: disabled, `'1'`: enabled (ver. 0.3.1 or later).|`'1'`|
|`['dcos-grid']['docker']['yum_repo']['gpgkey']`|String| (ver. 0.3.1 or later)|`'https://yum.dockerproject.org/gpg'`|
|`['dcos-grid']['docker-engine']['setup']`|Boolean|Docker setup by this cookbook. If you will set up Docker by another cookbook, verify that this attribute is false. (ver. 0.3.0 or later)|`true`|
|`['dcos-grid']['docker-engine']['version_on_centos']`|String|Docker version for CentOS (ver. 0.3.0 or later).|`'1.11.2-1'`|
|`['dcos-grid']['docker-engine']['version_on_ubuntu']`|String|Docker version for Ubuntu (ver. 0.3.0 or later).|`'1.11.2-0'`|
|`['dcos-grid']['docker-engine']['version']`|String|Docker 1.9.x - 1.11.x is recommended for stability reasons. Note: this **default** value is overwritten by the `version_on_{centos or ubuntu}` (ver. 0.3.0 or later).|See default.rb|
|`['dcos-grid']['bootstrap']['ip']`|String|Bootstrap node IP address.|`'127.0.0.1'`|
|`['dcos-grid']['bootstrap']['port']`|String|Bootstrap node port number.|`'8080'`|
|`['dcos-grid']['bootstrap']['genconf_dir']`|String|genconf directory path.|`'/opt/dcos-grid/genconf'`|
|`['dcos-grid']['bootstrap']['config']`|Hash|Install configurations.|see [_Install Configuration Parameters_](https://dcos.io/docs/1.8/administration/installing/custom/configuration-parameters/)|
|`['dcos-grid']['bootstrap']['config']['bootstrap_url']`|String||`"http://#{node['dcos-grid']['bootstrap']['ip']}:#{node['dcos-grid']['bootstrap']['port']}"`|
|`['dcos-grid']['bootstrap']['config']['cluster_name']`|String||`'dcos0'`|
|`['dcos-grid']['bootstrap']['config']['exhibitor_storage_backend']`|String||`'static'`|
|`['dcos-grid']['bootstrap']['config']['ip_detect_filename']`|String||`'/genconf/ip-detect'`|
|`['dcos-grid']['bootstrap']['config']['master_list']`|Array|e.g. `['192.168.1.101','192.168.1.102','192.168.1.103']`|`nil`|
|`['dcos-grid']['bootstrap']['config']['resolvers']`|Array|e.g. `['8.8.8.8','8.8.4.4']` (Google DNS)|`nil`|
|`['dcos-grid']['bootstrap']['bootstrap']['ip-detect']['interface']`|String|Network interface on each node for the `ip-detect` script. Note: If you set comma-delimited interface list (e.g. `'eth0,enp0s3'`), the first detected interface's ip is adopted (ver. 0.3.0 or later). |`'eth0'`|
|`['dcos-grid']['node']['auto_setup']`|Boolean|execute the node setup script automatically or not.|`false`|
|`['dcos-grid']['cloud-config']['target_platform']`|String|CoreOS only now.|`'coreos'`|
|`['dcos-grid']['cloud-config']['target_dir']`|String||`'/home/core'`|
|`['dcos-grid']['cloud-config']['target_owner']`|String||`'core:core'`|
|`['dcos-grid']['cloud-config']['hostname']`|String||`'<fqdn>'`|
|`['dcos-grid']['cloud-config']['ssh_authorized_keys']`|Array||`['<your_ssh_pub_key>',]`|

## Usage

### Recipes

#### dcos-grid::default

This recipe does nothing.

#### dcos-grid::agent

This recipe sets up a private agent node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ /opt/dcos-grid/node_setup.sh slave
```

#### dcos-grid::bootstrap

This recipe sets up a bootstrap node. Note: Please execute the following manually.

```
$ /opt/dcos-grid/bootstrap_setup.sh
```

#### dcos-grid::cli (ver. 0.3.0 or later)

This recipe installs DC/OS CLI.

#### dcos-grid::cloud-config (for CoreOS only)

This recipe generates a `/opt/dcos-grid/cloud-config.yaml` template file on local machine by the following `chef-solo` command.

```
$ sudo chef-solo -c solo.rb -j nodes/local-dcos0-cloud-config.json
```

- `nodes/local-dcos0-cloud-config.json`

```json
{
  "run_list": [
    "role[dcos0-cloud-config]"
  ]
}
```

- `roles/dcos0-cloud-config.rb`

```ruby
name 'dcos0-cloud-config'
description 'dcos0 cloud-config.yaml file.'

run_list(
  'role[dcos0]',  # includes common attributes.
  'recipe[dcos-grid::cloud-config]',
)
```

Then edit this yaml template (hostname, ssh_authorized_keys, IP address and so on) and install CoreOS by the `cloud-config.yaml`.

```
$ coreos-cloudinit -from-file ~/cloud-config.yaml -validate
...
$ sudo coreos-install -d /dev/sda -C stable -c ~/cloud-config.yaml
```

#### dcos-grid::master

This recipe sets up a master node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ /opt/dcos-grid/node_setup.sh master
```

#### dcos-grid::node

This recipe sets up a base node (particular role is not assigned yet). Note: Please execute the following manually.

```
$ /opt/dcos-grid/node_setup.sh {master|slave|slave_public}
```

#### dcos-grid::node-commons

This recipe sets up common environment for DC/OS node.

#### dcos-grid::public-agent

This recipe sets up a public node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ /opt/dcos-grid/node_setup.sh slave_public
```

### Role Examples

- `roles/dcos0.rb`: Common attributes.

```ruby
name 'dcos0'
description 'dcos0 cluster'

run_list(
)

override_attributes(
  'dcos-grid' => {
    'dcos_release_url' => 'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh',
    'docker-engine' => {
      'version_on_centos' => '1.11.2-1',
      'version_on_ubuntu' => '1.11.2-0',
      #'version' => '1.11.2-1.el7.centos',
    },
    'bootstrap' => {
      'ip' => '192.168.56.100',
      'port' => '8080',
      'config' => {
        'cluster_name' => 'dcos0',
        'master_list' => [
          '192.168.56.101',
          '192.168.56.102',
          '192.168.56.103',
        ],
        'resolvers' => [
          '8.8.8.8',
          '8.8.4.4',
        ],
      },
      'ip-detect' => {
        'interface' => 'eth1,enp0s8',
      },
    },
    'node' => {
      'auto_setup' => false,
    },
  },
)
```

- `roles/dcos0-boot.rb`

```ruby
name 'dcos0-boot'
description 'dcos0 cluster bootstrap node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::bootstrap]',
)
```

- `roles/dcos-master.rb`

```ruby
name 'dcos0-master'
description 'dcos0 cluster master node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::master]',
)

override_attributes(
  'dcos-grid' => {
    'node' => {
      'auto_setup' => false,
    },
  },
)
```

- `roles/dcos0-agent.rb`

```ruby
name 'dcos0-agent'
description 'dcos0 cluster private agent node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::agent]',
)

override_attributes(
  'dcos-grid' => {
    'node' => {
      'auto_setup' => true,
    },
  },
)
```

### Uninstall DC/OS

Please log in each node and execute the following.

```
$ /opt/dcos-grid/uninstall.sh
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
