#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

cluster_name = 'ptolemy'
cluster_sym = cluster_name.to_sym

name "hadoop-#{cluster_name}"
description "#{cluster_name.capitalize} Hadoop cluster node"

run_list(
  'role[node_commons]',
  # LDAP (option)
  #'role[nameservice-client-grid]',
  'role[hadoop]'
)

#env_run_lists()

grid_vol_root = '/grid/vol'
hadoop_attributes = {
  # core-site.xml
  'this.cluster.name' => cluster_name, 
  'this.domain' => Grid::DOMAIN,
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint",
  #'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint",
  # hdfs-site.xml
  'this.secondary.namenode.fqdn' => '${this.cluster.name}-cn.${this.domain}',
  'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name",
  #'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name",
  'dfs.replication' => '2',
  #'dfs.replication' => '3',  # default, recommended.
  # mapred-site.xml
  'this.jobtracker.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  'this.jobhistory.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  #'this.jobhistory.fqdn' => '${this.cluster.name}-jh.${this.domain}',
  'extra_configs' => {
    # e.g. 'core-site.xml' => {'k1' => 'v1', 'k2' => 'v2'},
    'hadoop-env.sh' => {
      #'HADOOP_HEAPSIZE' => '2000',               # default: 1000 MB
      #'HADOOP_NAMENODE_INIT_HEAPSIZE' => '2000'  # default: 1000 MB (ver. 2.x)
      #'HADOOP_NAMENODE_OPTS' => '',
      #'HADOOP_SECONDARYNAMENODE_OPTS' => '',
      #'HADOOP_DATANODE_OPTS' => '',
      #'HADOOP_BALANCER_OPTS' => '',
      #'HADOOP_JOBTRACKER_OPTS' => '',
    },
    'yarn-env.sh' => {  # ver. 2.x
      #'YARN_HEAPSIZE' => '2000'  # default: 1000 MB
      #'YARN_RESOURCEMANAGER_OPTS' => '',
      #'YARN_NODEMANAGER_OPTS' => '',
    },
    'mapred-env.sh' => {  # ver. 2.x
      #'HADOOP_JOB_HISTORYSERVER_HEAPSIZE' => '2000',  # default: 1000 MB
      #'HADOOP_JOB_HISTORYSERVER_OPTS' => '',
    },
    'core-site.xml' => {
    },
    'hdfs-site.xml' => {
      'dfs.block.size' => '134217728',  # default: 67108864 (bytes)
      #'dfs.blocksize' => '134217728',  # default: 134217728 (bytes) (ver. 2.x)
      #'dfs.datanode.du.reserved' => '0',  # default: 0 (byte)
      # with HBase
      #'dfs.support.append' => 'true',
      #'dfs.datanode.max.xcievers' => '4096',  # default: 4096 (ver. 1.1 or later), 256 (older ver.)
      #'dfs.datanode.max.transfer.threads' => '4096',  # default: 4096 (ver. 2.x)
    },
    'yarn-site.xml' => {  # ver. 2.x
      #'yarn.nodemanager.resource.cpu-vcores' => '8',  # default: 8
      #'yarn.nodemanager.resource.memory-mb' => '8192',  # default: 8192
    },
    'mapred-site.xml' => {
      # map tasks:reduce tasks = 4:3 or 2:1 or ...
      'mapred.tasktracker.map.tasks.maximum' => '4',     # default: 2
      'mapred.tasktracker.reduce.tasks.maximum' => '2',  # default: 2
      #'mapred.child.java.opts' => '-Xmx1000m',           # default: -Xmx200m
      'mapred.reduce.slowstart.completed.maps' => '0.80',  # default: 0.05
      #'mapreduce.job.reduce.slowstart.completedmaps' => '0.80',  # default: 0.05 (ver. 2.x)
      #'tasktracker.http.threads' => '80',            # default: 40
      #'mapreduce.tasktracker.http.threads' => '80',  # default: 40 (ver. 2.x)
      #'mapred.reduce.parallel.copies' => SQRT(nodes),            # default: 5
      #'mapreduce.reduce.shuffle.parallelcopies' => SQRT(nodes),  # default: 5 (ver. 2.x)
      'mapred.submit.replication' => '2',                 # default: 10
      #'mapreduce.client.submit.file.replication' => '3',  # default: 10 (ver. 2.x)
    },
    'capacity-scheduler.xml' => {}
  }
}

#default_attributes()

override_attributes(
  'grid' => {
    'vol_root' => grid_vol_root,
    'max_vol_nums' => '4'
  },
  'hadoop' => hadoop_attributes
)

